package Cwd;
require 5.000;
require Exporter;
use Config;

@ISA = qw(Exporter);
@EXPORT = qw(getcwd fastcwd);
@EXPORT_OK = qw(chdir);


# This used to be written in perl; now we use a builtin function.
# (The perl version would stat files in each parent directory, which is
# slow and possibly prohibitive in a global distributed filesystem.)
#
# Usage: $cwd = getcwd();

sub getcwd {
    getcwd;
}

# This was a faster version of getcwd.  Now we use the builtin
# function.

sub fastcwd {
    getcwd;
}

# keeps track of current working directory in PWD environment var
#
# $RCSfile: Cwd.pm,v $$Revision: 1.2 $$Date: 1995/09/29 19:20:32 $
#
# $Log: Cwd.pm,v $
# Revision 1.2  1995/09/29  19:20:32  ghudson
# Use builtin getcwd function for getcwd() and fastcwd().
#
# Revision 1.1  1995/09/29  19:06:09  ghudson
# Initial revision
#
#
# Usage:
#	use Cwd 'chdir';
#	chdir $newdir;

$chdir_init = 0;

sub chdir_init{
    if ($ENV{'PWD'}) {
	my($dd,$di) = stat('.');
	my($pd,$pi) = stat($ENV{'PWD'});
	if (!defined $dd or !defined $pd or $di != $pi or $dd != $pd) {
	    chop($ENV{'PWD'} = `pwd`);
	}
    }
    else {
	chop($ENV{'PWD'} = `pwd`);
    }
    if ($ENV{'PWD'} =~ m|(/[^/]+(/[^/]+/[^/]+))(.*)|) {
	my($pd,$pi) = stat($2);
	my($dd,$di) = stat($1);
	if (defined $pd and defined $dd and $di == $pi and $dd == $pd) {
	    $ENV{'PWD'}="$2$3";
	}
    }
    $chdir_init = 1;
}

sub chdir {
    my($newdir) = shift;
    $newdir =~ s|/{2,}|/|g;
    chdir_init() unless $chdir_init;
    return 0 unless (CORE::chdir $newdir);
    if ($Config{'osname'} eq 'VMS') { return $ENV{PWD} = $ENV{DEFAULT} }

    if ($newdir =~ m#^/#) {
	$ENV{'PWD'} = $newdir;
    }else{
	my(@curdir) = split(m#/#,$ENV{'PWD'});
	@curdir = '' unless @curdir;
	foreach $component (split(m#/#, $newdir)) {
	    next if $component eq '.';
	    pop(@curdir),next if $component eq '..';
	    push(@curdir,$component);
	}
	$ENV{'PWD'} = join('/',@curdir) || '/';
    }
}

1;

