/*
** Copyright (c) 1990 David E. Smyth
**
** Redistribution and use in source and binary forms are permitted
** provided that the above copyright notice and this paragraph are
** duplicated in all such forms and that any documentation, advertising
** materials, and other materials related to such distribution and use
** acknowledge that the software was developed by David E. Smyth.  The
** name of David E. Smyth may not be used to endorse or promote products
** derived from this software without specific prior written permission.
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
** WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
** MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
*/

/******************************************************************************
**
** SCCS_data: @(#)Ari.c 1.0 ( 19 June 1990 )
**
** Description:	This file contains main() for a Athena Resource Interpreter
**		which allows prototype interfaces to be built from
**		resource files.  The Widget Creation library is used.
**
**              Besides the Athena widgets, Ari also knows about Table
**              widgets, simply because they are so dang useful!
**
** Notes:	This program uses the Xrm (X resource management) database
**		for widget tree definition and management.  This program
**		is dependent on the Athena widget set only because the
**		Athena classes and constructors are registered, which
**		causes the Athena libs to be linked in.  Someday I'll
**		get a shared lib version of Motif and the Athena widgets,
**		and even the OpenLook widget set, and then there will
**		be no reason that widgets could not be mixed and matched.
**		Doing that without shared libs makes for a HUGE executable.
**
******************************************************************************/

/******************************************************************************
**   Include_files.
******************************************************************************/

#include <X11/Intrinsic.h>
#include <ctype.h>
#include <WcCreate.h>

#include <Table.h>

/******************************************************************************
**  Private Functions
******************************************************************************/

extern void AriRegisterAthena ();

static void RegisterTable ( app )
    XtAppContext app;
{
#define RCN( name, class ) WcRegisterClassName ( app, name, class );
#define RCP( name, class ) WcRegisterClassPtr  ( app, name, class );

    RCN( "Table",		tableWidgetClass );
    RCP( "tableWidgetClass",	tableWidgetClass );

#undef  RCN
#undef  RCP
}

/******************************************************************************
*   MAIN function
******************************************************************************/

main ( argc, argv )
    int   argc;
    char* argv[];
{   
    char*        appClass;
    XtAppContext app;
    Widget       appShell;

    appClass = (char*) XtMalloc ( strlen ( argv[0] ) + 1 );
    strcpy (appClass, argv[0]);
    /* initialize first letter to make class, or first two if
    ** first is already capitalized, or don't worry about it.
    */
    if (islower(appClass[0]))
	appClass[0] = toupper(appClass[0]);
    else if (islower(appClass[1]))
        appClass[1] = toupper(appClass[1]);
    
    /*  -- Intialize Toolkit creating the application shell */
    appShell = XtInitialize ( 
	argv[0], appClass,		/* app name and class */
	NULL, 0, 			/* description of cmd line options */
	&argc, argv 
    );
    app = XtWidgetToApplicationContext(appShell);

    /*  -- Register all application specific callbacks and widget classes */
    RegisterTable ( app );

    /*  -- Register all Athena widget classes */
    AriRegisterAthena ( app );

    /*  -- Create widget tree below toplevel shell using Xrm database */
    WcWidgetCreation ( appShell );

    /*  -- Realize the widget tree and enter the main application loop */
    XtRealizeWidget ( appShell );
    XtMainLoop ( );
}
