/* mapping table of MathML elements */
#include "MathML.h"
static ElemMapping    MathMLElemMappingTable[] =
{
   /* This table MUST be in alphabetical order */
   {TEXT("XMLPI"), SPACE, MathML_EL_XMLPI, L_Other, FALSE},
   {TEXT("XMLPI_line"), SPACE, MathML_EL_XMLPI_line, L_Other, FALSE},
   {TEXT("XMLcomment"), SPACE, MathML_EL_XMLcomment, L_Other, FALSE},
   {TEXT("XMLcomment_line"), SPACE, MathML_EL_XMLcomment_line, L_Other, FALSE},
   {TEXT("maligngroup"), 'E', MathML_EL_MALIGNGROUP, L_Other, FALSE},
   {TEXT("malignmark"), 'E', MathML_EL_MALIGNMARK, L_Other, FALSE},
   {TEXT("math"), SPACE, MathML_EL_MathML, L_Other, FALSE},
   {TEXT("menclose"), SPACE, MathML_EL_MENCLOSE, L_Other, FALSE},
   {TEXT("merror"), SPACE, MathML_EL_MERROR, L_Other, FALSE},
   {TEXT("mf"), SPACE, MathML_EL_MF, L_Other, FALSE},  /* for compatibility with an old version of MathML: WD-math-970704 */
   {TEXT("mfenced"), SPACE, MathML_EL_MFENCED, L_Other, FALSE},
   {TEXT("mfrac"), SPACE, MathML_EL_MFRAC, L_Other, FALSE},
   {TEXT("mglyph"), 'E', MathML_EL_MGLYPH, L_Other, FALSE},
   {TEXT("mi"), SPACE, MathML_EL_MI, L_Other, FALSE},
   {TEXT("mlabeledtr"), SPACE, MathML_EL_MLABELEDTR, L_Other, FALSE},
   {TEXT("mmultiscripts"), SPACE, MathML_EL_MMULTISCRIPTS, L_Other, FALSE},
   {TEXT("mn"), SPACE, MathML_EL_MN, L_Other, FALSE},
   {TEXT("mo"), SPACE, MathML_EL_MO, L_Other, FALSE},
   {TEXT("mover"), SPACE, MathML_EL_MOVER, L_Other, FALSE},
   {TEXT("mpadded"), SPACE, MathML_EL_MPADDED, L_Other, FALSE},
   {TEXT("mphantom"), SPACE, MathML_EL_MPHANTOM, L_Other, FALSE},
   {TEXT("mprescripts"), SPACE, MathML_EL_PrescriptPairs, L_Other, FALSE},
   {TEXT("mroot"), SPACE, MathML_EL_MROOT, L_Other, FALSE},
   {TEXT("mrow"), SPACE, MathML_EL_MROW, L_Other, FALSE},
   {TEXT("ms"), SPACE, MathML_EL_MS, L_Other, FALSE},
   {TEXT("mspace"), 'E', MathML_EL_MSPACE, L_Other, FALSE},
   {TEXT("msqrt"), SPACE, MathML_EL_MSQRT, L_Other, FALSE},
   {TEXT("mstyle"), SPACE, MathML_EL_MSTYLE, L_Other, FALSE},
   {TEXT("msub"), SPACE, MathML_EL_MSUB, L_Other, FALSE},
   {TEXT("msubsup"), SPACE, MathML_EL_MSUBSUP, L_Other, FALSE},
   {TEXT("msup"), SPACE, MathML_EL_MSUP, L_Other, FALSE},
   {TEXT("mtable"), SPACE, MathML_EL_MTABLE, L_Other, FALSE},
   {TEXT("mtd"), SPACE, MathML_EL_MTD, L_Other, FALSE},
   {TEXT("mtext"), SPACE, MathML_EL_MTEXT, L_Other, FALSE},
   {TEXT("mtr"), SPACE, MathML_EL_MTR, L_Other, FALSE},
   {TEXT("munder"), SPACE, MathML_EL_MUNDER, L_Other, FALSE},
   {TEXT("munderover"), SPACE, MathML_EL_MUNDEROVER, L_Other, FALSE},
   {TEXT("none"), SPACE, MathML_EL_Construct, L_Other, FALSE},
   {TEXT("sep"), 'E', MathML_EL_SEP, L_Other, FALSE},
   {TEXT(""), SPACE, 0, L_Other, FALSE}	 /* Last entry. Mandatory */
};

static AttributeMapping MathMLAttributeMappingTable[] =
{
   /* The first entry MUST be unknown_attr */
   /* The rest of this table MUST be in alphabetical order */
   {TEXT("unknown_attr"), TEXT(""), 'A', MathML_ATTR_Invalid_attribute, L_Other},

   {TEXT("accent"), TEXT(""), 'A', MathML_ATTR_accent, L_Other},
   {TEXT("accentunder"), TEXT(""), 'A', MathML_ATTR_accentunder, L_Other},
   {TEXT("actiontype"), TEXT(""), 'A', MathML_ATTR_actiontype, L_Other},
   {TEXT("align"), TEXT(""), 'A', MathML_ATTR_align, L_Other},
   {TEXT("alignmentscope"), TEXT(""), 'A', MathML_ATTR_alignmentscope, L_Other},
   {TEXT("alt"), TEXT(""), 'A', MathML_ATTR_alt, L_Other},
   {TEXT("altimg"), TEXT(""), 'A', MathML_ATTR_altimg, L_Other},
   {TEXT("alttext"), TEXT(""), 'A', MathML_ATTR_alttext, L_Other},
   {TEXT("background"), TEXT(""), 'A', MathML_ATTR_background_, L_Other},
   {TEXT("bevelled"), TEXT(""), 'A', MathML_ATTR_bevelled, L_Other},
   {TEXT("class"), TEXT(""), 'A', MathML_ATTR_class, L_Other},
   {TEXT("close"), TEXT(""), 'A', MathML_ATTR_close, L_Other},
   {TEXT("columnalign"), TEXT(""), 'A', MathML_ATTR_columnalign, L_Other},
   {TEXT("columnlines"), TEXT(""), 'A', MathML_ATTR_columnlines, L_Other},
   {TEXT("columnspacing"), TEXT(""), 'A', MathML_ATTR_columnspacing, L_Other},
   {TEXT("columnspan"), TEXT(""), 'A', MathML_ATTR_columnspan, L_Other},
   {TEXT("columnwidth"), TEXT(""), 'A', MathML_ATTR_columnwidth, L_Other},
   {TEXT("color"), TEXT(""), 'A', MathML_ATTR_color, L_Other},
   {TEXT("denomalign"), TEXT(""), 'A', MathML_ATTR_denomalign, L_Other},
   {TEXT("depth"), TEXT(""), 'A', MathML_ATTR_depth_, L_Other},
   {TEXT("display"), TEXT(""), 'A', MathML_ATTR_display, L_Other},
   {TEXT("displaystyle"), TEXT(""), 'A', MathML_ATTR_displaystyle, L_Other},
   {TEXT("edge"), TEXT(""), 'A', MathML_ATTR_edge, L_Other},
   {TEXT("equalcolumns"), TEXT(""), 'A', MathML_ATTR_equalcolumns, L_Other},
   {TEXT("equalrows"), TEXT(""), 'A', MathML_ATTR_equalrows, L_Other},
   {TEXT("fence"), TEXT(""), 'A', MathML_ATTR_fence, L_Other},
   {TEXT("fontfamily"), TEXT(""), 'A', MathML_ATTR_fontfamily, L_Other},
   {TEXT("fontstyle"), TEXT(""), 'A', MathML_ATTR_fontstyle, L_Other},
   {TEXT("fontsize"), TEXT(""), 'A', MathML_ATTR_fontsize, L_Other},
   {TEXT("fontweight"), TEXT(""), 'A', MathML_ATTR_fontweight, L_Other},
   {TEXT("form"), TEXT(""), 'A', MathML_ATTR_form, L_Other},
   {TEXT("frame"), TEXT(""), 'A', MathML_ATTR_frame, L_Other},
   {TEXT("framespacing"), TEXT(""), 'A', MathML_ATTR_framespacing, L_Other},
   {TEXT("groupalign"), TEXT(""), 'A', MathML_ATTR_groupalign, L_Other},
   {TEXT("height"), TEXT(""), 'A', MathML_ATTR_height_, L_Other},
   {TEXT("id"), TEXT(""), 'A', MathML_ATTR_id, L_Other},
   {TEXT("index"), TEXT(""), 'A', MathML_ATTR_index, L_Other},
   {TEXT("largeop"), TEXT(""), 'A', MathML_ATTR_largeop, L_Other},
   {TEXT("linethickness"), TEXT(""), 'A', MathML_ATTR_linethickness, L_Other},
   {TEXT("lquote"), TEXT(""), 'A', MathML_ATTR_lquote, L_Other},
   {TEXT("lspace"), TEXT(""), 'A', MathML_ATTR_lspace, L_Other},
   {TEXT("macros"), TEXT(""), 'A', MathML_ATTR_macros, L_Other},
   {TEXT("maxsize"), TEXT(""), 'A', MathML_ATTR_maxsize, L_Other},
   {TEXT("minlabelspacing"), TEXT(""), 'A', MathML_ATTR_minlabelspacing, L_Other},
   {TEXT("minsize"), TEXT(""), 'A', MathML_ATTR_minsize, L_Other},
   {TEXT("mode"), TEXT(""), 'A', MathML_ATTR_display, L_Other},
   {TEXT("movablelimits"), TEXT(""), 'A', MathML_ATTR_movablelimits, L_Other},
   {TEXT("notation"), TEXT(""), 'A', MathML_ATTR_notation, L_Other},
   {TEXT("numalign"), TEXT(""), 'A', MathML_ATTR_numalign, L_Other},
   {TEXT("open"), TEXT(""), 'A', MathML_ATTR_open, L_Other},
   {TEXT("other"), TEXT(""), 'A', MathML_ATTR_other, L_Other},
   {TEXT("overflow"), TEXT(""), 'A', MathML_ATTR_overflow, L_Other},
   {TEXT("rowalign"), TEXT(""), 'A', MathML_ATTR_rowalign, L_Other},
   {TEXT("rowlines"), TEXT(""), 'A', MathML_ATTR_rowlines, L_Other},
   {TEXT("rowspacing"), TEXT(""), 'A', MathML_ATTR_rowspacing, L_Other},
   {TEXT("rowspan"), TEXT(""), 'A', MathML_ATTR_rowspan_, L_Other},
   {TEXT("rquote"), TEXT(""), 'A', MathML_ATTR_rquote, L_Other},
   {TEXT("rspace"), TEXT(""), 'A', MathML_ATTR_rspace, L_Other},
   {TEXT("scriptlevel"), TEXT(""), 'A', MathML_ATTR_scriptlevel, L_Other},
   {TEXT("scriptminsize"), TEXT(""), 'A', MathML_ATTR_scriptminsize, L_Other},
   {TEXT("scriptsizemultiplier"), TEXT(""), 'A', MathML_ATTR_scriptsizemultiplier, L_Other},
   {TEXT("selection"), TEXT(""), 'A', MathML_ATTR_selection, L_Other},
   {TEXT("separator"), TEXT(""), 'A', MathML_ATTR_separator, L_Other},
   {TEXT("separators"), TEXT(""), 'A', MathML_ATTR_separators, L_Other},
   {TEXT("side"), TEXT(""), 'A', MathML_ATTR_side, L_Other},
   {TEXT("stretchy"), TEXT(""), 'A', MathML_ATTR_stretchy, L_Other},
   {TEXT("style"), TEXT(""), 'A', MathML_ATTR_style_, L_Other},
   {TEXT("subscriptshift"), TEXT(""), 'A', MathML_ATTR_subscriptshift, L_Other},
   {TEXT("superscriptshift"), TEXT(""), 'A', MathML_ATTR_superscriptshift, L_Other},
   {TEXT("symmetric"), TEXT(""), 'A', MathML_ATTR_symmetric, L_Other},
   {TEXT("width"), TEXT(""), 'A', MathML_ATTR_width_, L_Other},
   {TEXT("xml:space"), TEXT(""), 'A', MathML_ATTR_xml_space, L_Other},
   {TEXT("xref"), TEXT(""), 'A', MathML_ATTR_xref, L_Other},
   {TEXT("zzghost"), TEXT(""), 'A', MathML_ATTR_Ghost_restruct, L_Other},

   {TEXT(""), TEXT(""), EOS, 0, L_Other}		/* Last entry. Mandatory */
};
