	{ Presentation Schema for XLink.

	  V. Quint		June 2000 }


PRESENTATION XLink;

VIEWS
   Formatted_view,
   Structure_view merge with Structure_view,
   Links_view merge with Links_view;

#define TAG_FONTSIZE 12 pt
#define ATTR_Style Roman
#define ATTR_Weight Normal
#define ATTR_Visibility 6
#ifdef BLACK_WHITE
#define ATTR_Color Black
#define ATTRVALUE_Color Black
#else
#define ATTR_Color Blue
#define ATTRVALUE_Color Black
#endif

DEFAULT

   BEGIN
   Visibility: Enclosing =;
   VertRef: * . Left ;
   HorizRef: Enclosed . HRef;
   Height: Enclosed . Height;
   Width: Enclosed . Width;
   VertPos: HRef = Previous . HRef;
   HorizPos: Left = Previous . Right;
   LineBreak: No;
   Font: Enclosing =;
   Style: Roman;
   Weight: Enclosing =;
   Size: Enclosing =;
   Indent: 0;
   Justify: No;
   Adjust: Left;
   LineSpacing: 1;
   Depth : Enclosing =;
   UnderLine: Enclosing =;
   Thickness: Enclosing =;
   LineStyle: Enclosing =;
   LineWeight: Enclosing =;
   Background: Enclosing =;
   Foreground: Enclosing =;
   FillPattern: Enclosing =;
   IN Structure_view BEGIN
	VertPos: Top = Previous . Bottom;
	HorizPos: Left = Enclosing . Left;
	END;
   IN Links_view
	Visibility: 0;
   END;

BOXES

  ATTR_type_simple: BEGIN
        Content: Text ' xlink:type=simple';
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
                END;
	END;
  ATTR_type_extended: BEGIN
        Content: Text ' xlink:type=extended';
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
                END;
	END;
  ATTR_type_locator: BEGIN
        Content: Text ' xlink:type=locator';
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
                END;
	END;
  ATTR_type_arc: BEGIN
        Content: Text ' xlink:type=arc';
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
                END;
	END;
  ATTR_type_resource: BEGIN
        Content: Text ' xlink:type=resource';
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
                END;
	END;
  ATTR_type_title: BEGIN
        Content: Text ' xlink:type=title';
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
                END;
	END;

  ATTR_type_none: BEGIN
        Content: Text ' xlink:type=none';
        Visibility: 0;
        IN Structure_view BEGIN
                Visibility: ATTR_Visibility;
        	HorizPos: Left = Previous . Right;
        	VertPos: HRef = Previous . HRef;
        	Size: TAG_FONTSIZE;
        	Style: ATTR_Style; Weight: ATTR_Weight;
		Foreground: ATTR_Color;
		END;
	END;

  ATTR_href: BEGIN
        Content: Text ' xlink:href=';
        Size: TAG_FONTSIZE;
        Style: ATTR_Style; Weight: ATTR_Weight;
	Foreground: ATTR_Color;
        Visibility: 0;
        IN Structure_view BEGIN
                Visibility: ATTR_Visibility;
        	HorizPos: Left = Previous . Right;
        	VertPos: HRef = Previous . HRef;
		END;
	IN Links_view BEGIN
		Visibility: ATTR_Visibility;
        	HorizPos: Left = Enclosing . Left + 18 px;
        	VertPos: Top = Previous . Bottom + 3 px;
		END;
        END;

  VALUE_href: BEGIN
        Content: (href_);
        Size: TAG_FONTSIZE;
        Style: ATTR_Style;
	Weight: ATTR_Weight;
	Foreground: ATTRVALUE_Color;
        Visibility: 0;
        IN Structure_view BEGIN
                Visibility: ATTR_Visibility;
        	HorizPos: Left = Previous . Right;
        	VertPos: HRef = Previous . HRef;
		END;
	IN Links_view BEGIN
		Visibility: ATTR_Visibility;
        	HorizPos: Left = Previous . Right;
        	VertPos: HRef = Previous . HRef;
		END;
        END;

 Annot_gif1: BEGIN
#ifndef PAGE
	Content: Picture 'annot.gif';
        HorizRef: * . Bottom;	
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
   	IN Links_view
		Visibility: ATTR_Visibility;
#endif
	END;

 Annotorph_gif: BEGIN
#ifndef PAGE
 	Visibility: 0;
	Content: Picture 'annotorp.gif';
        HorizRef: * . Bottom;
	HorizPos: Left = Enclosing . Left;
	VertPos: Top = Enclosing . Top;
   	IN Links_view
		Visibility: ATTR_Visibility;
#endif
	END;

RULES

 XLink:	BEGIN
	IN Structure_view BEGIN
		Visibility: 0;
		END;
	IN Links_view
		BEGIN
		VertPos: Top = Previous AnyElem . Bottom;
		HorizPos: Left = Enclosing . Left;
		Visibility: 5;
		END;
	END;

ATTRIBUTES

  AnnotOrphIcon:
	BEGIN
	Visibility: 0;
        CreateFirst(Annotorph_gif);
	IN Links_view
		Visibility: 5;
	END;

  type = simple:
	BEGIN
	CreateBefore(ATTR_type_simple);
	Foreground: Blue;
	END;
  type = extended:
	BEGIN
	CreateBefore(ATTR_type_extended);
	END;
  type = locator:
	BEGIN
	CreateBefore(ATTR_type_locator);
	END;
  type = arc:
	BEGIN
	CreateBefore(ATTR_type_arc);
	END;
  type = resource:
	BEGIN
	CreateBefore(ATTR_type_resource);
	END;
  type = title_:
	BEGIN
	CreateBefore(ATTR_type_title);
	END;
  type = none_:
	BEGIN
	CreateBefore(ATTR_type_none);
	END;

  href_ :
	BEGIN
        CreateBefore(ATTR_href);
  	CreateBefore(VALUE_href);
        if AnnotIcon1
           CreateFirst(Annot_gif1);
   	IN Links_view
		Visibility: ATTR_Visibility;
	END;

  AnnotIsHidden :
	BEGIN
 	Visibility: 0;
	IN Structure_view
		Visibility: 0;
	IN Links_view
		Visibility: 5;
	END;

{****
   role = TEXT;

   title = TEXT;

   show = new, replace, embed, undefined;

   actuate = onLoad, onRequest, undefined;

   from = TEXT;

   to = TEXT;
****}

END
