#ifndef __LIGHT_H__
#define __LIGHT_H__

class Light
{
	public:
		virtual void Load(const XMLNode * n)=0;
		virtual Color4 IntensityAt(const Vector3D<> & pt)=0;
		
		//returns a normalized vector to the the specified point
		//Returning the distance seperately allows for infinite distance hacks :)
		virtual void VectorFrom(const Vector3D<> & pt, Vector3D<> & outv, double & distance)=0;
		
		virtual ~Light(){}
};

class PointLight : public Light
{
	private:
		Color4 Color;
		Vector3D<> Position;

	public:
		virtual void Load(const XMLNode * n);
		virtual Color4 IntensityAt(const Vector3D<> & pt);
		virtual void VectorFrom(const Vector3D<> & pt, Vector3D<> & outv, double & distance);
		virtual ~PointLight(){}
};

class SpotLight : public Light
{
	private:
		Color4 Color;
		Vector3D<> Position;
		Vector3D<> Direction;
		double Falloff;
	public:
		virtual void Load(const XMLNode * n);
		virtual Color4 IntensityAt(const Vector3D<> & pt);
		virtual void VectorFrom(const Vector3D<> & pt, Vector3D<> & outv, double & distance);
		virtual ~SpotLight(){}		
};

class DistantLight : public Light
{
	private:
		Color4 Color;
		Vector3D<> Position;	//The light is taken to be infinitely far away in this direction
	public:
		virtual void Load(const XMLNode * n);
		virtual Color4 IntensityAt(const Vector3D<> & pt) {return Color;}
		virtual void VectorFrom(const Vector3D<> & pt, Vector3D<> & outv, double & distance) {outv = Position;distance=1e999;}
		virtual ~DistantLight(){}
};

class JitteredPointLight : public Light
{
	private:
		Color4 Color;
		Vector3D<> MinPos;
		Vector3D<> MaxPos;

	public:
		virtual void Load(const XMLNode * n);
		virtual Color4 IntensityAt(const Vector3D<> & pt) {return Color;}
		virtual void VectorFrom(const Vector3D<> & pt, Vector3D<> & outv, double & distance);
		virtual ~JitteredPointLight(){}
};

#endif
