/**
 ** binio.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/



#include CONFIG

#include "binio.h"

void put_2bytes_lsb_first(void *ptr, Int x)
{
    unsigned char *cptr= ptr;

    cptr[0]= (unsigned char) (x >>  0);
    cptr[1]= (unsigned char) (x >>  8);
}

void put_2bytes_msb_first(void *ptr, Int x)
{
    char *cptr= ptr;

    cptr[0]= (unsigned char) (x >>  8);
    cptr[1]= (unsigned char) (x >>  0);
}

void put_4bytes_lsb_first(void *ptr, long x)
{
    char *cptr= ptr;

    cptr[0]= (unsigned char) (x >>  0);
    cptr[1]= (unsigned char) (x >>  8);
    cptr[2]= (unsigned char) (x >> 16);
    cptr[3]= (unsigned char) (x >> 24);
}

void put_4bytes_msb_first(void *ptr, long x)
{
    char *cptr= ptr;

    cptr[0]= (unsigned char) (x >> 24);
    cptr[1]= (unsigned char) (x >> 16);
    cptr[2]= (unsigned char) (x >>  8);
    cptr[3]= (unsigned char) (x >>  0);
}




Int get_2bytes_lsb_first(void *ptr)
{
    unsigned char *cptr= ptr;

    return ((Int) cptr[0] +
	    ((Int) cptr[1] << 8));
}

Int get_2bytes_msb_first(void *ptr)
{
    unsigned char *cptr= ptr;

    return ((Int) cptr[1] +
	    (Int) ((Int) cptr[0] << 8));
}

long get_4bytes_lsb_first(void *ptr)
{
    unsigned char *cptr= ptr;

    return ((long) cptr[0] +
	    ((long) cptr[1] << 8) +
	    ((long) cptr[2] << 16) +
	    ((long) cptr[3] << 24));
}

long get_4bytes_msb_first(void *ptr)
{
    unsigned char *cptr= ptr;

    return ((long) cptr[3] +
	    ((long) cptr[2] << 8) +
	    ((long) cptr[1] << 16) +
	    ((long) cptr[0] << 24));
}
