
#include CONFIG

#include "byteq.h"

Int bytequeue_init(Bytequeue *b, Int size)
{
    b->size= size;
    b->head= 0;
    b->tail= 0;
    b->data= malloc(size);
    return 0;
}

void bytequeue_add(Bytequeue *b, char *buf, Int len)
{
    if (len > BYTEQUEUE_SPACE(b)) {
	fprintf(stderr, "too much data placed in bytequeue\n");
	exit(-1);
    }

    if (b->size == 1023) {
	/*write(1,"[[",2);*/
	/*write(1, buf, len);*/
	/*write(1,"]]",2);*/
    }
    {
	Int xfer_size= len;
	if (xfer_size > (b->size - b->tail))
	  xfer_size= b->size - b->tail;
	memcpy(b->data + b->tail, buf, xfer_size);
	b->tail = (b->tail + xfer_size) % b->size;
	len -= xfer_size;
	buf += xfer_size;
	if (len) {
	    memcpy(b->data + b->tail, buf, len);
	    b->tail = (b->tail + len) % b->size;
	}
    }
}

int bytequeue_remove_char(Bytequeue *b)
{
    int ret;
    if (BYTEQUEUE_EMPTY(b)) return -1;
    ret= b->data[b->head];
    if (b->size == 1023) {
	write(1, "{{", 2);
	write(1, b->data+b->head, 1);
	write(1, "}}", 2);
    }
    b->head++; if (b->head == b->size) b->head= 0;
    return ret;
}

void bytequeue_add_char(Bytequeue *b, int c)
{
    int old_tail= b->tail;
    b->tail++;
    if (b->tail == b->size) b->tail= 0;
    if (b->tail == b->head) {
	b->tail= old_tail;
	fprintf(stderr, "attempt to put too much in bytequeue\n");
	exit(-1);
    }
    b->data[old_tail]= c;
}

void bytequeue_remove(Bytequeue *b, char *buf, Int len)
{
   /*char *buf_entry= buf;
     Int len_entry= len;*/
   if (BYTEQUEUE_LENGTH(b) < len) {
      fprintf(stderr, "bytequeue_remove_head: not enough data\n");
      exit(-1);
   }
   {
      Int xfer_size= len;
      
      if (xfer_size > (b->size - b->head))
	xfer_size= b->size - b->head;
      memcpy(buf, b->data + b->head, xfer_size);
      b->head = (b->head + xfer_size) % b->size;
      len -= xfer_size;
      buf += xfer_size;
      if (len) {
	 memcpy(buf, b->data + b->head, len);
	 b->head = (b->head + len) % b->size;
      }
   }
   
   if (b->size == 1023) {
      /*write(1, "[[", 2);*/
      /*write(1, buf_entry, len_entry);*/
      /*write(1, "]]", 2);*/
   }
}

