/*  -*- Mode: C;  -*-
 * File: display.c
 * Author: David Michael (djsm@ai.mit.edu)
 * Copyright (C) David Michael, 1992
 **------------------------------------------------------------------
 ** HISTORY:
 ** Last edited: Jan 24 02:08 1992 (misha)
 ** Created: Mon Jan 13 16:04:05 1992 (misha)
 **------------------------------------------------------------------ */

#define PUBLIC

#include "vfc_lib.h"
#include "display.h"
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/cursorfont.h>

/* we use grab package's variables */
#include "grab.h"


/* other declarations */
Int vfc_load_private_cmap();
XImage *vfc_create_ximage();


/* global variables */

static Display *display;
static Window win;
static GC gc;
static XImage *image;
static XEvent event;

static Int xinitialized = 0;
static unsigned char *last_image = 0;
static Int last_width  = 0;
static Int last_height = 0;

PUBLIC void init_display(u_char *imagearraypointer, Int width, Int height)
{
  XSetWindowAttributes xswa;
  Int screen, black, white;
  Colormap cmap;
  unsigned char ymap[VFC_GRAY_MAPLENGTH],umap[VFC_CCUBE_MAPLENGTH];
  unsigned char *data;
  Int wm_offset=0;

  /* set up an X window with backing store and private colormap */
  if (xinitialized == 1)
    XDestroyWindow(display, win);
  else
    display = XOpenDisplay(0);

  screen = DefaultScreen(display);
  black = BlackPixel(display,screen);
  white = WhitePixel(display,screen);

  xswa.event_mask=ExposureMask|StructureNotifyMask|
    ButtonPressMask|KeyPressMask;
  xswa.background_pixel=
    WhitePixel(display,DefaultScreen(display));
  xswa.border_pixel=
    BlackPixel(display, DefaultScreen(display));
  xswa.backing_store=Always;
  xswa.backing_planes=AllPlanes;
  xswa.bit_gravity=NorthWestGravity;

  win = XCreateWindow
    (display,DefaultRootWindow(display),
     0,0,width,height,0,
     DefaultDepth(display,DefaultScreen(display)),
     InputOutput,
     DefaultVisual(display,DefaultScreen(display)),
     CWEventMask|CWBackPixel|CWBorderPixel|
     CWBackingStore|CWBackingPlanes|CWBitGravity,
     &xswa);

  cmap = XCopyColormapAndFree(display,DefaultColormap(display,screen));
  vfc_get_colormaps(ymap,umap,umap,umap);
  vfc_load_private_cmap(display,cmap,ymap,ymap,ymap,VFC_GRAY_MAPLENGTH,wm_offset);
  XSetWindowColormap(display,win,cmap);
  XMapWindow(display,win);
  XNextEvent (display, &event);
  while (event.type!=Expose)
    XNextEvent(display,&event);

  gc = DefaultGC(display,screen);
  image = vfc_create_ximage(display,width,height,8,1);
  /* Instead of own memory, use memory allocated by grab. */
  free(image->data);
  image->data = (char *)imagearraypointer;
  data = (unsigned char *)image->data;
  
  xinitialized = 1;
}

PUBLIC void displayimage(u_char *imagedata, Int width, Int height)
{
  if (width != last_width || height != last_height || imagedata != last_image)
    init_display(imagedata, width, height);
  last_width = width;
  last_height = height;
  last_image = imagedata;

  XPutImage(display,win,gc,image,0,0,0,0,image->width,image->height);
}

PUBLIC Int AnyXEvent()
{
  return XCheckWindowEvent(display,win,KeyPressMask|ButtonPressMask,&event);
}	
