
#include CONFIG

#include <stringlb.h>
#include <growbuf.h>

#include <signal.h>

#include <stdio.h>
#include <fcntl.h>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <signal.h>
#include <sys/socket.h>

#include <iob.h>

#include "named_socket_client_lib.h"

int server_port= 8787;
int next_port_to_assign= 8788;
int debug_named_sockets= 0;

int fd_printf(int fd, char *format, ...)
{
    char *p;
    va_list args;
    
    va_start(args, format);
    p= string_vprintf(format, args);
    va_end(args);

    write(fd, p, strlen(p));
    
    free(p);
    return 0;
}

int readln(int stream, char *buf, int maxlen)
{
   int future= (int)mtime() + 5000;
   char c;
   
   while (maxlen > 1) {
      while (1) {
	 if (read(stream, &c, 1) == 1) break;
	 if ((int)mtime() - future > 0) {
	    *buf++= 0;
	    return 0;
	 }
	 msleep(100);
      }
      *buf++= c;
      if (c == '\n') { buf--; break; }
      maxlen--;
   }
   *buf++= 0;
   return 1;
}

int parse_compound_portname(char *compound, char **port_ret, char *default_port, char **host_ret, char *default_host)
{
    char *compound_ptr= compound;
    char *port, *host;
    port= string_get_token(&compound_ptr, "@");
    if (!port[0]) {
	free(port);
	port= string_copy(default_port ? default_port : "*");
    }
    host= string_copy(compound_ptr);
    if (!host[0]) {
	free(host);
	host= string_copy(default_host ? default_host : "localhost");
    }
    *port_ret= port;
    *host_ret= host;
    if (debug_named_sockets) printf(">%s< parses to port: >%s< host: >%s<\n",
				   compound, port, host);
    return 0;
}

char **resolve_named_port(char *portname, char *hostname)
{
    int server;
    Growbuf g;
    char buf[101];
    char *bufptr;

    growbuf_init(&g);

    if (!(string_skip_chars(portname, "0123456789")[0])) {
	growbuf_add_ptr(&g, string_copy(portname));
	growbuf_add_ptr(&g, string_copy(portname));
	return (char**) growbuf_data(&g);
    }
	
    fprintf(stderr, "Trying to resolve %s@%s\n", portname, hostname);
    server= connect_to_name_server(hostname);
    if (!server) {
	fprintf(stderr, "Could not connect to nameserver on host %s\n", hostname);
    }
    else {
	fd_printf(server, "find %s\n", portname);
	while (readln(server, buf, 100)) {
	    if (!strncmp(buf, "end", 3)) break;
	    fprintf(stderr, "Found %s\n", buf);
	    bufptr= buf;
	    growbuf_add_ptr(&g, string_get_token(&bufptr, " "));
	    growbuf_add_ptr(&g, string_copy(bufptr));
	}
	close(server);
    }
    growbuf_add_ptr(&g, NULL);
    return (char**) growbuf_data(&g);
}

int resolve_named_port_interactively(char *portname, char *hostname, int *port_ret)
{
    char **ports= resolve_named_port(portname, hostname);
    int nports;
    int localhost = !strcmp(hostname, "localhost");
    FILE *outstream= stdout;
    FILE *instream= stdin;
    int choice, ret, i;
    
    for (nports= 0; ports[nports*2]; nports++) {
	/*fprintf(stderr, "%s:%s\n", ports[nports*2], ports[nports*2+1]);*/
    }
    if (nports == 0) {
	fprintf(outstream, "No ports found matching %s@%s\n",
		portname, hostname);
	*port_ret= -1;
	ret= -1;
    }
    else {
	if (nports > 1) {
	    fprintf(outstream, "More than one port matched %s@%s:\n",
		    portname, hostname);
	    fprintf(outstream, "Choice  Port#  Port name\n");
	    for (i= 0; i< nports; i++) {
		fprintf(outstream, "%3d.    %5d  %s\n",
			i+1, atoi(ports[i*2]), ports[i*2+1]);
	    }
	    while (1) {
		char buf[50];
		fprintf(outstream, "Which is your choice? (1-%d): ", nports);
		fflush(outstream);
		fgets(buf, 50, instream);
		choice= atoi(buf);
		if (choice > 0 && choice <= nports) break;
	    }
	} else {
	    choice= 1;
	}
	
	choice= (choice-1)*2;
	fprintf(outstream, "Connecting to %s%s%s",
		ports[choice+1],
		localhost ? "" : "@",
		localhost ? "" : hostname);
	if (atoi(ports[choice+1]) != atoi(ports[choice])) {
	    fprintf(outstream, " at port %d", atoi(ports[choice]));
	}
	fprintf(outstream, "\n");
	    
	*port_ret= atoi(ports[choice]);
	ret= 0;
    }

    for (i= 0; i< nports; i++) {
	free(ports[i*2]);  ports[i*2]= NULL;
	free(ports[i*2+1]); ports[i*2+1]= NULL;
    }
    free(ports);  ports= NULL;
    return ret;
}
    
int connect_to_name_server(char *hostname)
{
  struct sockaddr_in sa;
  struct hostent *h;
  int    s;
  int portnum;
  
  portnum= server_port;
  
  h= gethostbyname(hostname);
  if (!h) {
    fprintf(stderr,"Couldn't locate host %s\n", hostname);
    return 0;
  }
  bzero(&sa, sizeof(sa));
  bcopy(h->h_addr, &sa.sin_addr, h->h_length);
  sa.sin_family= h->h_addrtype;
  sa.sin_port= htons((u_short)portnum);
  s= socket(h->h_addrtype, SOCK_STREAM, 0);
  if (s<0) {
    fprintf(stderr,"Couldn't open socket to host %s\n", hostname);
    return 0;
  }
  if (connect(s, (struct sockaddr *) &sa, sizeof(sa)) < 0) {
    fprintf(stderr,"Couldn't connect to host %s\n", hostname);
    perror(hostname);
    close(s);
    return 0;
  }
  return s;
}

