/**
 ** parsargs.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/

/**
 ** parsargs.c
 **
 ** Parses arguments from commandline
 **
 ** v1.0  Mon Jul  8 17:42:58 1991  Randy Sargent   Created
 **/

#include CONFIG
#include "util.h"
#include "radix.h"
#include "parsargs.h"

Int parsargs_debug= 0;

void usage(Arg_descriptor *desc, char **args, char *help)
{
    Int i;
    char buf[200];
    fprintf(stderr, "Usage: %s [options] %s\n", args[0], help);
    for (i= 0; desc[i].type; i++) {
	switch(desc[i].type[0]) {
	  case 'N':
	  case 'B':
	    sprintf(buf, "+%s (turn on) or -%s (turn off):",
		    desc[i].name, desc[i].name);
	    break;
	  case 'n':
	  case 'b':
	    sprintf(buf, "-%s:",
		    desc[i].name);
	    break;
	  case 'i':
	  case 'l':
	    sprintf(buf, "-%s <integer>:", desc[i].name);
	    break;
	  case 'f':
	  case 'd':
	    sprintf(buf, "-%s <floating-point-number>:", desc[i].name);
	    break;
	  case 'p':
	    sprintf(buf, "-%s:", desc[i].name);
	    break;
	  case 's':
	    sprintf(buf, "-%s <string>:", desc[i].name);
	    break;
	  default:
	    die(("Illegal type %s in usage\n", desc[i].type));
	    break;
	}
	fprintf(stderr, "%-30s %s\n", buf, desc[i].help);
    }
}

/* Returns null-terminated array of unparsed arguments */
char **parse_args(Arg_descriptor *desc, char **args)
{
   Int i, j, k= 0;
   int def_radix;
   char **ret, *arg;

   if (parsargs_debug) { for (i= 0; args[i]; i++) printf(">%s<\n", args[i]); }
    
   for (i= 0; args[i]; i++);
   ret= malloc(sizeof(char*) * (i+1));
   /*printf("ret got %x (size %d)\n", ret, (sizeof(char*)*(i+1)));*/
    
   for (i= 0; (arg= args[i]); i++) {
      Int parsed= 0;
      Int bool;
	
      if (strchr("-+", *arg)) {
	 bool= (*arg == '+');
	 arg++;

	 for (j= 0; desc[j].name; j++) {
	    if (!strcmp(arg, desc[j].name)) {
	       switch (desc[j].type[0]) {
		case 'B':
		  *(Int*)desc[j].data= bool;
		  if (desc[j].type[1] == '~') {
		     *(Int*)desc[j].data = !*(Int*)desc[j].data;
		  }
		  break;
		case 'b':
		  *(Int*)desc[j].data= 1;
		  if (desc[j].type[1] == '~') {
		     *(Int*)desc[j].data = !*(Int*)desc[j].data;
		  }
		  break;
		case 'N':
		  *(Int*)desc[j].data= !bool;
		  break;
		case 'n':
		  *(Int*)desc[j].data= 0;
		  break;
		case 'p':
		  ((void (*)(void)) (desc[j].data))();
		  break;
		default:
		  if (!args[i+1]) goto out_of_loop;
		  i++;
		  def_radix= desc[j].type[1];
		  if (!def_radix) def_radix='t'; /* base ten */
		  switch (desc[j].type[0]) {
		   case 'i':
		     *(int*)(desc[j].data)=
		       radix_string_to_integer(args[i], def_radix);
		     break;
		   case 'l':
		     *(long*)(desc[j].data)=
		       radix_string_to_integer(args[i], def_radix);
		     break;
		     break;
		   case 's':
		     sscanf(args[i], "%s", (char*) desc[j].data);
		     break;
		   case 'f':
		     sscanf(args[i], "%f", (float*) desc[j].data);
		     break;
		   case 'd':
		     sscanf(args[i], "%lf", (double*) desc[j].data);
		     break;
		   default:
		     die(("Illegal type %s in parse_args\n", desc[j].type));
		     break;
		  }
	       }
	       parsed= 1;
	       break;
	    }
	  out_of_loop:;
	 }
      }
      if (!parsed) {
	 ret[k++]= args[i];
	 if (parsargs_debug) printf("Didn't parse %s\n", args[i]);
      }
   }

   ret[k++]= 0;
   ret= realloc(ret, sizeof(char*) * k);
   return ret;
}
