/**
 ** pp.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#include CONFIG

#include <growbuf.h>
#include "pp.h"

void fprint_hex_and_ascii(FILE *out, char *buf, Int buflen, Int maxlen)
{
    Int i;

    for (i= 0; i< maxlen; i++) {
	if (i < buflen) {
	    fprintf(out, "%02X ", 0xff & buf[i]);
	}
	else {
	    fprintf(out, "   ");
	}
    }
    
    fprintf(out, " | ");
    
    for (i= 0; i< maxlen; i++) {
	if (i < buflen) {
	    Int c= buf[i] & 127;
	    if (32 <= c && c <= 126) {
		putc(c, out);
	    }
	    else {
		putc('.', out);
	    }
	}
	else {
	    putc(' ', out);
	}
    }
}

Int pp_comm_bytes_per_line= 16;

void fprint_data(FILE *out, char *buf, size_t buflen)
{
    size_t i;
    printf("buflen= %ld\n", (long) buflen);
    for (i= 0; i< buflen; i += pp_comm_bytes_per_line) {
	Int this_len= buflen - i;
	if (this_len > pp_comm_bytes_per_line) this_len= pp_comm_bytes_per_line;
	fprint_hex_and_ascii(out, buf+i, this_len, pp_comm_bytes_per_line);
	fprintf(out,"\n");
    }
}

void print_data(char *buf, Int buflen)
{
    fprint_data(stdout, buf, buflen);
}

/* 0 if successful */
Int pp_comm_init(Pp_comm *p)
{
    p->last_which= -1;
    if (growbuf_init(&(p->buf))) return 1;
    pp_comm_reset_streams(p);
    pp_comm_add_stream(p, stdout);
    return 0;
}

void pp_comm_reset_streams(Pp_comm *p)
{
    Int i;
    for (i= 0; i< 2; i++) p->out[i]= NULL;
}

void pp_comm_add_stream(Pp_comm *p, FILE *stream)
{
    Int i;
    for (i= 0; i< 2; i++) {
	if (!p->out[i]) {
	    p->out[i]=stream;
	    break;
	}
    }
}
			
void pp_comm_send_char(Pp_comm *p, Int c, Int which)
{
    Int i;
    
    if (c == EOF) which= -2;
    
    if (growbuf_length(&(p->buf)) &&
	(growbuf_length(&(p->buf)) == pp_comm_bytes_per_line
	 || which != p->last_which)) {

	for (i= 0; i< 2; i++) {
	    if (p->out[i]) {
		fprintf(p->out[i], "From %ld: ", (long) p->last_which+1);
		fprint_hex_and_ascii(p->out[i], growbuf_data(&(p->buf)),
				     growbuf_length(&(p->buf)),
				     pp_comm_bytes_per_line);
		
		if (which == p->last_which)
		  fprintf(p->out[i], " ...\n");
		else
		  fprintf(p->out[i], "\n");
		fflush(p->out[i]);
	    }
	}
	growbuf_clear(&(p->buf));
    }
    
    if (c != EOF) growbuf_add_char(&(p->buf), c);
    
    p->last_which= which;
}

