/**
 ** stream.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/

/**
 **  stream.h
 **
 ** v1.0  Sat May 18 13:46:06 1991  Randy Sargent.  created
 **/

#ifndef STREAM_H
#define STREAM_H

typedef struct stream_str {
    char *buffer_ptr;
    char *buffer;
    Int  buffer_size;
    void *data;
    Int (*replenish)(void* buf, Int item_size, Int nitems, void* data);
    Int (*seek)(void* data, long offset, Int offset_type);
} Stream;

#define STREAM_GETC(s) \
  ( *((s)->buffer_ptr) ? (Int) *((s)->buffer_ptr++) : stream_getc(s) )

/* Implements only one character of backup */

#define STREAM_UNGETC(s, ch) \
    if ((ch) != EOF) *(--(s)->buffer_ptr)= (char)(ch); else
  
/* 0 if successful.  Use either file or string for input, not both */

#include "stream.pro"
  
#endif /* #ifndef STREAM_H */
