
#include CONFIG

#include "wordq.h"

int wordqueue_init(Wordqueue *b, int size)
{
    b->size= size;
    b->head= 0;
    b->tail= 0;
    b->data= malloc(size*sizeof(short));
    return 0;
}

int wordqueue_remove_word(Wordqueue *b)
{
    int ret;
    int new_head;
    if (WORDQUEUE_EMPTY(b)) return -1;
    ret= b->data[b->head];
    new_head= b->head + 1;
    if (new_head == b->size) new_head= 0;
    b->head= new_head;
    return ret;
}

int wordqueue_add_word(Wordqueue *b, int c)
{
    int new_tail= b->tail + 1;
    if (new_tail == b->size) new_tail= 0;
    if (new_tail == b->head) {
	return -1;
    }
    b->data[b->tail]= c;
    b->tail= new_tail;
}

