/*
 *  zw_client.c
 */

#include "proto.h"
#include <string.h>

#define SPACE "                                        "
#define Z_OPTS "ciOfaodvqntul"
int
main (int argc, char *argv[])
{
  int sockfd, i, nsig, arg;
  struct sockaddr_in srv_addr;
  struct hostent *name;
  char hostname[MAXHOSTNAMELEN], *cr_ptr, ch;
  char control = (SEQ_MASK), *format_string = NULL;
  char *f_name;
  u_short port = PORT;
  char sig[SIG_SIZE_EST], view_sig[41], tmp[SIG_SIZE_EST];
  struct sgttyb tty, ntty;
  int ttyset, stat;
  char *z_args[4], *username = NULL;
  int z_flag = 0, z_index;
  char fname[MAXPATHLEN], home[MAXPATHLEN], _iter_done, *z_opts = Z_OPTS;
  FILE *ptr;
  char *zw_argv[32];
  int zw_argc = 0;

  if ((argv[1][0] != '-') && (argc == 2))
    username = argv[1];
  while ((arg = getopt (argc, argv, "p:xs:rwz:e""c:i:O:f:aodvqntul")) != EOF)
  {
    switch (arg)
    {
    case 'p':
      sscanf (optarg, "%hu", &port);
      break;
    case 'x':
      control |= INTERACTIVE_MASK;
      break;
    case 's':
      format_string = optarg;
      break;
    case 'r':
      control &= ~SEQ_MASK;
      break;
    case 'w':
      control |= RELOAD_MASK;
      break;
    case 'z':
      f_name = optarg;
      if (access (f_name, W_OK) == -1)
	fatal ("access");
      control |= SET_FILE;      
      break;
    case 'e':
      control |= EXIT_MASK;
      break;
    default:
      z_index = (strchr (z_opts, arg) - z_opts);
      z_flag |= (1 << z_index);
      if (z_index < 4)
	z_args[z_index] = optarg;
/*    printf ("%c %d %s\n", arg, z_index, optarg); */
    }
    if (optind < argc)
      if (argv[optind][0] != '-')
	if (username == NULL)
	  username = argv[optind];
	else
	  usage ();
  }
  if (format_string == NULL)
  {
    strcpy (home, (char *)getenv ("HOME"));
    strcat (strcpy (fname, home), "/.zsig");
    if ((ptr = fopen (fname, "r+")) == NULL)
      fatal ("fopen");
    if ((format_string = malloc (sizeof (char *) * MAXPATHLEN)) == NULL)
      fatal ("malloc");
    if (fgets (format_string, MAXPATHLEN, ptr) == NULL)
      fatal ("fgets");
    if (fgets (format_string, MAXPATHLEN, ptr) == NULL)
      fatal ("fgets");
    fclose (ptr);
  }
  if ((cr_ptr = strchr (format_string, (int) '\n')) != NULL)
    *cr_ptr = 0;

  gethostname (hostname, MAXHOSTNAMELEN);
  name = gethostbyname (hostname);


  if ((sockfd = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
    fatal ("socket");
  srv_addr.sin_family = AF_INET;
  srv_addr.sin_port = port;
  srv_addr.sin_addr = *((struct in_addr *)name->h_addr);
  if ((connect (sockfd, (struct sockaddr *) &srv_addr, 
                sizeof (struct sockaddr_in))) < 0)
    fatal ("connect");
  
  if (write (sockfd, &control, 1) == -1)
    fatal ("write");

  if (!(control & (EXIT_MASK | RELOAD_MASK | SET_FILE)))
  {
    /* set char by char readin */
    ttyset = 0;
    stat = ioctl(0, TIOCGETP, &tty);
    if (stat == -1) 
    {
      perror("ioctl");
      return(-1);
    }
    if (! (tty.sg_flags & CBREAK)) 
    {
      ntty = tty;
      ttyset = (! ttyset);
      ntty.sg_flags |= CBREAK;
      ntty.sg_flags &= ~ECHO;
      stat = ioctl(0, TIOCSETN, &ntty);
      if (stat == -1) 
      {
	perror("ioctl");
	return(-1);
      }
    }
    /* end */
    if (read (sockfd, &nsig, sizeof (nsig)) == -1)
      fatal ("read");
    read_line (sockfd, sig);
    strncpy (view_sig, sig, 40);
    if ((cr_ptr = strchr (view_sig, (int) '\n')) != NULL)
      *cr_ptr = 0;    
    strncat (view_sig, SPACE, 40 - strlen (view_sig));
    printf ("\r%03d:%s", nsig, view_sig);
    _iter_done = (control & INTERACTIVE_MASK);
    while (_iter_done)
    {
      ch = fgetc (stdin);
      if ((ch == '\n') || (ch == '\016') || (ch == '\020'))
      {
	if (write (sockfd, &ch, 1) == -1)
	  fatal ("write");
	if (ch == '\n')
	  _iter_done = 0;
	else
	{
	  if (read (sockfd, &nsig, sizeof (nsig)) == -1)
	    fatal ("read");
	  read_line (sockfd, sig);
	  strncpy (view_sig, sig, 40);
	  if ((cr_ptr = strchr (view_sig, (int) '\n')) != NULL)
	    *cr_ptr = 0;    
	  strncat (view_sig, SPACE, 40 - strlen (view_sig));
	  printf ("\r%03d:%s", nsig, view_sig);
	}
      }
    }
    
    
    /* reset terminal setting */
    if (ttyset) 
    {
      stat = ioctl(0, TIOCSETN, &tty);
      if (stat == -1) 
      {
	perror("ioctl");
	return(-1);
      }
    }
    /* end */

    if ((cr_ptr = strchr (sig, (int) '\n')) != NULL)
      *cr_ptr = 0;
    interpret (sig);  
    printf ("\r%03d:%s\n", nsig, sig);
    sprintf (tmp, format_string, sig);
    interpret (tmp);
    zw_argv[zw_argc ++] = "zwrite";
    zw_argv[zw_argc ++] = "-s";
    zw_argv[zw_argc ++] = tmp;
    for (i = 0; i < strlen (z_opts); i ++)
      if (z_flag & (1 << i))
      {
	if ((zw_argv[zw_argc] = malloc (3 * sizeof (char))) == NULL)
	  fprintf (stderr, "zw: fatal error: out of memory.\n"), exit (EXIT_FAILURE);
	sprintf (zw_argv[zw_argc ++], "-%c", z_opts[i]);
	if (i < 4)
	  zw_argv[zw_argc ++] = z_args[i];
      }
    if (username != NULL)
      zw_argv[zw_argc ++] = username;
    zw_argv[zw_argc ++] = NULL;
    if (execvp ("zwrite", zw_argv) == -1)
      fatal ("execvp");
  }
  else if (control & SET_FILE)
  {
    if (write (sockfd, f_name, strlen (f_name) + 1) == -1)
      fatal ("write");      
  }
  close (sockfd);

  return EXIT_SUCCESS;
}

void usage ()
{
  printf ("Usage: zw [this crap]\n"), exit (0);
}

char *interpret (char *s)
{
  char *s2=s;
  while (*s)
  {
    if (*s=='\\')
      switch(*++s)
      {
      case 'n': *s2='\n';
          break;
      case 't': *s2='\t';
          break;
      case '\\': *s2='\\';
          break;
      case '`': *s2++='\\', *s2='`';
          break;
      }
    else
      *s2=*s;
    s++; s2++;  
  }
  *s2='\0';
  return s2;
}
