


/********************************************************************
*  UPDATE_POS
*
*  Updates the boat's position and current node.
*/

update_pos()                                          
{


float     a,
	  b,
	  c,
	  theta,
	  hist;

double    dx,
	  dy;

int i,
    j,
    ix,
    iy,
    ang, 
    current,
    dxdy,
    boatdxdy,
    tmpdxdy, 
    temp,        
    angle_to_nearest,
    angle_to_current,
    nearest;


	
/*  1. Calculate a new position (x,y), considering speed and heading
*      (which it now gets from the global boat structure).
*/



calc_xypos();
                           


/*  See if any significant change in direction has occurred. 
*    If so, generate a new neighbor list.
*/

current = BOAT_CURRENT_NODE(boat);

a =  (abs(srch.heading - BOAT_HEADING(boat)));
a = a/360;


if( (a > srch.turn_threshold) || (a > 1 - srch.turn_threshold) )
  make_neighb_list_for(current);


/*
*  2. Check in n_list for nearest neighbor, then perform historesis: if
*     historesis passes (70% or more), then it's time for a new node.  New
*     node gets the nearest and returns a pointer to a new neighbor set,
*     which is presently an array.
*/
                                                     

/*
*      a. Find nearest neighbor (first test for no neigbors)
*         (N_list contains offsets to nodes in WORLD (integers)).
*/



   for(j=0;j<SEARCH_SIZE;++j){
     if( (temp = nearest = BOAT_N_LIST(boat,j)) != -1){
        ang = j;
	break;
     }
    }
   

if (nearest == -1){
  return(-1);  /* Nothing in this direction  */
  }


/*  Now figure out how far away the boat is from the first non-neg.
*/


   boatdxdy =  ( (abs  ( world[temp]->node_x -  (ix = BOAT_X(boat)) )) 
           		+                                        
                 (abs  ( world[temp]->node_y - (iy = BOAT_Y(boat)))) );

       
     
/*     b. Look at the rest of n_list.  Find lowest dxdy.  j carries over.
*/

for (i=j+1;i<SEARCH_SIZE;++i)
 {

   if ( (temp = BOAT_N_LIST(boat,i)) != -1)
   {

    tmpdxdy = ( (abs ( world[temp]->node_x - (ix = BOAT_X(boat)) )) 
           		+                                      
               (abs ( world[temp]->node_y - (iy = BOAT_Y(boat)))) );

    if (tmpdxdy<boatdxdy && temp!=current)
        {
	nearest = temp;
	boatdxdy = tmpdxdy;
	ang = i;
        }
    }
  }


/*     c.  Have nearest, so now do the historesis.  1st figure out how far the
*          the boat is from the current node.
*/
        


boatdxdy = ( (abs ( world[current]->node_x - (ix = BOAT_X(boat)) )) 
           		+
               (abs ( world[current]->node_y - (iy = BOAT_Y(boat)))) );


/*      Next figure out how far the nearest neighbor is from the current.
*/


dxdy  =  ( (abs ( world[current]->node_x  
                - world[nearest]->node_x ))
 	   +                                                            
	   (abs ( world[current]->node_y
  	        - world[nearest]->node_y ))  );


/*  If historesis passes, then call new_node.  Give it nearest and n, get back
*   pointer to integer array neighborlist.  N is length of array (how many
*   nodes to look at in x_sort and y_sort).  The array is cleaned out each
*   time, filled with NULL. N returned is the number of neighbors.
*/
                                            
  if   ( (hist = (boatdxdy/dxdy)) >= .7 ) {

	/* First see if the current node is a better choice.  The reason
	*  is that CURRENT node is excluded from the search for NEAREST.
        *  So far, direction is not considered; thus, you can get between
	*  two nodes and toggle back and forth as they switch roles as nearest
	*  and current.  So we consider the boat's direction for a minute.
	*/
                                     
	/*  Get angle FROM boat TO current node
	*/

  	dx = world[current]->node_x - BOAT_X(boat) ;
  	dy = world[current]->node_y - BOAT_Y(boat) ;


  	theta = atan2(dy,dx); /* angle FROM boat TO current node */
  	if (theta < 0){ theta = 6.28264 + theta;} 
 	              /* 2pi - theta (theta is negative here, so use + )  */
  	theta = theta * ( 360/(2 * 3.14132) );  /* convert to degrees */ 
  	theta = (450-theta);   /*  convert to compass bearings  */
  	if (theta >= 360) {theta = theta - 360;}

	/*  Compare this against boat's heading.  If angle to current node
	*   is less than angle to nearest, then use current.
	*   First get the INTERIOR angle between boat heading and the 
 	*   direction to the two candidate nodes.
	*/
   if (  (angle_to_current= abs( BOAT_HEADING(boat) - (ix = theta) ) )
        < BOAT_HEADING(boat) + (360-(ix = theta)) )
	  { }
   else angle_to_current = BOAT_HEADING(boat) + (360-(ix = theta));



	/*  Get angle FROM boat TO nearest node
	*/


  	dx = world[nearest]->node_x - BOAT_X(boat) ;
  	dy = world[nearest]->node_y - BOAT_Y(boat) ;


  	theta = atan2(dy,dx); /* angle FROM boat TO current node */
  	if (theta < 0){ theta = 6.28264 + theta;} 
 	              /* 2pi - theta (theta is negative here, so use + )  */
  	theta = theta * ( 360/(2 * 3.14132) );  /* convert to degrees */ 
  	theta = (450-theta);   /*  convert to compass bearings  */
  	if (theta >= 360) {theta = theta - 360;}

                                   
   if (  (angle_to_nearest= abs( BOAT_HEADING(boat) - (ix=theta) ) )
        < BOAT_HEADING(boat) + (360-(ix=theta)) )
	  { }
   else angle_to_nearest = BOAT_HEADING(boat) + (360-(ix=theta));


   if (angle_to_current<angle_to_nearest) return(0); 


	/*  New node  */
	BOAT_CURRENT_NODE(boat) = nearest;
        
/*	if(debug == 1) {
  	   printf("New node:  %d", nearest);  
	   } */

        make_neighb_list_for( BOAT_CURRENT_NODE(boat));
        BOAT_PICSET(boat) = world[ BOAT_CURRENT_NODE(boat) ]->picture_ptr;


        if (simulator_mode == WATER_MODE) newframe(); 

	return(1);  
  	
       }

  else  
        return(0);  /* return nil if no new node  */
                                    

}




/*********************************************************************
*   CALC_XYPOS 
*
*   Takes heading and speed from boat structure and computes a new x,y.
*/
                                                                             
calc_xypos()
#define RADIANS .0174532      /* (2 pi radians / 360 degrees) */
{
	int     theta;

	float 	angle,
		dx,
		dy,                               
		costh,
		sinth;

	theta = 90 - BOAT_HEADING(boat);    /* invert heading to get theta */
	  if (theta < 0 ) theta = theta + 360;

	angle = theta * RADIANS;	 /* convert to radians          */
	
	/*  Speed is controlled through boat .speed_multiplier AND
	*   boat .update_rate.  Update_rate is increased first, calling
	*   update_pos more frequently with a smaller multiplier.  This
	*   minimizes the probability of jumping over nodes as speed increases.
	*   Speed_up and slow_down set the magnitudes of both variables.
	*   The update_clock is checked in the main timing loop.
	*/

	dx = cos(angle) * BOAT_SPEED_MULTIPLIER(boat); /* * time_scalar;*/
	dy = sin(angle) * BOAT_SPEED_MULTIPLIER(boat); /* * time_scalar;*/
	BOAT_X(boat) = BOAT_X(boat) + dx;
	BOAT_Y(boat) = BOAT_Y(boat) + dy;



} /* END_UNIT calc_xypos */





/***************************************************************************
*  MAKE_NEIGHBOR_LIST
*
*/

make_neighb_list_for(nearest)
int nearest;
{
int 	hdng,       
	n,
	i,j,k;

n = srch.neighbors_desired;
hdng = (BOAT_HEADING(boat)/PIESIZE);
srch.heading = BOAT_HEADING(boat);

if (hdng-(n/2) > 0 && hdng+(n/2) < PIECUTS)

	for (i=0;i<n;++i)
 	  BOAT_N_LIST(boat,i) = world[nearest]->n_list[(hdng-(n/2))+i];

else if (hdng - (n/2) < 0)
        {
        j = 0;
	for (i=0;i<( abs(hdng-(n/2)) );++i){
 	  BOAT_N_LIST(boat,i)=world[nearest]->n_list[(PIECUTS+(hdng-(n/2)) )+i];
          ++j;
           }
	for (i=0;i< ( n+(hdng-(n/2)) );++i){
 	  BOAT_N_LIST(boat,i) = world[nearest]->n_list[i];
          ++j;
	   }
         }
     else
        {
        j = 0;
	for (i=(hdng-(n/2));i<PIECUTS;++i){
 	  BOAT_N_LIST(boat,j) = world[nearest]->n_list[i];
          ++j;
	   }
        k=j;
	for (i=0;i<n-k;++i){
 	  BOAT_N_LIST(boat,j) = world[nearest]->n_list[i];
          ++j;
           }
         }
}
             
                 


/***************************************************************************
*  NODE_CLOSEST_TO
*
*  To locate the node nearest an x, y position 
*	Types: (PSET, CHTSYM, REAL, EFF, ANYTYPE)
*/

node_closest_to(x, y, node_type_mask)
int x, y, node_type_mask;

{
int closest, 
    temp,
    tmpdxdy,
    dxdy,
    i;

closest = temp = 0; 
 
dxdy = ( (abs ( world[temp]->node_x - x)) 
           +                             
         (abs ( world[temp]->node_y - y)) );
       

/*     b. Look at each member of WORLD.  Pull out
*         lowest dxdy as closest.
*/


for (i=1;i<total_node_count;++i)
   {
   tmpdxdy = ( (abs ( world[i]->node_x - x))
                   +
               (abs ( world[i]->node_y - y)) );


   if (tmpdxdy<dxdy && (node_type_mask & world[i]->node_type) != 0)
        {
	closest = i;
	dxdy = tmpdxdy;
        }
  
   }
return(closest);

}                      
