
/*
*	Set_Position:
*
*	The following functions are used to update the display of 
*       a package when it gets a request to move to a certain position.
*/
#include <stdio.h>
#include <X10/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"
#define FN_MISC 
#define SETPOS extern
#include "functions.h"
#define VDISC extern
#include "vdisc.h"

#define FROZEN  0
#define MATCH 	0
#define OK_ON(i) (p->position[i] >= (m)->simple.pos[InPoint][i]  &&  \
		  p->position[i] <=  (m)->simple.pos[OutPoint][i] )
  int
in_region(p,m)
  Package 	*p;
  Map		*m;
{
	int	i;
		if( !p || !p->ndims || !m )
		{
			return NULL;
		 }
		for(i=0; i < p->ndims; ++i)
		{
			if(!OK_ON(i))
			{
				return((int)NULL);
			 }
		 }
		return(1);
}

 
Map *
find_map(e)
  Element 	*e;
{
	Map *m = e->current ? e->current : e->map;
	Map *l, *n;

		if(e->p->position[0] < m->simple.pos[InPoint][0]){
			for(l = m->simple.prev; l; l = m->simple.prev){
				if( in_region(e->p, l)) return (Map *) l;
			 }
			for(n = m->simple.next; n; n = n->simple.next){
				if( in_region(e->p, n)) return (Map *) n;
			 }
		 }
		else{
			for(n = m->simple.next; n; n = n->simple.next)
			{
				if( in_region(e->p, n)) return (Map *) n;
			 }
			for(l = m->simple.prev; l; l = m->simple.prev){
				if( in_region(e->p, l)) return (Map *) l;
			 }
		 }
        	if(m->simple.type > Unused_map)
		{
			if( in_region(e->p, m)) return (Map *) m;
		 }
		return (Map *) NULL;
}


 char *
find_all_maps(e)
  Element 	*e;
{
  static char   *funcname = "find_all_maps";
  Map 		*m = e->map;
  struct maplist
	{  Map  	  *map;
	   struct maplist *next;
	 } *tmp, *maplist = NULL;

	while(m != 0)
	{
		if(in_region(e->p, m))
		{
			if((tmp = (struct maplist *) 
				calloc(1, sizeof(struct maplist))) == NULL)
			{
				printf("%s: failed calloc maplist\n",funcname);
				exit(1);
			 }
			tmp->map = m;
			tmp->next = maplist;
			maplist = tmp;
		  }
		 m = m->simple.next;
	 }
	return ((char *) maplist);
}


update_element(e)
  Element 	*e;
{
	Map 		*m;
	int		status;
	static char 	*funcname = "update_elements";
	Map *		find_map();

	if(e->active == YES)
	{

        	if(!e->current) e->current = e->map;
		(*e->display_fn)(e);
	 }
}


update_package_display(p)
  Package 	*p;
{
	char          *funcname = "update_package";
	int 	i,n,l;
	Element *e;


	for(e = p->element; e; e = e->next)
	{
		if(e->init_active == YES) e->active = YES;

		for(i=0;i<MaxDims;++i)
		{
			if(p->position[i] >= e->next_event_pos[i]
			    && e->event[i] != (Timed_ev *) NULL 
			    && e->cur_event_pos[i] != e->next_event_pos[i] )
			{

printf("%s: updating `%s' at t= %d, lim= %d\n",funcname,e->name,
	p->position[i], e->next_event_pos[i]);

				update_element(e);

				e->cur_event_pos[i] = 
				    e->event[i][e->next_event[i]].pos;

			        while( e->next_event[i] < e->event_count &&
				    e->event[i][e->next_event[i]].pos ==
				    e->next_event_pos[i] ) 
					++e->next_event[i];
				e->next_event_pos[i] = 
				    e->event[i][e->next_event[i]].pos;

printf("  next_event_pos = `%d'\n",e->next_event_pos[i]);

			 }
			else
			{
			       if ( p->position[i] <= e->last_event_pos[i]
			           && e->event[i] != (Timed_ev *) NULL
			           && e->cur_event_pos[i] 
					!= e->last_event_pos[i] )
			       {
			             update_element(e);

				     e->cur_event_pos[i] = 
				         e->event[i][e->last_event[i]].pos;

			             while(e->last_event[i]< e->event_count && 
					  e->event[i][e->last_event[i]].pos ==
				    	  e->last_event_pos[i])
						 --e->last_event[i];

				     e->last_event_pos[i] = 
				    	    e->event[i][e->last_event[i]].pos;
			        }
			 }
		 }
	 }
	p->active = YES;
}


update_dimension_representations(dim, e)
  Dimension	*dim;
  Element	*e;
{
  	Dim_Rep		*d = dim->rep;	
	while( d != 0)
	{
		(*d->update_fn)(d);
		d = d->next;
	 }
}


void
set_position(packpos)
	Packpos		*packpos;
{
	char		*funcname = "set_position";
  	Package  	*p = packpos->p;
  	int	i;


	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(packpos->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,funcname, packpos->pname);
	     		 }
      	 	 }
		packpos->p = p = tpck;
	}		

printf("%s: pack `%s', p `%s'\n",funcname, packpos->pname, p->name);


	for(i=0; i< MaxDims && p->dimension[i]; ++i){
		p->dimension[i]->current = packpos->pos[i];
		p->position[i] = packpos->pos[i];
	 }
	/*update_position_representations(p);*/
	update_package_display(p);
}




boundary(d,x)
  Dimension	*d;
  int		x;
{
  int 		tmp = d->current;

  	switch(d->boundary)
  	{
		case WRAP:
			tmp = (tmp + x > d->max) ? d->min : d->max;
			break;
		case FREEZE:
			tmp = (tmp + x > d->max) ? d->max : d->min;
			d->change = FROZEN;
			break;
		case BOUNCE:
                        d->delta_sign *= -1;
printf("boundary: set dim %d delta_sign to %d\n",d,d->delta_sign);
			tmp += (x * d->delta_sign);
			break;
		case LIMIT:
			tmp = (tmp + x > d->max) ? d->max : d->min;
			break;
	 }
	return(tmp);
}


expire_package(p, next, code)
  Package	*p, *next;
  int		code;
{
  Mapped_items	*m;
  Packpos	pck, *pack = &pck;
  Screen	*s;
  Element	*e;
  Dimension	*d;
  int		unmap_screens = YES;
  char		*func = "expire_packages";
  char 		cmd[Nchars];
  WindowInfo    info;
  int		i, status;

	switch(code)
	{
		case DO_NEXT:
			next = p->unext;
			break;
		case DO_PREV:
			next = p->uprev;
			break;
		case DO_PACK:
			break;
		case DO_STOP:
			next = 0;
			break;
	 }

printf("%s: next `%s'\n",func, next ? next->name : 0);
	
	p->active = NO;
	if(next)
	{
		next->active = YES;
		pack->p = next;
		strcpy(pack->pname, next->name);
	        for(i = 0; i < MaxDims && next->dimension[i]; ++i)
	        {
printf("%s: pos[%d]: `%d'\n",func,i,next->dimension[i]->min);
		        pack->pos[i] = next->dimension[i]->min;
	         }
	 
		if(next->window == p->window)
		{
			unmap_screens = NO;
		 }
	 }
	if(unmap_screens == YES)
	{
		s = p->window;
		while (s != 0)
		{
			XUnmapSubwindows(s->w);
			if( !XUnmapWindow( (Window) s->w))
			{
				printf("%s: failed XUnmapWindow\n", func);
				exit(1);
	 	 	 }
			s = s->next;
		 }
	 }

 	e = p->element;
	while(e !=0)
	{
		if(e->type == TK_WIDGET)
		{
			m = e->mapped_items;
			while(m != 0)
			{
	   			XUnmapWindow((Window)m->map->simple.w);
				m = m->next;
	 	 	 }
	 	 }
		if(disc->controlling_element == e) 
		{
		     	d = e->p->dimension[e->map->simple.key_dimension];
			sprintf(cmd, "still");
   			sony_cmd(disc->port, cmd);
			if( ! XQueryWindow(e->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n"
				    ,func);
				exit(1);
	 		  }

			if((status = XStillVideo(e->w,0,0,
				0, 0, info.width,info.height)) == -1)
			{
	  			printf("%s: failed XStillVideo in window %d\n",
			    	    func, e->w);
				exit(1);
	 		 }
			disc->operation = VDSC_STOPPED;
		   	stop_timer(d);
   			d->rate = 0;
			d->rate_setting = d->rate_default;
		 }
		e = e->next;
	 }
	XFlush();


	if(next)
	{
		set_position(pack);
	 }

}


void
rset_position(packpos)
  Packpos  	*packpos;
{
	char		*funcname = "rset_position";
  	Package		*p = packpos->p;
	Dimension	*d;
  	int		i, tmp;


	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(packpos->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,funcname, packpos->pname);
	     		 }
      	 	 }
		packpos->p = p = tpck;
	}		


	for(i=0; i < MaxDims && (d = p->dimension[i]); ++i){
		if(d->change != FROZEN)
		{
			tmp = d->current + (packpos->pos[i] * d->delta_sign);
			if(tmp > d->max || tmp < d->min)
			{
				if(d->boundary == EXPIRE)
				{
					expire_package(p);
printf("%s: exiting after package expiration\n",funcname);
					return;
				 }
				else
				{
			       	     d->current = boundary(d, packpos->pos[i]);
				 }
		 	 }
			else
			{
			       d->current += (packpos->pos[i] * d->delta_sign);
		         }
			p->position[i] = d->current;
		 }
	 }

	update_package_display(p);
}


/*-------------------------------*/
  void
do_next(packpos)
    Packpos	*packpos;
{
    char        *func = "do_next";

printf("%s: expiring package %s\n",func,packpos->e->p->name);
	expire_package(packpos->e->p, (Package *) 0, DO_NEXT);
}

/*-------------------------------*/
  void
do_prev(packpos)
    Packpos	*packpos;
{
    char        *func = "do_prev";

printf("%s: expiring package %s\n",func,packpos->e->p->name);
	expire_package(packpos->e->p, (Package *) 0, DO_PREV);  
}

/*-------------------------------*/
  void
expire(packpos)
  Packpos	*packpos;
{
    char        *func = "expire";

printf("%s: expiring package %s\n",func,packpos->e->p->name);
	expire_package(packpos->e->p, (Package *) 0, DO_STOP);  
}

/*-------------------------------*/
    void
switch_to(packpos)
    Packpos	*packpos;
{
    Package	*p = packpos->p;
    char	*func = "switch_to";

printf("%s\n",func);

	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(packpos->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,func, packpos->pname);
	     		 }
      	 	 }
		packpos->p = p = tpck;
	}		

	expire_package(packpos->e->p, p, DO_PACK);
}

