/* ********************************************************************
/* FUNCTION
/* Get_Absolute_Coords(       w, rel_x, rel_y, abs_x_ptr, abs_y_ptr );
/* Window     w;              /* the window our coord is relative to */
/* int                rel_x, rel_y;   /* the coord in our window */
/* int                *abs_x_ptr, *abs_y_ptr; /* RETURNED absolute screen coords
 */
/*
/* REMARKS
/* Given an x,y point in an arbitrary window on the screen, converts
/* it to absolute screen position.
/* ********************************************************************/

Get_Absolute_Coords( w, rel_x, rel_y, abs_x_ptr, abs_y_ptr )

      Window          w;
      int             rel_x, rel_y;
      int             *abs_x_ptr, *abs_y_ptr;         /* RETURN */
{
WindowInfo    wi;
int           x,y;
int           nchildren;
Window                parent;
Window                *children;

      if( w == NULL ) return FAILURE;

      x = rel_x;
      y = rel_y;

      while( w!=NULL && w!=RootWindow ) {
              XQueryWindow( w, &wi );
              x += (wi.x + wi.bdrwidth);
              y += (wi.y + wi.bdrwidth);
              XQueryTree( w, &parent, &nchildren, &children );
              free( (Window *) children );
              w = parent;
              }

      *abs_x_ptr = x;
      *abs_y_ptr = y;

      return SUCCESS;
}

