/*
 *	$Source: /mit/projects/visual/RCS/lookups.c,v $
 *	$Header: lookups.c,v 1.4 87/07/08 09:59:23 joelr Exp $
 */

#include <stdio.h>
#include <X10/Xlib.h>
#include </mit/visual/tools/include/X10/Xtlib.h>
#define LKUPS  
#define READFILE extern
#define AUX extern
#include "prsdefs.h"
#include "lkups.h"
#define FN_MISC extern
#define SETPOS extern
#include "functions.h"
#define DISPLAYS extern
#include "dspdefs.h"



int 
lookup(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    int value;
  } table[NKEYS] = {
    "package", 		PACKAGE,
    "dataset",          ELEMENT,
    "element", 		ELEMENT,
    "screenset", 	SCREENSET,
    "screen", 		SCREEN,
    "map", 		MAP,
    "dimension", 	DIMENSION,
    "timer", 		TIMER,
    "include", 		INCLUDE,
    "name", 		NAME,
    "next", 		NEXT,
    "type", 		TYPE,
    "active", 		ACTIVE,
    "label", 		LABEL,
    "in", 		IN_POINT,
    "out", 		OUT_POINT,
    "icon", 		ICON,
    "filename", 	FILENAME,
    "pos_in", 		POS_IN,
    "pos_out", 		POS_OUT,
    "max",		MAX,
    "min", 		MIN,
    "range", 		RANGE,
    "boundary", 	BOUNDARY,
    "screen_name", 	SCREEN_NAME,
    "parent", 		PARENT,
    "xpos", 		XPOS,
    "ypos", 		YPOS,
    "width", 		WIDTH,
    "height", 		HEIGHT,
    "borderwidth", 	BORDERWIDTH,
    "border", 		BORDER,
    "background", 	BACKGROUND,
    "key_dimension", 	KEY_DIMENSION,
    "timer_fn",         TIMER_FN,
    "parameter", 	PARAMETER,
    "rate", 		RATE,
    "represents", 	REPRESENTS,
    "funt", 		FONT,
    "foreground", 	FOREGROUND,
    "x1", 		X1,
    "y1", 		Y1,
    "x2", 		X2,
    "y2", 		Y2,
    "rowcol", 		ROWCOL,
    "offset", 		OFFSET,
    "xoverlap", 	XOVERLAP,
    "yoverlap", 	YOVERLAP,
    "on_open",          ON_OPEN,
    "on_close",         ON_CLOSE,
    "key_x",            X_KEY,
    "key_y",            Y_KEY,
    "initial",		INITIAL,
    "action",           ACTION,
    "origin",           ORIGIN
    };

  for(i=0;i<NKEYS;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}






 char *
lookup_type(what,lkup)    /*   element types  */
 int 		what;
 Lkup_union 	*lkup;

{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[TKEYS] = {
    "video", 		 VIDEO,
    "still", 		 STILL,
    "text", 		 TEXT,
    "tk_widget", 	 TK_WIDGET,
    "window", 		 WINDOW,
    "transparency", 	 TRANSPARENCY,
    "complex", 		 COMPLEX,
    "audio", 		 AUDIO,
    "free_video", 	 FREE_VIDEO,
    "graphic", 		 GRAPHIC,
    "action",		 ACTION_ELE,
    "package",		 PACKAGE_ELE
    };
	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
  		 }
  		for(i=0;i<TKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
 	 }
	else
	{
  		for(i=0;i<TKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}




#define DFKEYS 		10

 char *
lookup_dsp_fn(what,lkup)    /*   type  */
 int 		what;
 Lkup_union 	*lkup;

{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    char *value;
  } table[DFKEYS] = {
    "audio", (char *) display_audio,
    "video", (char *) display_video,
    "still", (char *) display_still,
    "text", (char *) display_text,
    "tk_widget", (char *) display_TKwidget,
    "complex", (char *) display_complex,
    "free_video", (char *) free_video,
    "graphic", (char *) display_graphic,
    "package", (char *) display_package,
    "action", (char *) display_action
    };
	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) != 0 )
		{
    			*blank = '\0';
  		 }
  		for(i=0;i<DFKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
 	 }
	else
	{
  		for(i=0;i<DFKEYS;++i)
		{
    			if((int)table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}


#define BKEYS 5  /*    Boundary  */

 char * 
lookup_boundary(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[BKEYS] = {
    "wrap",1,
    "freeze", 2,
    "bounce", 3,
    "limit", 4,
    "expire", 5
    };
	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
  		 }
  		for(i=0;i<BKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 }
	else
	{
  		for(i=0;i<BKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
        			return((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}





 char *
lookup_active(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[AKEYS] = {
    "yes", 1,
    "no", 0,
    };

	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<AKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 }
	else 
	{
  		for(i=0;i<AKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}



 char *
lookup_map_type(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[MKEYS] = {
    "still", 	STILL_MAP,
    "video", 	VIDEO_MAP,
    "complex", 	COMPLEX_MAP,
    "line", 	LINE_MAP,
    "button", 	BUTTON_MAP,
    "tkdialog", TKDIALOG_MAP,
    "tkscroll", TKSCROLL_MAP,
    "tktext", 	TKTEXT_MAP,
    "label",	LABEL_MAP,
    "box", 	BOX_MAP,
    "arc", 	ARC_MAP
    };

	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<MKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 }
	else 
	{
  		for(i=0;i<MKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}



#define TKFKEYS 23

 char *
lookup_function(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    char *value;
    int	 param;
  } table[TKFKEYS] = {
    "quit", (char *) quit, NULL,
    "grabvideo", (char *) grabvideo, PACKPOS_PARAM,
    "StringFunction", (char *) StringFunction, STRING_PARAM,
    "video", (char *) video, STRING_PARAM,
    "system", (char *) system, STRING_PARAM,
    "scroll", (char *) scroll, NULL,
    "thumb", (char *) thumb, NULL,
    "set_position", (char *) set_position, PACKPOS_PARAM,
    "rset_position", (char *) rset_position, PACKPOS_PARAM,
    "pace", (char *) pace, PACKPOS_PARAM,
    "do_next", (char *) do_next, PACKPOS_PARAM,
    "do_prev", (char *) do_prev, PACKPOS_PARAM,
    "switch_to", (char *) switch_to, PACKPOS_PARAM,
    "expire", (char *) expire, PACKPOS_PARAM,
    "activate", (char *) activate, PACKPOS_PARAM,
    "activate_reset", (char *) activate_reset, PACKPOS_PARAM,
    "scroll_control_package", (char *) scroll_control_package, PACKPOS_PARAM,
    "set_label_equal", (char *) set_label_equal, STRING_PARAM,
    "set_xy_linear", (char *) set_xy_linear, STRING_PARAM,
    "glossary_lookup", (char *) glossary_lookup, PACKPOS_PARAM,
    "set_rate", (char *) set_rate, PACKPOS_PARAM,
    "set_range", (char *) set_range, PACKPOS_PARAM,
    "rset_range", (char *) rset_range, PACKPOS_PARAM
    };

	switch(what)
	{
	   case Key:
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<TKFKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 
		break;
	 
	   case Val:
  		for(i=0;i<TKFKEYS;++i)
		{
    			if(table[i].value == (char *)lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
		break;

	   case Param:
		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<TKFKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].param);
    			 }
  		 }
	 
		break;
	 
	 }
	return ((char *) FAILURE);
}






int 
TK_lookup(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    int value;
  } table[TKkeys] = {
    "window", 		TK_WINDOW,
    "label", 		TK_LABEL,
    "font", 		TK_FONT,
    "borderwidth", 	TK_BORDERWIDTH,
    "foreground",	TK_FOREGROUND,
    "background",	TK_BACKGROUND,
    "border", 		TK_BORDER,
    "width", 		TK_WIDTH,
    "height", 		TK_HEIGHT,
    "justify", 		TK_JUSTIFY,
    "function", 	TK_FUNCTION,
    "parameter", 	TK_PARAMETER,
    "highlight", 	TK_HIGHLIGHT,
    "unhighlight", 	TK_UNHIGHLIGHT,
    "notify", 		TK_NOTIFY,
    "orientation", 	TK_ORIENTATION,
    "thumb", 		TK_THUMB,
    "scrollupdownproc", TK_SCROLLUPDOWNPROC,
    "thumbproc", 	TK_THUMBPROC,
    "top", 		TK_TOP,
    "shown", 		TK_SHOWN,
    "hspace", 		TK_HSPACE,
    "vspace", 		TK_VSPACE,
    "dialogvalue", 	TK_DIALOGVALUE,
    "dialogbutton", 	TK_DIALOGBUTTON,
    "name", 		TK_NAME,
    "x", 		TK_X,
    "y", 		TK_Y,
    "value", 		TK_VALUE,
    "pos_in", 		TK_POS_IN,
    "pos_out",		TK_POS_OUT,
    "edit_type", 	TK_EDIT_TYPE,
    "text_options",    	TK_TEXT_OPTIONS,
    "display_position", TK_DISPLAY_POSITION,
    "insert_position",	TK_INSERT_POSITION,
    "left_margin",	TK_LEFT_MARGIN,
    "file",		TK_FILE,
    "string",		TK_STRING,
    "length",		TK_LENGTH,
    "event_bindings",	TK_EVENT_BINDINGS,
    "entry",		TK_ENTRY
    };

  for(i=0;i<TKkeys;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}


#define TKtext_edit_modes       3

 char *
lookup_TKtext_edit_mode(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[TKtext_edit_modes] = {
    "read", (int) XttextRead,
    "append",(int)  XttextAppend,
    "edit", (int) XttextEdit
    };

	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<TKtext_edit_modes;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 }
	else 
	{
  		for(i=0;i<TKtext_edit_modes;++i)
		{
    			if(table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}

