/*  This version incorporates Russ Sasnett's script handlers - MH 5/4/88 */
#define MUSEV 1

#include <stdio.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>

#include <X10/Xlib.h>
#include </mit/visual/tools/include/X10/Xtlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#define VDISC
#include "vdisc.h"

/* from Russ-- */
#include "../script/ev_tokens.h"
#include "../script/MenuMgr.h"

#define SCOPE extern
#include "XVideo.h"

extern int ev_Debug;
extern ENV_PTR	curenv;

/*--------------*/


extern Package *readfile();
extern CVideo *cvideo;
extern int load_binary();
extern int save_the_world();


/*-------------------------------------*/
init_activate()
{
   Package 	*p;

printf("first_package: %d, `%s'\n",first_package, first_package->name);
	for(p = first_package; p; p = p->next)
	{
		if( p->init_active == YES)
		{
printf("init activating `%s', `%d'\n",p->name,p);
			activate_package(p);
		 }
	 }
			
}


/*-------------------------------------*/

main( argc,argv )
 int 		argc;
 char 		**argv;
{
  char 			fn[64],ev_fn[64];
  Package 		*vmp;
  static char   	*func = "main";
  char 			*getenv();
  int 			select_result, nfds = 1;
  struct timeval  	tmv, *time = &tmv;
  struct timeval        ptmv, *proctime = &ptmv;
  struct timezone       tmz, *timezone = &tmz;
  fd_set		fdset, permfdset;
  XEvent 		ev;
  int			fd, msec,el, elapsed;
/* also uses global ints time_deficit and new_timer_setting, see prsdefs.h*/

/* from Russ--- */
  FILE *fp;
  char msg[64];
  char objname[64];
  CODE_PTR	cp;
  int	ev_Kbd = 0;


	if( argc > 1 ) strcpy(fn,argv[1]);
	else 
	{
  		printf("what data file ? ");
  		gets( fn );
	 }
	if( argc > 2 ) strcpy(ev_fn,argv[2]);
	else 
	{
		printf("what object file? ");
		gets( ev_fn );
	 }

	if( argc > 3 )
	{
		if( sscanf(argv[3],"-d%d",&ev_Debug) != 1 )
			ev_Debug = 0;
		else
			printf("setting debug level to %d\n",ev_Debug);
	}
	if( argc > 4 )
	{
		if( !strcmp(argv[4],"-k") )	/* allow keyboard input */
			ev_Kbd = 1;
		else
			ev_Kbd = 0;
	}




	if( !XOpenDisplay(0)) 
  	{
    		printf("main: failed XOpenDisplay on %s\n",getenv("DISPLAY"));
    		exit(1);
  	 }


  	XtInitialize();

/* from Russ--- */
	InitErrorHandler();
	mm_InitMenus( "xs" );
	InitColors();

  	XSetVideoColor(1,0xff,0xff,0xff);  /* 1 = white */
	XSetVideoColor(3,0xff,0,0);
	XSetVideoColor(5,0,0xff,0);
	XSetVideoColor(7,0,0,0xff);

	if( XSetVideoDisplay() )
	{
		gdb_init();
		if( !(v$server = OpenLocalVideoServer(&vdt)))
		{
			printf("%s: failed OpenLocalVideoServer\n");
			exit(1);
		 }
  		disc = &vdsc;

	 }


/*        load_binary(); */








Debug((stderr," going to readfile\n"));
	vmp = readfile( fn );
	if( vmp == NULL ) exit(1);

Debug((stderr," going to makewindows\n"));
	makewindows();
Debug((stderr," going to resolve\n"));
	resolve_names();


/* from Russ---- */
	if( (fp = fopen(ev_fn,"r")) != NULL )
	{
		ev_MakeCBinding(argv[0]);
		ev_SetFile(fp);
		ev_Parse();
		printf("successful parse\n");
		fclose(fp);

		cp = findcode( curenv->global_code, "OpenEnv" );
		if( cp && cp->type == MSG_CODESEG )
			ev_HandleMsg( cp );
		else
			printf("couldn't find global handler 'OpenEnv'\n");
	 }
	else
	{
		printf("unable to open file %s\n",ev_fn);	
		exit(1);
	 }




Debug((stderr," going to init_act\n"));
	init_activate();
        msec = new_timer_setting;
Debug((stderr,"after init, msec = %d\n",msec));
	if(msec)
	{
		time->tv_sec = msec/1000;
		time->tv_usec = (msec % 1000) * 1000;
	 }
	else
	{
		time->tv_sec = 0;
		time->tv_usec = 0;
	 }


  	FD_ZERO(&permfdset);
  	FD_SET(dpyno(), &permfdset);
        nfds = dpyno() + 1;

        time_deficit = 0;

Debug((stderr,"start main loop\n"));
    	for(;;) 
	{
	   	if ( msec )
		{

			/*  get starting time */
		        gettimeofday(proctime,timezone);

			new_timer_setting = msec;

			/*  clear the event queue; events may change timer */
			while( XPending())
			{
Debug((stderr,"%s: x events before setting time\n",func));
				XNextEvent(&ev);
				mm_HandleEvent(&ev);	/* needs to be first */
				(void) XtDispatchEvent(&ev);
				handle_text(&ev);
				handle_msgs( &ev );
				if(ev.window == cvideo->window)
				    CVideoProcess(cvideo, ev);
Debug((stderr,"%s: done\n",func));
			 }

			/*  get the elapsed time */
			time_deficit += getelapsed(proctime);
			/*  get starting time */
		        gettimeofday(proctime,timezone);

			if(msec != new_timer_setting)
			{
				if(new_timer_setting)
			        {
					msec = new_timer_setting;
					time->tv_sec = msec/1000;
					time->tv_usec = (msec % 1000) * 1000;
Debug((stderr,"set select, `%d' msec\n",msec));
				       bcopy(&permfdset,&fdset,sizeof(fd_set));
					select_result = 
					    select(nfds,&fdset,NULL,NULL,time);
			     	 }
				else
				{
					msec = 0;

				       bcopy(&permfdset,&fdset,sizeof(fd_set));
  					select_result = 
					   select(nfds, &fdset, NULL, NULL, 0);
				 }
			 }
			else
			{
Debug((stderr,"set select, `%d' msec\n",msec));
			    bcopy(&permfdset,&fdset,sizeof(fd_set));
  			    select_result = select(nfds,&fdset,NULL,NULL,time);
			 }
		 }
		else
		{

			/*  get starting time */
/*		        gettimeofday(proctime,timezone); */

			new_timer_setting = 0;
			while( XPending())
			{
				XNextEvent(&ev);
				mm_HandleEvent(&ev);	/* needs to be first */
				(void) XtDispatchEvent(&ev);
				handle_text(&ev);
				handle_msgs( &ev );
				if(ev.window == cvideo->window)
				    CVideoProcess(cvideo, ev);
			 }

			/*  get the elapsed time */
/*			time_deficit += getelapsed(proctime); */

/* In a case where the timer is not being used, don't build up a time deficit*/
			time_deficit = 0;

			if(new_timer_setting)
		        {
				msec = new_timer_setting;
				time->tv_sec = msec/1000;
				time->tv_usec = (msec % 1000) * 1000;
			        bcopy(&permfdset,&fdset,sizeof(fd_set));
				select_result = select(nfds,&fdset,NULL,NULL,time);
		     	 }
			else
			{
			       msec = 0;
			       bcopy(&permfdset,&fdset,sizeof(fd_set));
			       select_result = select(nfds,&fdset,NULL,NULL,0);
			 }
Debug((stderr,"set select, no timer, msec `%d'\n",msec));


		 }

  		switch(select_result)
  		{
			case -1:
				printf("%s: failed select\n",func);
				exit(1);
			case 0:
Debug((stderr,"timer expired, going to update timers\n"));

				gettimeofday(proctime,timezone);
				msec = update_timers();
				elapsed = getelapsed(proctime);
				time_deficit += elapsed;
				time_delta_avg = (time_delta_avg + elapsed)/2;

				if(msec)
				{
					if( (msec - time_deficit) > 0)
					{
					  msec -= time_deficit;
					  time_deficit = 0;
					  time->tv_sec = msec/1000;
					  time->tv_usec = (msec % 1000) * 1000;
					 }
					else
					{
					   time_deficit -= (msec - 1);
					   msec = 1;
					   time->tv_sec = 0;
					   time->tv_usec = 1000;
					 }	
Debug((stderr,"after update, deficit %d, msec %d\n",time_deficit, msec));
				 }
				else
				{
					time->tv_sec = 0;
					time->tv_usec = 0;
				 }
				break;
			default:
				msec = new_timer_setting
				    = (get_time_remaining(msec, proctime));
				    /* msec is the original time set */

Debug((stderr,"before X events, msec `%d', deficit `%d'\n",msec,time_deficit));
				gettimeofday(proctime, timezone);
				XNextEvent(&ev);
				mm_HandleEvent(&ev);	/* needs to be first */
				(void) XtDispatchEvent(&ev);
				handle_text(&ev);
				handle_msgs( &ev );
				if(ev.window == cvideo->window)
				    CVideoProcess(cvideo, ev);
				time_deficit += getelapsed(proctime);

				msec = new_timer_setting;

Debug((stderr,"from X events, new msec`%d', defict `%d'\n",msec,time_deficit));

				if(msec)
				{
					msec -= 1000;  /* extra second */
					if( (msec - time_deficit) > 0)
					{
					  msec -= time_deficit;
					  time_deficit = 0;
					  time->tv_sec = msec/1000;
					  time->tv_usec = (msec % 1000) * 1000;
					 }
					else
					{
					   time_deficit -= (msec - 1);
					   msec = 1;
					   time->tv_sec = 0;
					   time->tv_usec = 1000;
					 }	
				 }
				else
				{
					   time->tv_sec = 0;
					   time->tv_usec = 0;
				 }
				break;
   		 }
    	 }

}



