
/*
*	Set_Position:
*
*	The following functions are used to update the display of 
*       a package when it gets a request to move to a certain position.
*/
#include <stdio.h>
#include <X/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"
#define FN_MISC 
#define SETPOS extern
#include "functions.h"

#define FROZEN  0
#define MATCH 	0
#define OK_ON(i) (p->position[i] >= (m)->simple.pos[InPoint][i]  &&  \
		  p->position[i] <=  (m)->simple.pos[OutPoint][i] )
static int
in_region(p,m)
  Package 	*p;
  Map		*m;
{
	int	i;

		if( !p || !p->ndims || !m ) 
			return NULL;
		for(i=0; i < p->ndims; ++i){
			if(!OK_ON(i)) return((int)NULL);
		 }
		return(1);
}

 
Map *
find_map(e)
  Element 	*e;
{
	Map *m = e->current ? e->current : e->map;
	Map *l, *n;

		if(e->p->position[0] < m->simple.pos[InPoint][0]){
			for(l = m->simple.prev; l; l = m->simple.prev){
				if( in_region(e->p, l)) return (Map *) l;
			 }
			for(n = m->simple.next; n; n = n->simple.next){
				if( in_region(e->p, n)) return (Map *) n;
			 }
		 }
		else{
			for(n = m->simple.next; n; n = n->simple.next)
			{
				if( in_region(e->p, n)) return (Map *) n;
			 }
			for(l = m->simple.prev; l; l = m->simple.prev){
				if( in_region(e->p, l)) return (Map *) l;
			 }
		 }
        	if(m->simple.type > Unused_map)
		{
			if( in_region(e->p, m)) return (Map *) m;
		 }
		return (Map *) NULL;
}


 char *
find_all_maps(e)
  Element 	*e;
{
  static char   *funcname = "find_all_maps";
  Map 		*m = e->map;
  struct maplist
	{  Map  	  *map;
	   struct maplist *next;
	 } *tmp, *maplist = NULL;

	while(m != 0)
	{
		if(in_region(e->p, m))
		{
			if((tmp = (struct maplist *) 
				calloc(1, sizeof(struct maplist))) == NULL)
			{
				printf("%s: failed calloc maplist\n",funcname);
				exit(1);
			 }
			tmp->map = m;
			tmp->next = maplist;
			maplist = tmp;
		  }
		 m = m->simple.next;
	 }
	return ((char *) maplist);
}


update_element(e)
  Element 	*e;
{
	Map 		*m;
	int		status;
	static char 	*funcname = "update_elements";
	Map *		find_map();

        if(!e->current) e->current = e->map;
	(*e->display_fn)(e);


/*
	if((m = (Map *) find_map(e)) != NULL)  
	{
	   if(m != e->current)
	   {
		e->current = m;
                if((status = (*e->display_fn)(e)) < 0)
		{
		  	printf("%s: display function `%s' on element `%s'\n",
				funcname, e->name, e->display_function);
		 }

		e->active = YES;
	    }
	 }
*/

}


update_package_display(p)
  Package 	*p;
{
	int 	i;
	Element *e;

	for(e = p->element; e; e = e->next){
		update_element(e);
	 }
	p->active = YES;
}


void
set_position(packpos)
	Packpos		*packpos;
{
	char		*funcname = "set_postition";
  	Package  	*p = packpos->p;
  	int	i;


	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(packpos->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,funcname, packpos->pname);
	     		 }
      	 	 }
		packpos->p = p = tpck;
	}		


	for(i=0; i< MaxDims && p->dimension[i]; ++i){
		p->dimension[i]->current = packpos->pos[i];
		p->position[i] = packpos->pos[i];
	 }
	/*update_position_representations(p);*/
	update_package_display(p);
}




boundary(d,x)
  Dimension	*d;
  int		x;
{
  int 		tmp = d->current;

  	switch(d->boundary)
  	{
		case WRAP:
			tmp = (tmp + x > d->max) ? d->min : d->max;
			break;
		case FREEZE:
			tmp = (tmp + x > d->max) ? d->max : d->min;
			d->change = FROZEN;
			break;
		case BOUNCE:
                        d->delta_sign *= -1;
			tmp += (x * d->delta_sign);
			break;
		case LIMIT:
			tmp = (tmp + x > d->max) ? d->max : d->min;
			break;
	 }
	return(tmp);
}



void
rset_position(packpos)
  Packpos  	*packpos;
{
	char		*funcname = "set_postition";
  	Package		*p = packpos->p;
	Dimension	*d;
  	int		i, tmp;


	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(packpos->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,funcname, packpos->pname);
	     		 }
      	 	 }
		packpos->p = p = tpck;
	}		


	for(i=0; i < MaxDims && (d = p->dimension[i]); ++i){
		if(d->change != FROZEN)
		{
			tmp = d->current + (packpos->pos[i] * d->delta_sign);
			if(tmp > d->max || tmp < d->min)
			{
			       d->current = boundary(d, packpos->pos[i]);
		 	 }
			else
			{
			       d->current += (packpos->pos[i] * d->delta_sign);
		         }
			p->position[i] = d->current;
		 }
	 }

	update_package_display(p);
}





