
/* ev_glue2.c */

#include <stdio.h>
#include <X10/Xtext.h>
#include "Xtlib.h"
#include "MenuMgr.h"

extern char *getenv();


#define MAXSTR	255
char *theTextBuffer = NULL;


/* ---------- glue for Xtext ------------ */

#define MAXTEXTWINS	10

static	struct
{
	TextWindow *	t;
	Window		w;
} TW[MAXTEXTWINS];

static int	NTextWins = 0;

int
handle_text( ep )
	XEvent *ep;
{
int	i;

	if( !NTextWins )
		return 0;
	for( i=0; i<MAXTEXTWINS; i++ )
		if( ep->window == TW[i].w )
			TextEvent( TW[i].t, ep );
	return 0;
}

int
RegisterTW( t )
	TextWindow *t;
{
int	i;

	if( !t )
		return -1;
	for( i=0; i<MAXTEXTWINS; i++ )
		if( TW[i].t == NULL )
		{
			TW[i].t = t;
			TW[i].w = t->w;
			++NTextWins;
			return 0;
		}
	return -1;
}

int
DeRegisterTW( t )
	TextWindow *t;
{
int	i;

	if( !t )
		return -1;
	for( i=0; i<MAXTEXTWINS; i++ )
		if( TW[i].t == t )
		{
			TW[i].t = NULL;
			TW[i].w = (Window)0;
			--NTextWins;
			return 0;
		}
	return -1;
}

int
WindowFromTW( t )
	TextWindow *t;
{
	if( t )
		return t->w;
	return 0;
}

int
TextPutLine( t, s )
	TextWindow *t;
	char *s;
{
	TextPutString( t, s );
	TextPutChar( t, '\n' );
}

/* -------------- Xtk Glue ------------------- */

static void ButtonAction(tag)
	char * tag;
{
	ev_SendMsg( tag, "Activate" );
}

int
MakeButton( parent, x, y, name )
	int	parent,x,y;
	char *name;
{
Window bw;
char *calloc();
Arg bargs[3];
char *pname;

	pname = calloc(1,strlen(name)+1);
	strcpy(pname,name);
	XtSetArg( bargs[0], XtNlabel, pname );
	XtSetArg( bargs[1], XtNfunction, ButtonAction );
	XtSetArg( bargs[2], XtNparameter, pname );
	bw = XtCommandCreate( (Window) parent, bargs, XtNumber(bargs) );
	XMoveWindow( bw, x, y );
	return bw;
}

int
MakeButtonBox( parent, x, y, w, h )
	Window	parent;
	int	x,y,w,h;
{
Arg bbargs[4];	

	XtSetArg( bbargs[0], XtNx, x );
	XtSetArg( bbargs[1], XtNy, y );
	XtSetArg( bbargs[2], XtNwidth, w );
	XtSetArg( bbargs[3], XtNheight, h );
	return XtButtonBoxCreate( parent, bbargs, XtNumber(bbargs) );
}

int
AddToButtonBox( pw, bw )
	Window	pw, bw;
{
Arg	bbargs[1];

	XtSetArg( bbargs[0], XtNwindow, bw );
	(void) XtButtonBoxAddButton( pw, bbargs, XtNumber(bbargs) );
}

int
MakeAskFor( parent, prompt, initval, x, y )
	Window parent;
	char *prompt;
	char *initval;
	int	x,y;
{
Window w;

	w = XtDialogCreate( parent, prompt, initval, NULL, 0 );
	XtDialogAddButton( w, "Okay", ButtonAction, "Okay" );
	XtDialogAddButton( w, "Cancel", ButtonAction, "Cancel" );
	MoveWindow( w, x, y );
	return w;
}

char *
GetAskForString( w )
	Window w;
{
	return XtDialogGetValueString(w);
}

static int GetFile( fn, where )
	char *fn;
	char **where;
{
FILE *fp;
long len;
char *malloc();
char *buf;

	if( (fp = fopen(fn,"r")) == NULL )
	{
		printf("unable to open requested file '%s'\n",fn);
		return -1;
	}
	fseek( fp, 0L, 2 );
	len = ftell( fp );
	fseek( fp, 0L, 0 );
	buf = malloc( len+1 );
	if( fread( buf, 1, len, fp ) != len )
	{
		printf("fread() failed\n");
		fclose(fp);
		return -1;
	}
	fclose(fp);
	*where = buf;
	return len;
}

int
MakeTextEditor( parent, fn, x, y, w, h )
	Window parent;
	char *fn;
	int	x,y,w,h;
{
char *buf;
int	size;
Arg	targs[6];
int	maxsize;
Window	win;

	size = GetFile( fn, &buf );
	if( size < 1 )
		return 0;

	printf("file '%s' contains %d bytes\n",fn,size);
	maxsize = 1024 + (2*size);

	XtSetArg( targs[0], XtNeditType, XttextEdit );
	XtSetArg( targs[1], XtNtextOptions, scrollVertical );
	XtSetArg( targs[2], XtNstring, buf );
	XtSetArg( targs[3], XtNlength, maxsize );
	XtSetArg( targs[4], XtNwidth, w );
	XtSetArg( targs[5], XtNheight, h );

	win = XtTextStringCreate( parent, targs, XtNumber(targs) );
	XMoveWindow( win, x, y );
	return win;
}

int
GetTextEditorPos( w, pos1, pos2 )
	Window	w;
	char *	pos1;
	char *	pos2;
{
long	beg;
long	end;

	XtTextGetSelectionPos( w, &beg, &end );
	sprintf(pos1,"%ld",beg);
	sprintf(pos2,"%ld",end);
	return 0;
}


int
SetTextEditorPos( w, pos1, pos2 )
	Window	w;
	int	pos1;
	int	pos2;
{
	XtTextSetNewSelection( w, pos1, pos1 );
	return 0;
}

char *
GetTextEditorSelection( nbytes )
	char *nbytes;
{
char *	buf;
int	num;

	buf = XFetchBytes( &num );
	sprintf(nbytes,"%d",num);
	
	if( theTextBuffer )
		free( (char *) theTextBuffer );
	theTextBuffer = buf;
	return buf;
}

int
TextEditorReplace( w, start, end, buf )
	Window	w;
	long	start, end;
	char *	buf;
{
	XtTextUnsetSelection( w );
	XtTextReplace( w, start, end, buf );
	return 0;
}

/* -----  Menu Manager Glue  -------------------------- */

static int
HandleName( mbp )

	MenuBarPtr	mbp;
{
	ev_SendMsg( mbp->mbarName, "NameHit" );
	return 0;
}

static int
HandleMenu( mp, item )

	MenuPtr		mp;
	int		item;
{
char	msg[MAXSTR];
char *	itemName;
ItemPtr	ip;
	
	ip = mm_GetItemHandle( mp, item );
	sprintf(msg, "MenuHit `%s` `%s`", mp->menuTitle, ip->itemLabel );
	ev_SendMsg( mp->menuBar->mbarName, msg );
}

extern FontFamily	mm_Fonts;
static int		MBarHeight = 20;

int
MakeMenuBarWindow( parent, name, x, y, w, h )
	Window parent;
	char *name;
	int	x,y,w,h;
{
MenuBarPtr	menubar;
static char *env = "xs";
Window	win;
DefsPtr	d = &mm_Defs;

	menubar = mm_GetMenuBar( env, 1, name );
	if( !menubar )
		return 0;
	MBarHeight = mm_MBarsHeight(d,mm_Fonts);
	win = XCreateWindow( parent, x, y, w, h+MBarHeight,
		2, BlackPixmap,WhitePixmap );
	mm_SetNameCallback( menubar, HandleName );
	mm_SetMenuCallback( menubar, HandleMenu );	
	mm_AttachMenuBar( menubar, win );
	
	return win;
}



int
MenuBarHeight()
{
	return MBarHeight;
}


int
IconXlate( w )

	Window	w;
{
WindowInfo	wi1, wi2;
int		steps = 20;
int		xs,ys,ws,hs,i,j;
int		pel;

	pel = BlackPixel;
	XQueryWindow( w, &wi1 );
	if( !wi1.assoc_wind )
	{
		fprintf(stderr,"IconXlate: window has no associate\n");
		return -1;
	}

	XQueryWindow( wi1.assoc_wind, &wi2 );
	XUnmapWindow( w );
	XFlush();

	for( j=0, i=0; i<steps; i++ )
	{
		xs = (wi2.x - wi1.x)/steps;
		ys = (wi2.y - wi1.y)/steps;
		ws = (wi2.width - wi1.width)/steps;
		hs = (wi2.height - wi1.height)/steps;

		DrawBox( RootWindow,
			wi1.x + (i*xs),
			wi1.y + (i*ys),
			wi1.width + (i*ws),
			wi1.height + (i*hs),
			2,
			pel,
			GXinvert,
			AllPlanes );

		if( i>2 )
		{
		DrawBox( RootWindow,
			wi1.x + (j*xs),
			wi1.y + (j*ys),
			wi1.width + (j*ws),
			wi1.height + (j*hs),
			2,
			pel,
			GXinvert,
			AllPlanes );
		j++;
		}

		XFlush();
		mpause(20);
	}

	for( ; j<steps; j++ )
		DrawBox( RootWindow,
			wi1.x + (j*xs),
			wi1.y + (j*ys),
			wi1.width + (j*ws),
			wi1.height + (j*hs),
			2,
			pel,
			GXinvert,
			AllPlanes );
	
	XMapWindow( wi1.assoc_wind );
	return 0;
}

int
DrawBox( win, x,y, w,h, thickness, pixel, func, planes )

	Window 	win;
	int	x,y,w,h,thickness,pixel,func,planes;
{
static Vertex	vlist[5];

	vlist[0].x = x;
	vlist[0].y = y;
	vlist[1].x = (x+w)-1;
	vlist[1].y = y;
	vlist[2].x = (x+w)-1;
	vlist[2].y = (y+h)-1;
	vlist[3].x = x;
	vlist[3].y = (y+h)-1;
	vlist[4].x = x;
	vlist[4].y = y;
	XDraw( win, vlist, 5, thickness, thickness, pixel, func, planes );
	return 0;
}
