
environment k1
{
	-- declarations section; all of the C globals which can be accessed

	Cint	theTextBuffer;

	Cfunc	theObj() returns Cstr;
	Cfunc	theEnv() returns Cstr;
	Cfunc	theCode() returns Cstr;

	Cfunc	XtTextUnsetSelection( Cint );
	Cfunc	GetTextEditorPos( Cint, Cstr, Cstr );
	Cfunc	SetTextEditorPos( Cint, Cint, Cint );
	Cfunc	GetTextEditorSelection( Cstr ) returns Cint;
	Cfunc	TextEditorReplace( Cint, Cint, Cint, Cstr );
	Cfunc	QueryWindow( Cint, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	ChangeWindow( Cint, Cint, Cint );
	Cfunc	QueryHeight( Cint ) returns Cint;
	Cfunc	XQueryWidth( Cstr, Cint ) returns Cint;
	Cfunc	GXCOPY() returns Cint;
	Cfunc	ALLPLANES() returns Cint;
	Cfunc	myWindow() returns Cint;
	Cfunc	GetAFont( Cstr ) returns Cint;
	Cfunc	ShowText( Cint, Cint, Cint, Cstr, Cint, Cint, Cint );
	Cfunc	theRoot() returns Cint;	
	Cfunc	WhitePM() returns Cint;
	Cfunc	BlackPM() returns Cint;
	Cfunc	MakeWindow( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	RegisterWindow( Cint, Cstr );
	Cfunc	MapWindow( Cint );
	Cfunc	MapChildren( Cint );
	Cfunc	UnMap( Cint );
	Cfunc	ClearWindow( Cint );
	Cfunc	strlen( Cstr ) returns Cint;
	Cfunc	FlushEvents();
	Cfunc	Beep();
	Cfunc	MoveWindow( Cint, Cint, Cint );
	Cfunc	MakeButton( Cint, Cint, Cint, Cstr ) returns Cint;
	Cfunc	MakeButtonBox( Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	AddToButtonBox( Cint, Cint );
	Cfunc	MakeAskFor( Cint, Cstr, Cstr, Cint, Cint ) returns Cint;
	Cfunc	GetAskForString( Cint ) returns Cstr;
	Cfunc	MakeTextEditor( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	XtSendDestroyNotify( Cint );
	Cfunc	XDestroyWindow( Cint );
	Cfunc	Quit();
	Cfunc	MakeMenuBarWindow( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	MenuBarHeight() returns Cint;
	Cfunc	SetIconWindow( Cint, Cint );
	Cfunc	IconSwitch( Cint );
	Cfunc	MakePixmap( Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	XPixmapPut( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint );
	Cfunc	MakeCursor( Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	XDefineCursor( Cint, Cint );
	Cfunc	XUndefineCursor( Cint );
	Cfunc	GetColor( Cstr ) returns Cint;

	Cfunc	RegisterTW( Cint );
	Cfunc	DeRegisterTW( Cint );
	Cfunc	WindowFromTW( Cint ) returns Cint;

	Cfunc	TextCreate( Cint, Cint, Cint, Cint, Cint, 
			Cstr, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	TextDestroy( Cint );
	Cfunc	TextClear( Cint );
	Cfunc	TextRedisplay( Cint );
	Cfunc	TextPutString( Cint, Cstr );
	Cfunc	TextPutChar( Cint, Cint );
	Cfunc	TextPutLine( Cint, Cstr );
	Cfunc	TextFlush( Cint );	

	-- end of C declarations

	function GetIconWindowSize( iw, ih, name, f, width, height )
	{
		put XQueryWidth( name, f ) into strWidth;
		put QueryHeight( f ) into strHeight;
		put (strWidth+20) into w;
		if( (iw+20) > w )
			{ put (iw+20) into w; }
		put ((strHeight+ih)+30) into h;
		put w into width;	-- return this value
		put h into height;	-- return this value
	}

	function PlotIcon( window, pm, iw,ih, name, f )
	{
		QueryWindow( window, w,h,x,y, bdr, mapped, type, assoc );
		put 10 into destSX;
		put (ih+20) into destSY;
		put ((w-iw)/2) into destIX;  -- center icon width-wise
		put 10 into destIY;
		XPixmapPut( window, 0,0,destIX,destIY,iw,ih,pm,
			GXCOPY(), ALLPLANES() );
		ShowText( window, destSX,destSY, name, strlen(name), f, 0 );
	}


}
