#include <X/Xlib.h>
#include <signal.h>
#include <sys/time.h>


Window windowid;

/************************
*  Event data
*
*	This union is needed to get at the details of an event.  
*	The fact that the Xevent structure and the particular
*	event description structures occupy the same memory is
*	not described in the Xlib documentation.  The detail fields
*	of an event are accessed through this union as   
*			event.keypress.detail  
*	etc.   One other point; the input calls, XNextEvent, etc. need
*	a pointer, therefore the address of the union is passed.
*/
union evnt { XEvent                rep;
	     XKeyPressedEvent      keypress;
	     XButtonPressedEvent   buttpress;
	     XButtonReleasedEvent  buttrelease;
	     XEnterWindowEvent	   enterwin;
	     XLeaveWindowEvent	   exitwin;
	     XMouseMovedEvent      mousemove;
          } event;


Font f;

int timer();
int tries = 0;


/********************************************************************
* MAIN
*
* 
*
*/
main()
{

int count = 0;
int d;
int len;
char *msg[30];

struct itimerval timvl;
struct itimerval *timval = &timvl;
struct itimerval timovl, *timoval = &timovl;
int timetype;


/*********************
* Initialize the timer 
*/

timvl.it_value.tv_sec = 1;
timvl.it_value.tv_usec = 0;
timvl.it_interval.tv_sec = 1;
timvl.it_interval.tv_usec = 0;




/*********************
*   Open the X display
*       For some reason, the signal alarm sent the thing back through
*       these parts on the first interrupt.  `Tries' is a fix to keep
*	it from trying to reinitialize the windows.
*/

if(++tries == 1 && XOpenDisplay(0) == 0)
  { printf("Failed XOpenDisplay on %s\n",getenv("DISPLAY"));
    exit(1);
   }


/**********************
*  Create a root window
*/
if(tries == 1){  
  windowid = XCreateWindow(RootWindow,
			 50,
			 50,
			 400,
			 200,
			 3,
			 BlackPixmap,
			 WhitePixmap);


  XMapWindow(windowid);


/**********************
*  Set up the font.
*/

  if((f = XGetFont("timrom12b")) == 0)
    {  printf("Failed XGetFont timrom12b\n");
       exit(1);
     }



/***********************
*  Select inputs to root
*/

  XSelectInput(windowid, ButtonPressed | ButtonReleased | KeyPressed);


/***************************
*  Start the timer interrupt.
*/

  setitimer(timetype,timval,0);

  (*signal(SIGALRM,timer))();

}  /* this guy marks the end of the init stuff, protected by `tries' */






/************************************************************************
*   MAIN CONTROL loop starts here.
*
*    What this thing does is wait for an event from the user.  It 
*    finds out what kind of event it's got, then calls a jobber to
*    take care of it.
*/

while(1){



/********************************************
*  Get next event;  blocks if queue is empty.
*/

  XNextEvent(&event.rep);

  switch (event.rep.type){
	case  ButtonPressed:
		d = event.buttpress.detail;
  		sprintf(msg,"Button Press %d",d);
  		len = strlen(msg);
  		XText(windowid,
			100,125,msg,len,f,BlackPixel,WhitePixel);
		break;

	case  ButtonReleased:
		d = event.buttrelease.detail;
  		sprintf(msg,"Button Release %d",d);
  		len = strlen(msg);
  		XText(windowid,
			100,140,msg,len,f,BlackPixel,WhitePixel);
		break;

	case  KeyPressed:
		d = event.keypress.detail;
  		sprintf(msg,"Keycode %d",d);
  		len = strlen(msg);
  		XText(windowid,
			100,110,msg,len,f,BlackPixel,WhitePixel);
	
		break;

	case  EnterWindow:
		break;

	case  LeaveWindow:
		break;

	case  MouseMoved:
		break;
   }

   XFlush();

  
 }

}/***********   END MAIN  **************************/



/************************************************************************
*   TIMER CONTROL LOOP
*      	This one fires up on every alarm.  Goes through the list of 
*	timed events, then goes back to sleep.
*/
int 
timer()
{
  static int count;
  char *msg[30];
  int len;

  ++count;
  sprintf(msg,"Timer%d",count);
  len = strlen(msg);

  XText(windowid,
	100,10,msg,len,f,BlackPixel,WhitePixel);
  XFlush();
}

