#include <stdio.h>
#include <sys/types.h>
#include <X10/Xlib.h>
#include </mit/visual/tools/include/X10/Xtlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "lkups.h"
#include "prsdefs.h"
#include "structs.h"
#define FN_MISC 
#define SETPOS extern
#include "functions.h"
#define VDISC extern
#include "vdisc.h"


#define MATCH 0
char *index();

void
quit()
{
	exit();
}

Fake(tag)
caddr_t tag;
{
  printf("No callback proc specified\n");
}

void
grabvideo(pack)
  	Packpos   *pack;
{
	static char  	*func = "Grabvideo";
	int  		status;
	WindowInfo      info;
	Element		*e;
	Package		*p = pack->p;

printf("%s\n",func);

	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(pack->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,func, pack->pname);
	     		 }
      	 	 }
		pack->p = p = tpck;
	}		

 	for(e = p->element; e && e->type != FREE_VIDEO; e = e->next);

  	if( ! XQueryWindow(e->screen->s->w,&info))
	{
		printf("%s: failed XQueryWindow\n",func);
		exit(1);
	 }

/*  	if((status = XScaleVideo(e->screen->s->w, 0, 0, 640, 480, 
				0, 0, info.width,info.height)) == -1)
	{
	  	printf("%s: failed XScaleVideo to 0,0,%d,%d in window %d\n",
			func,info.width,info.height,e->screen->s->w);
		exit(1);
	 }
*/
	if((status = XStillVideo(e->screen->s->w,0,0,0,0, info.width,info.height)) == -1)
	{
		printf("%s: failed XStillVideo in window %d\n",
	    	    func, e->screen->s->w);
		exit(1);
	 }

	XFlush();

}

void
StringFunction(string)
 caddr_t string;
{
	printf("StringFunction  parameter %s\n", string);
}

void
video(string)
 caddr_t string;
{
	int  res;
	char *cmd = string;

	PerformVideoService(v$server,cmd,&vdt,&v$code,&v$val,&v$err);

}

void
system(string)
 caddr_t string;
{
	int  res;
	char *cmd = string;

	system(cmd);
}


void 
scroll(scrW, value, intpos)
  Window scrW;
  caddr_t value;
  int intpos;
{
  	printf("pos %d   value `%s'\n",intpos,value);
}



void 
thumb(scrW, value, tp)
  Window scrW;
  caddr_t value;
  float tp;
{
  static char	*string;
  int		len;

  	printf("Thumb percent %f, value `%s'\n",tp,value);

}

void 
scroll_control_package(scrW, value, tp)
  Window 	scrW;
  Packpos   	*value;
  float 	tp;
{
  	Package		*tpck, *p = value->p;
  	Dimension	*dim;
	DimRep          *dr;
	int		d, pos;
	Position	tmp;
	Element         *e;
	WindowInfo      info;
	int		i, status, zero = 0;
	char 		cmd[Nchars];
	
	static char 	*func = "scroll_control_package";

	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(value->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,func, value->pname);
	     		 }
      	 	 }
		value->p = p = tpck;
	}		

/*  The position that gets passed in as argument is to be used as a 
*   flag array to indicate what dimension is to be set.
*/
	if(value->dimname != NULL)
	{
		for(i=0; i < p->ndims; ++i)
	        {
			if(! strcmp(value->dimname,p->dimension[i]->name))
			{
				value->pos[i] = 1;
			 }
		 }
	 }

	for(d = 0; value->pos[d] < 1 && d < p->ndims; ++d);
	if( d >= p->ndims )
	{
		printf(" no dimension specified\n");
		return;
	 }

	dim = p->dimension[d];

	for(dr = dim->rep; dr; dr = dr->next)
	{
		if (dr->m->simple.w == scrW) break;
	 }

	if(dr && dr->feature == _RATE)
	{
		stop_timer(dim);
		dim->rate = (tp * (dim->maxrate - dim->minrate))+ dim->minrate;
		dim->interval = dim->rate_setting = dim->rate;
		start_timer(dim, &zero, 0);

	 }

	else if(dr && dr->feature == _RANGE)
	{
		dim->range = (dr) ? (tp * (dr->high - dr->low)):
			(tp * ((int)dim->maxi - (int)dim->mini));
	 }
	else
	{

		pos = (dr) ?  (tp * (dr->high - dr->low)) + dim->mini
	    	    : (tp * (dim->maxi - dim->mini)) + dim->mini;
		p->dimension[d]->current = pos;
		p->prev_position[d] = p->position[d];
		p->position[d] = pos;

	 	e = p->element;
		while(e !=0)
		{
			if(disc->controlling_element == e) 
			{
		     	   dim = e->p->dimension[e->map->simple.key_dimension];
			    Vdisc_still(e->map->simple.rpd);
			   
			    if( ! XQueryWindow(e->screen->s->w,&info))
  			    {
	  			     printf("%s: failed XQueryWindow\n"
				        ,func);
				     exit(1);
	 		     }

			    if((status = XStillVideo(e->screen->s->w,0,0,
				0, 0, info.width,info.height)) == -1)
			    {
	  			printf("%s: failed XStillVideo in window %d\n",
			    	    func, e->screen->s->w);
				exit(1);
	 		     }
			    disc->operation = VDSC_STOPPED;
		        
		   	    stop_timer(dim);
   			    dim->rate = 0;
			    dim->rate_setting = dim->rate_default;
		     }
		   e = e->next;
	        }
		XFlush();
	 }


	update_package_display(p);
	update_dimension_representations(p);
}


void
update_scrollbar(dr)
	DimRep		*dr;
{
	int 		c;
	float		top, shown;
	static  Arg     arglist[] = 
			{
				{XtNtop, (caddr_t) 0},
				{XtNshown, (caddr_t) 0}
			};
	static  char    *func = "update_scrollbar";


	switch(dr->feature)
	{
		case _POSN:
			c = dr->d->current;
			if(!dr->extent) dr->extent = dr->d->maxi - dr->d->mini;

			if( c > dr->high || c < dr->low)
			{
				dr->low = (c / dr->extent) * dr->extent;
				dr->high = dr->low + dr->extent;
				if(dr->high > dr->d->maxi)
				{
					dr->high = dr->d->maxi;
					dr->low = dr->high - dr->extent;
		 	 	 }
	 		 }
			top = (dr->extent) ? 
			    ((float)(c - dr->low) / (float) dr->extent) : 0;
			shown = (dr->extent) ? 
	    		    ((float)dr->extent /(dr->d->maxi - dr->d->mini)):0;
			break;

		case _RANGE:
			top = dr->d->range;
			break;
		case _RATE:
			top = dr->d->rate;
			break;
	 }

	arglist[0].value = (caddr_t) top;
	/*arglist[1].value = (caddr_t) shown; */

	XtScrollBarSetValues( dr->m->simple.w, arglist, XtNumber(arglist));
}

/*--------------------------------------------------------------------
* 
*/
void
update_digital(dr)
	DimRep		*dr;
{
	char	number[80];
	Font	font = XGetFont("helv10b");

	XClear(dr->m->simple.w);
	sprintf(number,"%d",dr->d->current);
	XText(dr->m->simple.w,3,3,number,strlen(number),font,1,0);
}

/*--------------------------------------------------------------------
*  gets called from display_text in displays.c
*/
void
set_text_position(textwin, offset)
	Window	textwin;
	int	offset;
{
	static  char	*func = "set_text_position";
	static  Arg     arglist[] = 
			{
				{XtNdisplayPosition, (caddr_t) 0},
				{XtNinsertPosition, (caddr_t) 0}
			};

	arglist[0].value = (caddr_t) offset;
	arglist[1].value = (caddr_t) offset;

	XtTextSetValues( textwin, arglist, XtNumber(arglist));

}

/*--------------------------------------------------------------------
*  GLOSSARY LOOKUP  Keywords in glossary file start in 1st space; other
*                   lines are indented.  This routine recieves a 
*		    Packpos as input.  The element field contains the
*		    pointer to the source text widget.  The package field
*		    points to the glossary package.  The glossary is 
*		    assumed to be the first text element in the package.
*/
void
glossary_lookup(pack)
	Packpos	*pack;
{
	static char 	*func = "glossary_lookup";

	FILE		*fp;
	Package 	*p;
	Element		*e, *gloss;
	char    	*source, target[Nchars];
	int		pos1, pos2, nbytes, filepos;

	
	p = first_package;
	while(strcmp(pack->pname, p->name) != MATCH)
       	{
    		if((p = p->next) == 0)
    		{
			printf("%s: can't find package `%s'\n"
			    ,func, pack->pname);
    		 }
 	 }
	pack->p = p;

	source = (char *) XFetchBytes( &nbytes);
	for( gloss = p->element; gloss; gloss = gloss->next)
	{
		if( gloss->type == TEXT) break;
	 }
	if( !gloss )
	{
		printf("%s: no text element found in package %s\n"
		    ,func, p->name);
	 }

	if( ( fp = fopen(gloss->file,"r")) == NULL)
	{
		printf("%s: failed to open %s\n",func,gloss->file);
	 }

	while( !feof(fp))
	{
		filepos = ftell(fp);
  		fgets(target, Nchars, fp);

		if(strlen(target) && target[0] != ' ' && target[0] != '\t' 
		   &&target[0] != '\n')
		{
			target[nbytes] = '\0';
			if ( ! strcmp(source, target))
			{
				set_text_position(gloss->w, filepos);
				break;
			 }
		 }
	 }
        free(source);

}


evaluate(t)
     char 	*t;
{

}
/*--------------------------------------------------------------------
*  LOOKUP ACTION    Keywords in action file start in 1st space; other
*                   lines are indented.  This routine recieves a 
*		    Packpos as input. The element field contains the
*		    pointer to the source text widget.  The package field
*		    points to the glossary package.  The glossary is 
*		    assumed to be the first text element in the package.
*/
void
lookup_action(pack)
	Packpos	*pack;
{
	static char 	*func = "lookup_action";

	FILE		*fp;
	Package 	*p;
	Element		*e, *gloss;
	char    	*source, target[Nchars];
	int		pos1, pos2, nbytes, filepos;

	
	p = first_package;
	while(strcmp(pack->pname, p->name) != MATCH)
       	{
    		if((p = p->next) == 0)
    		{
			printf("%s: can't find package `%s'\n"
			    ,func, pack->pname);
    		 }
 	 }
	pack->p = p;

	source = (char *) XFetchBytes( &nbytes);

	for( gloss = p->element; gloss; gloss = gloss->next)
	{
		if( gloss->type == TEXT) break;
	 }
	if( !gloss )
	{
		printf("%s: no text element found in package %s\n"
		    ,func, p->name);
	 }

	if( ( fp = fopen(gloss->file,"r")) == NULL)
	{
		printf("%s: failed to open %s\n",func,gloss->file);
	 }

	while( !feof(fp))
	{
		filepos = ftell(fp);
  		fgets(target, Nchars, fp);

		if(strlen(target) && target[0] != ' ' && target[0] != '\t' 
		   &&target[0] != '\n')
		{
			target[nbytes] = '\0';
			if ( ! strcmp(source, target))
			{
				fgets(target, Nchars, fp);
			  	evaluate(target);
				break;
			 }
		 }
	 }
        free(source);

}

/*--------------------------------------------------------------------
*  Label Equals
*  	This routine receives a graphic object and a dimension as
*  args.  It changes the current position of the dimension into a 
*  string and stuffs it into the graphic label slot.
*/
  char *
set_label_equal(m,args)
	Map	*m;
	char    *args;
{
	static char	*func = "set_label_equal";
	Package		*p;
	int		i, feature;
	char		*packname, *dimname, *p1, *p2;
	char		str[Nchars];


	strcpy(str,args);
	p1 = str + 1;  /* cut off the open parenthesis */
	if((p2 = index(p1,',')) == NULL)      /* find the comma */
	{
		printf("%s: arguments should be (package,dimension,feature), e.g. set_label_equal(test,time,rate)\n",func);
		exit(1);
	 }
	*p2 = '\0';
	packname = newstr(p1);
	p1 = p2 + 1;  /* cut off the comma */
	if((p2 = index(p1,',')) == NULL)  /* find second comma */
	{
		printf("%s: arguments should be (package,dimension,feature), e.g. set_label_equal(test,time,rate)\n",func);
		exit(1);
	 }
	*p2 = '\0';
	dimname = newstr(p1);
	p1 = p2 + 1;
	if((p2 = index(p1, ')')) == NULL)  /* find the end */
	{
		printf("%s: arguments should be (package,dimension,feature), e.g. set_label_equal(test,time,rate)\n",func);
		exit(1);
	 }
	*p2 = '\0';
	feature = (strcmp(p1,"rate"))? _POSN : _RATE;

	p = first_package;
	while(strcmp(p->name, packname) != MATCH)
       	{
    		if((p = p->next) == 0)
    		{
			printf("%s: can't find package `%s'\n"
			    ,func, packname);
     		 }
 	 }

	for(i = 0; p->dimension[i] 
		   && (strcmp(p->dimension[i]->name,dimname)); ++i);
		if(!p->dimension[i])
		{
		      printf("%s: can't find dimension `%s' in package `%s'\n",
			   func, dimname, packname);
		      exit(1);	
		 }

	if(feature == _RATE)
	{
		sprintf(str,"%d",p->dimension[i]->rate);
	 }
	else
	{
		sprintf(str,"%d",p->dimension[i]->current);
	 }
	cfree(m->graphic.label);
	m->graphic.label = newstr(str);
	return(str);
	

}



/*--------------------------------------------------------------------
*  Grahic Point Linear
*  	This routine receives a graphic object, a dimension, and 2 
*  constants as args.  It 
*/
    int
set_xy_linear(args)
	char    *args;
{
	static char	*func = "set_xy_linear";
	Package		*p;
	int		y,i,b,feature;
	double           m;
	double          atof();
	char		*packname, *dimname, *p1, *p2;
	char		str[Nchars];


	strcpy(str,args);
	p1 = str + 1;  /* cut off the open parenthesis */

	if((p2 = index(p1,',')) == NULL)
	{
		printf("%s: arguments should be (slope,package,dimension,feature,b), e.g. set_label_equal(.2,test,time,rate,10)\n",func);
		exit(1);
	 }
	*p2 = '\0';
	m = atof(p1);
	p1 = p2 + 1;  /* cut off the comma */

	if((p2 = index(p1,',')) == NULL)      /* find the comma */
	{
		printf("%s: arguments should be (slope,package,dimension,feature,b), e.g. set_label_equal(.2,test,time,rate,10)\n",func);
		exit(1);
	 }
	*p2 = '\0';
	packname = newstr(p1);
	p1 = p2 + 1;  /* cut off the comma */
	if((p2 = index(p1,',')) == NULL)  /* find second comma */
	{
		printf("%s: arguments should be (package,dimension,feature), e.g. set_label_equal(test,time,rate)\n",func);
		exit(1);
	 }
	*p2 = '\0';
	dimname = newstr(p1);
	p1 = p2 + 1;
	if((p2 = index(p1,',')) == NULL)
	{
		printf("%s: arguments should be (slope,package,dimension,feature,b), e.g. set_label_equal(.2,test,time,rate,10)\n",func);
		exit(1);
	 }
	*p2 = '\0';
	if(!strcmp(p1,"range")) feature = _RANGE;
	else feature = (strcmp(p1,"rate"))? _POSN : _RATE;
	p1 = p2 + 1;

	if((p2 = index(p1, ')')) == NULL)  /* find the end */
	{
		printf("%s: arguments should be (package,dimension,feature), e.g. set_label_equal(test,time,rate)\n",func);
		exit(1);
	 }
	*p2 = '\0';
	b = atoi(p1);

	p = first_package;
	while(strcmp(p->name, packname) != MATCH)
       	{
    		if((p = p->next) == 0)
    		{
			printf("%s: can't find package `%s'\n"
			    ,func, packname);
     		 }
 	 }




	for(i = 0; p->dimension[i] 
		   && (strcmp(p->dimension[i]->name,dimname)); ++i);
		if(!p->dimension[i])
		{
		      printf("%s: can't find dimension `%s' in package `%s'\n",
			   func, dimname, packname);
		      exit(1);	
		 }

	switch( feature )
	{
		case _RATE:
			y = (m * p->dimension[i]->rate) + b;
			break;
		case _RANGE:
			y = (m * p->dimension[i]->range) + b;
			break;
		default: 
			y = (m * p->dimension[i]->current) + b;
			break;
	 }

	return(y);
	

}




