#include <stdio.h>
#include <X/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"
#include "defs.h"

extern Screen *screen_sets[Screen_sets];
extern make_tk_widget();

#define MATCH 0

resolve_names()
{
  char 		*funcname = "resolve_names";
  Screen 	*s;
  Element 	*ele, *tele;
  Package 	*pck, *tpck;
  Map		*m;
  int 		i;


/*
*  Resolve Names
*
*  The routine goes through the list of packages and resolves the
*  names referenced by that package.  First it finds the packages in
*  the `next' slot.  Then it finds the window set listed in `screen_name'.
*  The windows have already been created by Makewindows() before coming
*  here.
*
*  Once it has the set of windows to work from, it starts down
*  the list of elements in the package.
*  For each element, it resolves the `next' name and finds the display
*  window for that element in the list of windows held by the parent
*  package.
*
*  If the element is a widget of some sort, then it goes down the list
*  of mappings to actually build the widgets and get the window pointers
*  for them.  Coming in, the data for the widget is held in the
*  `map->simple.w' slot, as a pointer to a struct of the appropriate type.
*/

	pck = first_package;

	while(pck != 0)
	{
  		if(strlen(pck->nextname))
		{
    		    tpck = first_package;
    		    while(strcmp(pck->nextname, tpck->name) != MATCH)
      		    {
			  if((tpck = tpck->next) == 0)
	  		  {
	    		    printf("%s: can't match next: %s in package %s\n"
		   		,funcname, pck->nextname, pck->name);
	    		    exit(1);
	  		   }
      	 	     }
    		    pck->next = tpck;
  		 }
 

		if(strlen(pck->screen_name))
		{
  		   	for(i=0; i < Screen_sets; ++i)
			{
      				if(strcmp(pck->screen_name, 
					screen_sets[i]->name) == MATCH)
				{
      					break;
    				 }
			 }

			if(i < Screen_sets)
			{
  				pck->window = screen_sets[i];
			 }
    			else
			{
      		          	printf("%s: can't match screen named %s in package %s\n",funcname, pck->screen_name, pck->name);
      			  	exit(1);
    			 }
   			 
		 }
		else
		{
  			printf("%s: missing screen name in package %s\n"
				,funcname,pck->name);
  			exit(1);
		 }



/*
*   For each element in the current package, check to see if it's a 
*   widget type.  If so, create the widget(s).  Then, for all elements,
*   find out what window they're supposed to be mapped into.
*/
		ele = pck->element;
		while(ele != 0)
		{
			if(ele->type == TK_WIDGET)
			{
				m = ele->map;
				while(m != 0)
				{
				        if(m->simple.type > Unused_map)
					{
					    make_tk_widget(m);
					    m = m->simple.next;
					 }
					else free((char *)m); 
				 }
			}

			if(strlen(ele->screen_name))
			{
				s = pck->window;
				while(strcmp(ele->screen_name, s->name) 
						!= MATCH)
			        {
					if((s = s->next) == 0)
					{
					      printf("%s: can't match screen: %s in element %s\n"
					           ,funcname, ele->screen_name
						   , ele->name);
					      exit(1);
					 }
				 }
	      			ele->w = s->w;

			}
	
			ele = ele->next;    
  
  		}

	pck = pck->next;
	 
	}

}




Window
findparent(i, name, child)
 int i;
 char *name, *child;
{
  char *funcname = "findparent";
  Screen *s;
  
  s = screen_sets[i];
  while (s != 0){
    if(strcmp(name, s->name)){
      s = s->next;
    }
    else{
      if (s->w) return(s->w);
      else{
            printf("%s: can't create child %s before parent %s\n",
		     funcname,child,name);
	    exit(1);
	  }
    }
  }
 
  printf("%s: can't find window named %s in this set.\n",funcname,name);
  exit(1);    
}



int
makewindows()
{
char *funcname = "makewindows";
Screen *s;
OpaqueFrame frame;
int i;

for(i=0;(s = screen_sets[i]);++i){
  while(s != 0){
    switch(s->type){


    case WINDOW:

      s->w = XCreateWindow(
		    strcmp(s->parentname, "RootWindow") ? 
			   (Window)findparent(i,s->parentname, s->name) :
			   RootWindow, 
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );


      if (s->w == 0) {
	printf("%s: can't open opaque window\n", funcname);
	exit(1);
      }
      XMapWindow(s->w);

      break;

    case TRANSPARENCY:
      printf("making transparent window named %s\n",s->name);

      s->w = XCreateTransparency(
		    strcmp(s->parentname, "RootWindow") ? 
			   (Window)findparent(i,s->parentname, s->name) :
			   RootWindow, 
			   s->x,
			   s->y,
			   s->width,
			   s->height  );

        if (s->w == 0) {
	  printf("%s: can't open transparent window\n", funcname);
	  exit(1);
	}
        XMapWindow(s->w);

       break;

    case VIDEO:
printf("making video window named %s\n",s->name);

      s->w = XCreateVideoWindow (
		    strcmp(s->parentname, "RootWindow") ? 
			   (Window)findparent(i,s->parentname, s->name) :
			   RootWindow, 
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );

      if (s->w == 0) {
	printf("%s: can't open video window\n", funcname);
	exit(1);
      }

        XMapWindow(s->w);
        XStartVideo(s->w,0,0,PRIO_2);

        break;

    case STILL:
printf("making still video named %s\n",s->name);

      s->w = XCreateVideoWindow (
		    strcmp(s->parentname, "RootWindow") ? 
			   (Window)findparent(i,s->parentname, s->name) :
			   RootWindow, 
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );

      if (s->w == 0) {
	printf("%s: can't open video window\n", funcname);
	exit(1);
      }

      break;
    default:
      break;
  }

  s = s->next;
  }
}
  XFlush();
}
