@@poundinclude <ssdef.h>   /* system service definitions */
@@poundinclude <smgdef.h>  /* the Screen Management Guideline definintions */
@@poundinclude <stdio.h>   /* the standard io stuff */
@@poundinclude <descrip.h> /* the descriptor definitions */
@@poundinclude <iodef.h>   /* more io stuff */

@@poundinclude "char.c"
@@poundinclude "ivis.c"    /* contains a list of ivis escape sequences  */


/*  these are the field labels within the node array   */

@@pounddefine NODE_NUM 0;
@@pounddefine FROM_NUM 1;
@@pounddefine TO_NUM 2;
@@pounddefine LEFT 3;
@@pounddefine RIGHT 4;
@@pounddefine STRAIGHT 5;
@@pounddefine BACK 6;
   
char *c;
char dummy, instring[80];
from_road_array[][6];

/**********************************************************************/
/*   main                                                             */


main()
{
  int current_node, from, to;



/************************************************************************/
/* setup the vars for the single char input functions defined in char.c */

  char *buffer = calloc( 1, 6 * sizeof(char) );

  int  size = 6;

  input_ptr = calloc( 1, sizeof(struct input_struct) );
  iosb_ptr  = calloc( 1, sizeof(struct iosb) );
  block_ptr = calloc( 1, sizeof(struct block) );
  block_ptr->buffer = buffer;
  block_ptr->size   = size;

  open_input( input_ptr );


/********************************************************************/
/* start things up

   load_array();
   ivis_load();
   ivis_mode_mixed();



/****************************************************************/
/*  this is the main loop					*/


   c = get_keyin();  /* get first key command */

   while(c[0] != 'e') {    /* go until "e" is pressed */

	switch (c[0]) {

	  case 's':   /* straight */
                current_node = from_road_array[current_node][STRAIGHT];
		break;
	  case 'l':   /* left */
                current_node = from_road_array[current_node][LEFT];
		break;
	  case 'r':   /* right */
                current_node = from_road_array[current_node][RIGHT];
		break;
	  case 'b':   /* back  */
                current_node = from_road_array[current_node][BACK];
		break;

	}

if(c[0] != 'b'){
    		from = from_road_array[current_node][FROM_NUM];
    		to = from_road_array[current_node][TO_NUM];
    		drive(from, to);
                }

else  	       {
		to = from_road_array[current_node][TO_NUM];
		ivis_find(to);
      		}

    c = get_keyin();  /* get next key command */
  
    }  /* end of while loop */

    ivis_unload();
}  /* end of main loop -- exit program */




/**********************************************************************/
/*   Irene's routine for single character input			      */

get_keyin()
  {
  /* do a qiow to read a single stroke from the keyboard */
  init_input( input_ptr, iosb_ptr, block_ptr );
  
  /* return the pointer to the buffer containing the char(s) */
  return( block_ptr->buffer );
  }


/**********************************************************************/

load_array()
{
  int k = 0;
  FILE *fp;                        
  char *instring[80];


  fp = fopen("roadarray.dat","r");

  while (fscanf(fp,"@@pctd@@pct*s@@pctd@@pctd@@pctd@@pct*s@@pctd@@pct*s@@pctd@@p
ct*s@@pctd@@pct*s"
				   ,&from_road_array[k][NODE_NUM]
				   ,&from_road_array[k][FROM_NUM]
				   ,&from_road_array[k][TO_NUM]
				   ,&from_road_array[k][LEFT]
				   ,&from_road_array[k][RIGHT]
				   ,&from_road_array[k][STRAIGHT]
			   	   ,&from_road_array[k][BACK] ) != EOF ) {


     	++k;
     }

}
S>