/* 
 * sub2.c - subtitling display for Foreign Language courses
 * Matt Hodges, June, 1987
 *
 */

#include <X/Xlib.h>
#include "Toolkit.h"
#include <stdio.h>
#include <signal.h>
#include <sys/time.h>
#include "sub2.h"

#define NO 0
#define YES 1
#define PLX NO







/********************************************************
*  MAIN
*/

void main()
{
    Disp *d;


int count = 0;
int len;
char *msg[30];
Arg buttons[4];
int buttoncount;
int framecount;
float x, ft;
Dsp_ele *tmp;


/**************************
*  Set up the root window
*/
if(++tries == 1 && XOpenDisplay(0) == 0)
  { printf("Failed XOpenDisplay on %s\n",getenv("DISPLAY"));
    exit(1); 
   }

if(tries == 1){

/***********************
*  Start video
*/
#if PLX
  disc = sony_open( 4800, "/dev/tty08" );
#else
	  printf("Video call: sony_open\n");
#endif

/*
  background = XCreateWindow(RootWindow,
			 0,
			 0,
			 DisplayWidth(),
			 DisplayHeight(),
			 3,
			 BlackPixmap,
			 BlackPixmap);
*/

  windowid = XCreateWindow(RootWindow,
			 (1280-700)/2,	 /* centered */
			 100,
			 700,
			 700,
			 3,
			 BlackPixmap,
			 WhitePixmap);

  if((f = XGetFont("timrom12b")) == 0)
    {  printf("Failed XGetFont timrom12b\n");
       exit(1);
     }
  if((tf = XGetFont("sbdr40ssx")) == 0)
    {  printf("Failed XGetFont sbdr40ssx\n");
       exit(1);
     }


  if((f = XGetFont("timrom12b")) == 0)
    {  printf("Failed XGetFont timrom12b\n");
       exit(1);
     }


  XSelectInput(windowid, ButtonPressed 
	               | ButtonReleased 
	               | KeyPressed
	               | MouseMoved
	               | EnterWindow
	               | LeaveWindow);



/*******************************
*  Set up the subtitles window
*/
  subtitles =XCreateWindow(windowid,
			 25,  /* x */
			 645, /* y */
			 650, /* width */
			 50,  /* height */
			 3,   /* border width */
			 BlackPixmap,
			 WhitePixmap);




    XtInitToolkit();

/****************************
*  Display the command buttons
*/
    butbox = XtCreateButtonBox(windowid,bbarglist);

    buttonArgs[0].value = (caddr_t) fwd_label;
    buttonArgs[1].value = (caddr_t) Forward;
    fwd = XtCreateCommand(butbox, buttonArgs);
    addbutton(fwd);

    buttonArgs[0].value = (caddr_t) stp_label;
    buttonArgs[1].value = (caddr_t) Stop;
    stp = XtCreateCommand(butbox, buttonArgs);
    addbutton(stp);

    buttonArgs[0].value = (caddr_t) rev_label;
    buttonArgs[1].value = (caddr_t) Reverse;
    rev = XtCreateCommand(butbox, buttonArgs);
    addbutton(rev);

    buttonArgs[0].value = (caddr_t) mrk_label;
    buttonArgs[1].value = (caddr_t) Mark;
    mrk = XtCreateCommand(butbox, buttonArgs);
    addbutton(mrk);

    (void)XtButtonBoxAddButton(butbox,buttons);

    XMoveWindow(butbox, 5,585);


/********************************
*  Put up the time scroll bar
*/
    sw = XtCreateScrollBar(windowid, scrargs);

    XMoveWindow(sw, 5, 560);

/*******************************
*  Put up the rate scroll bar
*/
    scrargs[1].value = (caddr_t)200;
    scrargs[5].value = (caddr_t)RateThmb;
    rate_scr = XtCreateScrollBar(windowid, scrargs);

    XMoveWindow(rate_scr, 300, 585);

    XLine(rate_scr, 100,10,100,25,1,1,BlackPixel,GXcopy,AllPlanes);

/*******************************
*  Put up the filename dialog
*/
    dbuttons.name = bname;
    dbuttons.funct = FilenameAction;
    dbuttons.param = NULL;

    dvalue.tag = label;
    dvalue.string = instring;
    dvalue.length = 80;

    dw = XtCreateDialog(RootWindow, dialogArgs);

    XMoveWindow(dw, 10, 10);


/*******************************
*  Video Window
*/
#if PLX
	frame.bdrwidth = 0;   /* was 16 */
	frame.border = XMakeTile(BlackPixel);
	frame.background = XMakeTile(VIDBACK);

	v1 = XCreateVideo (
	"Video Window",
		"video",
		"640x480+320+110",
		"640x480+320+110",
		&frame,
		48,
		50);
	if (v1 == FAILURE) {
		printf("Can't open video window\n");
		exit(1);
	}

#else
	  printf("Creating video window\n");
#endif

  XMapWindow(windowid);
  XMapWindow(subtitles);
    XMapWindow(fwd);
    XMapWindow(stp);
    XMapWindow(rev);
    XMapWindow(mrk);
    XMapWindow(butbox);
    XMapWindow(sw);
    XMapWindow(dw);
    XMapWindow(rate_scr);
#if PLX
    XMapWindow(v1);
#endif



display->ele = vidpart;
display->duration = 300; 

vidpart->next = txtpart;
vidpart->w = v1;
vidpart->map = video;
vidpart->current_frame = 0;
vidpart->type = VIDEO_TYPE;
vidpart->state = STOPPED;

video->time = 0;
video->in = 1000;
video->out = 1300;


txtpart->prev = vidpart;
txtpart->w = subtitles;
txtpart->type = TEXT_TYPE;
/*******************************
*  Start up the clock
*/  
  timvl.it_value.tv_sec = 0;
  timvl.it_value.tv_usec = 33333; /* 30th of a second clock res. */
  timvl.it_interval.tv_sec = 0;
  timvl.it_interval.tv_usec = 33333;

  setitimer(timetype,timval,0);

  (*signal(SIGALRM,timer))();
}





/*******************************
*  Start the main control loop
*/

    for(;;) {

	XNextEvent(&event);		  /* Get next event */
	(void) XtDispatchXEvent(&event);  /* Hand it to Toolkit Dispatcher */


       if(event.rep.window == sw){  /* scroll window */
        switch (event.rep.type){
	  case  ButtonPressed:
	        time_is_on = NO;
		tmp = display->ele;
		while(tmp != 0){
		  if(tmp->type == VIDEO_TYPE && tmp->state == PLAYING){
		    	sprintf(cmd,"still");
#if PLX
			sony_cmd( disc, cmd );
#else
			printf("In ButtonPress: %s\n",cmd);
#endif
			tmp->state = PAUSE;
		      }
		  tmp=tmp->next;
		}
		time = (event.buttpress.x * display->duration)/TIMECTRL_WIDTH;
		update_display(display);
		break;

	  case  ButtonReleased:
		time_is_on = YES;
		tmp = display->ele;
		while(tmp != 0){
		  if(tmp->type == VIDEO_TYPE && tmp->state == PAUSE){
		        tmp->state = PLAYING;
		    	sprintf(cmd,"fplay");
#if PLX
			sony_cmd( disc, cmd );
			XStartVideo(v1,VIDBACK,0,0,PRIO_2);
#else
			printf("In ButtonRelease: %s\n",cmd);
#endif
		  }
		  tmp = tmp->next;
		}
		break;
	  case  MouseMoved:
		if(! time_is_on){ /* means adjustment under way*/
		  time=(event.mousemove.x * display->duration)/TIMECTRL_WIDTH;
		  update_display(display);

		}
		break;

		
		


	      }
      }
      }
  }
/******************  END MAIN */




/**********************************************************************
*  Timer interrupt routine
*/
int 
timer()
{
  static int count;

  if(time_is_on && ++count > rate){
    count = 0;

    time += timeinc;
    update_display(display);
 
  }

}



/*******************************************************************
*  Update Display
*/
void
update_display(dsp)
  Disp *dsp;
 {
  Dsp_ele *ele, *tmpele;
  struct map *tmp; 
  int frm, framecount;
  float ft;
  char msg[30];
  static int count;

  ele = dsp->ele;
  tmp = dsp->ele->map;



  sprintf(msg,"Time %-5d  ",time);
  XText(windowid,540,510,msg,strlen(msg),f,BlackPixel,WhitePixel);
  XFlush();

  XtSetScrollBarPercentages(sw, (float) time / (float) display->duration 
			    * 100.0,0);


/*** Temporary exit condition */

  if (time >= display->duration){
     switch(ele->geom){
     case LINE:
       time_is_on = NO;
       tmpele = ele;
       while(tmpele != 0){
	 if(tmpele->type == VIDEO_TYPE && tmpele->state == PLAYING){
	   tmpele->state = STOPPED;
	 }
       }
       break;

     case LOOP:
       time = 0;
       tmpele = ele;
       while(tmpele != 0){
	 if(tmpele->type == VIDEO_TYPE && tmpele->state == PLAYING){
	   tmpele->state = STOPPED;
	 }
	 tmpele = tmpele->next;
       }
       break;
     case BOUNCE:
       break;
     }
   }



  while(ele != 0){

    switch (ele->type){
    case TEXT_TYPE:

      while((tmp->next != 0) && (tmp->time > time)){
	tmp = tmp->next;
      }

      if(tmp != ele->now_showing && tmp->time <= time){
	show(tmp,ele->w);
        ele->now_showing = tmp;
      }
      break;


    case VIDEO_TYPE:

      if(ele->state != PLAYING){  /* let play sequences go */

	framecount = ele->map->out - ele->map->in;
	frm = (((ft = time)/framecount) * framecount) + ele->map->in;
	if(frm != ele->current_frame){
	  ele->current_frame = frm;
	  sprintf(cmd,"search %d",frm);
#if PLX
	  sony_cmd( disc, cmd );
	  SETTLE; SETTLE; SETTLE; SETTLE; SETTLE; SETTLE;
	  XStillVideo(v1,0,0,0,0,640,482);
	  XFlush();

	  SETTLE; SETTLE;
#else
	  printf("1st in Update: %s\n",cmd);	  
#endif

	}
      

	if(time_is_on && ele->map->time < time){ /* then get the video going */
	  sprintf(cmd,"fplay");
#if PLX
	  sony_cmd( disc, cmd );
	  SETTLE; SETTLE;
	  XStartVideo(v1,VIDBACK0,0,PRIO_2);
	  XFlush();
#else
	  printf("2nd in update: %s\n",cmd);
#endif
 	  ele->state = PLAYING;
	}
      }      

      break;

    case DISP_TYPE:

      break;

    }
  ele = ele->next;
  tmp = ele->map;
  }
}


/*******************************************************************
*  Show text fragment
*/
void
show(tmp,w)
  struct map *tmp;
  Window w;
{
  char msg[256];


  if( fseek(fp,tmp->in,0) ) printf("FSEEK err to %d\n",tmp->in);
  if( fgets(msg, 255, fp) == NULL ) printf("NULL fgets\n");;
  len = strlen(msg);
  XClear(w);
  XText(w,
	5,5,msg,len,f,BlackPixel,WhitePixel);
  XFlush();

}


count(n)
	int n;
{
int i;
for( i=0; i<n; i++ );
}
