/* 
 * scr.c - modifies demo1; adds a scroll bar
 *
 * Make executable with:
 *	cc -o demo1 demo1.c -lXt -lX
 */

#include <X/Xlib.h>
#include "Toolkit.h"
#include <stdio.h>
#include <signal.h>
#include <sys/time.h>

#define TIMELIMIT 60
#define YES 1
#define NO 0
#define MAXMARKS 50

#define addbutton(w)\
    buttons[buttoncount].name = XtAWindow;\
    buttons[buttoncount].value = (caddr_t)w;\
    buttoncount++;

#define BORDERWIDTH 1


/***************
*  Windows needed
*/
Window windowid;  /* main display window */
Window   sw, rate_scr;  /*scroll windows */
Window timewindow;  /* time display */
Window butbox;  /* button box window */
Window fwd, rev, stp, mrk;  /* command button windows */
Window dw; /* filename dialog */
Window subtitles; 



/************************
*  Event data
*
*	This union is needed to get at the details of an event.  
*	The fact that the Xevent structure and the particular
*	event description structures occupy the same memory is
*	not described in the Xlib documentation.  The detail fields
*	of an event are accessed through this union as   
*			event.keypress.detail  
*	etc.   One other point; the input calls, XNextEvent, etc. need
*	a pointer, therefore the address of the union is passed.
*/
union evnt { XEvent                rep;
	     XKeyPressedEvent      keypress;
	     XButtonPressedEvent   buttpress;
	     XButtonReleasedEvent  buttrelease;
	     XEnterWindowEvent	   enterwin;
	     XLeaveWindowEvent	   exitwin;
	     XMouseMovedEvent      mousemove;
          } event;



/***************
*  General global vars.
*/
XEvent rp, *rep = &rp; /* global event */
Font f;
int len;
char *msg[30];
int time;
int timeinc = 1;
int time_is_on = NO;
int count_marks;
int mark[MAXMARKS];
int rate;
int timer();
int tries = 0;
int time;

FILE *fp;


/**************
* Functions
*/
char *calloc();
void show();
void update_display();


/***************
*  Timer structs
*/
struct itimerval timvl;
struct itimerval *timval = &timvl;
struct itimerval timovl, *timoval = &timovl;
int timetype;


/************* 
*  Text struct 
*/
struct txt{    struct txt *next;
	       struct txt *prev;
	       int time;
	       long in;
	       long out;
	     } txta, *text = &txta;



/***************************************************
*   Filename Dialog stuff 
*/
DialogButton dbuttons;
static char bname[] = "OK";

DialogValue dvalue;

static char label[] = "Enter filename:";

static char instring[80];

static Arg dialogArgs[] = {
    {XtADialogValue, (caddr_t) &dvalue},
    {XtADialogButtons, (caddr_t) &dbuttons},
    {NULL, NULL}	/* needed to terminate argument list */
};

/****************
*  Dialog button 
*/
static int FilenameAction()
{
    char s[256];
    int n = -1;
    struct txt *tmp;
    int lastout = 0;
    int unit;

    printf("Filename: %s\n",dvalue.string);

    if((fp = fopen(dvalue.string, "r")) == NULL){
      printf("Problem opening %s\n",dvalue.string);
      exit(1);
    }


    text->next = 0;
    text->prev = 0;
    text->time = n++;
    text->in = ftell(fp);
    if(fgets(s,256,fp) == NULL){
      printf("Failed on first string\n");
      exit(1);
    }
    text->out = ftell(fp);
    lastout = text->out;
    
    while ( fgets(s,256,fp) != NULL){ /* End of file or error */
      tmp = (struct txt *) calloc(1, sizeof(struct txt));
      tmp->time = ++n;
      tmp->in = lastout;
      tmp->out = ftell(fp);
      lastout = tmp->out;
      text->prev = tmp;
      tmp->next = text;
      text = tmp;
    }

unit = (TIMELIMIT/n);

    tmp = text;
    while(tmp->next != 0){
      tmp->time = tmp->time * unit;
      tmp = tmp->next;
    }


    printf("Mapped %d items from %s\n",n,dvalue.string);

    XtDestroyDialog(dw);

    

}







/***************************************************
*  Control button procedures  (Fwd, Rev, Stop, Mark)
*/
static void Forward()
{
if(! time_is_on){  
  time_is_on = YES; 
 }

timeinc = 1;
}

/*****************
*  Reverse
*/
static void Reverse()
{
if(! time_is_on){
  time_is_on = YES;
 }

timeinc = -1;
}



/*****************
*  Stop
*/
static void Stop()
{
time_is_on = NO;
}



/******************
*   Mark
*/
static void Mark()
{
if(++count_marks < MAXMARKS){
  mark[count_marks] = time;


 }
else printf("Marks array is full.\n");
}




/***********************
*  Command button labels
*/
static char mrk_label[] = "Mark";
static char fwd_label[] = "Forward";
static char rev_label[] = "Reverse";
static char stp_label[] = "Stop";




static Arg buttonArgs[] = {
    {XtALabel, (caddr_t) fwd_label},
    {XtAFunction, (caddr_t) Forward},
    {XtABorderWidth, (caddr_t) BORDERWIDTH},
    {NULL, NULL}	/* needed to terminate argument list */
};

static Arg bbarglist[] = {
    {XtABorderWidth, (caddr_t) BORDERWIDTH},
    {NULL, NULL}
};








/***********************************************************************
*  Scroll Window routines (time slide, time thmb, rate slide, rate thmb)
* 
*   Time bar -- buttons 1 and 3  routine
*/
static void Scr1(scrW, cliW, intpos)
  Window scrW;
  Window cliW;
  int intpos;
{
  printf("pos %d\n",intpos);
}



/****************
*  Time bar thumb (middle button)
*/
static void Thmb(scrW, cliW, tp, sp)
  Window scrW;
  Window cliW;
  float tp, sp;
{

  time = (tp/100)*TIMELIMIT;
  sprintf(msg,"Time %d   ",time);
  len = strlen(msg);

  XText(windowid,
	540,510,msg,len,f,BlackPixel,WhitePixel);
  XFlush();
  
}



/*********************
*  Rate bar thumb routine
*/
static void RateThmb(scrW, cliW, tp, sp)
  Window scrW;
  Window cliW;
  float tp, sp;
{
  tp = tp - 50;
  if (tp<0){
    timeinc = -1;
    rate = 51 + tp;
  }
  else{
    timeinc = 1;
    rate = 51 - tp;
  }
printf("%d\n",rate);
}  



/**************************
*  Scroll bar argument list
*/

static Arg scrargs[] = {
  {XtAOrientation, (caddr_t) XtAhorizontal},
  {XtAWidth, (caddr_t) 630},
  {XtAHeight, (caddr_t) 20},
  {XtABorderWidth, (caddr_t) BORDERWIDTH},
  {XtAScrollUpDownProc, (caddr_t) Scr1},
  {XtAThumbProc, (caddr_t) Thmb},
  {NULL, NULL}
};









/********************************************************
*  MAIN
*/

void main()
{
    Display  *d;


int count = 0;
int len;
char *msg[30];
Arg buttons[4];
int buttoncount;
float x;

/**************************
*  Set up the root window
*/
if(++tries == 1 && XOpenDisplay(0) == 0)
  { printf("Failed XOpenDisplay on %s\n",getenv("DISPLAY"));
    exit(1);
   }

if(tries == 1){
  windowid = XCreateWindow(RootWindow,
			 50,
			 50,
			 640,
			 550,
			 3,
			 BlackPixmap,
			 WhitePixmap);


  XMapWindow(windowid);

  if((f = XGetFont("timrom12b")) == 0)
    {  printf("Failed XGetFont timrom12b\n");
       exit(1);
     }


  XSelectInput(windowid, ButtonPressed 
	               | ButtonReleased 
	               | KeyPressed
	               | MouseMoved
	               | EnterWindow
	               | LeaveWindow);



/*******************************
*  Set up the subtitles window
*/
  subtitles =XCreateWindow(RootWindow,
			 50,  /* x */
			 650, /* y */
			 650, /* width */
			 50,  /* height */
			 3,   /* border width */
			 BlackPixmap,
			 WhitePixmap);


  XMapWindow(subtitles);


    XtInitToolkit();

/****************************
*  Display the command buttons
*/
    butbox = XtCreateButtonBox(windowid,bbarglist);

    buttonArgs[0].value = (caddr_t) fwd_label;
    buttonArgs[1].value = (caddr_t) Forward;
    fwd = XtCreateCommand(butbox, buttonArgs);
    XMapWindow(fwd);
    addbutton(fwd);

    buttonArgs[0].value = (caddr_t) stp_label;
    buttonArgs[1].value = (caddr_t) Stop;
    stp = XtCreateCommand(butbox, buttonArgs);
    XMapWindow(stp);
    addbutton(stp);

    buttonArgs[0].value = (caddr_t) rev_label;
    buttonArgs[1].value = (caddr_t) Reverse;
    rev = XtCreateCommand(butbox, buttonArgs);
    XMapWindow(rev);
    addbutton(rev);

    buttonArgs[0].value = (caddr_t) mrk_label;
    buttonArgs[1].value = (caddr_t) Mark;
    mrk = XtCreateCommand(butbox, buttonArgs);
    XMapWindow(mrk);
    addbutton(mrk);

    (void)XtButtonBoxAddButton(butbox,buttons);

    XMoveWindow(butbox, 5,510);
    XMapWindow(butbox);


/********************************
*  Put up the time scroll bar
*/
    sw = XtCreateScrollBar(windowid, scrargs);

    XMoveWindow(sw, 5, 485);
    XMapWindow(sw);

/*******************************
*  Put up the rate scroll bar
*/
    scrargs[1].value = (caddr_t)200;
    scrargs[5].value = (caddr_t)RateThmb;
    rate_scr = XtCreateScrollBar(windowid, scrargs);

    XMoveWindow(rate_scr, 300, 510);
    XMapWindow(rate_scr);

    XLine(rate_scr, 100,10,100,25,1,1,BlackPixel,GXcopy,AllPlanes);

/*******************************
*  Put up the filename dialog
*/
    dbuttons.name = bname;
    dbuttons.funct = FilenameAction;
    dbuttons.param = NULL;

    dvalue.tag = label;
    dvalue.string = instring;
    dvalue.length = 80;

    dw = XtCreateDialog(windowid, dialogArgs);

    XMoveWindow(dw, 100, 100);
    XMapWindow(dw);

/*******************************
*  Start up the clock
*/  
  timvl.it_value.tv_sec = 0;
  timvl.it_value.tv_usec = 33333; /* 30th of a second clock res. */
  timvl.it_interval.tv_sec = 0;
  timvl.it_interval.tv_usec = 33333;

  setitimer(timetype,timval,0);

  (*signal(SIGALRM,timer))();
}





/*******************************
*  Start the main control loop
*/

    for(;;) {

	XNextEvent(&event);		  /* Get next event */
	(void) XtDispatchXEvent(&event);  /* Hand it to Toolkit Dispatcher */


       if(event.rep.window == sw){  /* scroll window */
        switch (event.rep.type){
	  case  ButtonPressed:
	        time_is_on = NO;
		  x = event.buttpress.x;
		  time = ((x) / 630)*TIMELIMIT;
		  sprintf(msg,"Time %d   ",time);
		  len = strlen(msg);

		  XText(windowid,
		      540,510,msg,len,f,BlackPixel,WhitePixel);
		  XFlush();
		break;

	  case  ButtonReleased:
		time_is_on = YES;
		break;
	  case  MouseMoved:
		if(!time_is_on){ /* means adjustment under way*/
		  x = event.mousemove.x;
		  time = ((x) / 630)*TIMELIMIT;
		  sprintf(msg,"Time %d   ",time);
		  len = strlen(msg);
		  XText(windowid,
		      540,510,msg,len,f,BlackPixel,WhitePixel);
		  XFlush();

		update_display(time);

		}
		break;

	      }
      }


    }
}  
/******************  END MAIN */




/**********************************************************************
*  Timer interrupt routine
*/
int 
timer()
{

  char *msg[30];
  int len;
  float tp,sp;
  float fti;
  static int count;

if(time_is_on){  /* if time is off, don't do anything */
 if(++count > rate){
  count = 0;
  time = time + timeinc;
  if(time < 0) time = 0;
  if(time > TIMELIMIT) time = 0;


  sprintf(msg,"Time %d  ",time);
  len = strlen(msg);

  XText(windowid,
	540,510,msg,len,f,BlackPixel,WhitePixel);
  XFlush();

  tp = ((fti=time)/TIMELIMIT)*100;
  sp = 0; 
  XtSetScrollBarPercentages(sw,tp,sp);

  update_display(time);
 }
}

}



/*******************************************************************
*  Update Display
*/
void
update_display(time)
  int time;
{
  struct txt *tmp;
  static struct txt *now_showing = 0;


  tmp = text;  
  while((tmp->next != 0) && (tmp->time > time)){
    tmp = tmp->next;
  }

  if(tmp != now_showing){
    show(tmp);
    now_showing = tmp;
  }

}


/*******************************************************************
*  Show
*/
void
show(tmp)
  struct txt *tmp;
{
  char msg[256];


  if( fseek(fp,tmp->in,0) ) printf("FSEEK err\n");

  if( fgets(msg, 255, fp) == NULL ) printf("NULL fgets\n");;
  len = strlen(msg);
  XClear(subtitles);
  XText(subtitles,
	5,5,msg,len,f,BlackPixel,WhitePixel);
  XFlush();

}


