/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.acl;

import org.w3c.jigsaw.acl.AclPrincipal;
import org.w3c.jigsaw.acl.HTTPPrincipal;
import org.w3c.jigsaw.acl.InvalidAuthException;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.codec.Base64Decoder;
import org.w3c.tools.codec.Base64FormatException;
import org.w3c.www.http.HttpCredential;

public class BasicAuthPrincipal
extends HTTPPrincipal {
    protected String origname = null;
    protected String name = null;
    protected String password = null;
    protected String cookie = null;

    public BasicAuthPrincipal(Request request) throws InvalidAuthException {
        this(request, false);
    }

    public BasicAuthPrincipal(Request request, boolean bl) throws InvalidAuthException {
        super(request, bl);
        HttpCredential httpCredential = null;
        HttpCredential httpCredential2 = httpCredential = request.isProxy() ? request.getProxyAuthorization() : request.getAuthorization();
        if (httpCredential == null) {
            this.name = null;
            this.password = null;
        } else {
            if (!httpCredential.getScheme().equalsIgnoreCase("Basic")) {
                String string = "Invalid authentication scheme \"" + httpCredential.getScheme() + " expecting \"Basic\"";
                throw new InvalidAuthException(string);
            }
            String string = null;
            this.cookie = httpCredential.getAuthParameter("cookie");
            try {
                Base64Decoder base64Decoder = new Base64Decoder(this.cookie);
                string = base64Decoder.processString();
            }
            catch (Base64FormatException base64FormatException) {
                String string2 = "Invalid BASE64 encoding of credentials.";
                throw new InvalidAuthException(string2);
            }
            this.origname = null;
            int n = string.indexOf(58);
            if (n > 0 && n + 1 < string.length()) {
                if (bl) {
                    String string3 = string.substring(0, n);
                    int n2 = string3.lastIndexOf(92);
                    if (n2 != -1) {
                        this.origname = string3;
                        this.name = string3.substring(n2 + 1);
                    } else {
                        this.name = string3;
                    }
                } else {
                    this.name = string.substring(0, n);
                }
                this.password = string.substring(n + 1);
            } else {
                String string4 = "Invalid credentials syntax in " + string;
                throw new InvalidAuthException(string4);
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AclPrincipal) {
            AclPrincipal aclPrincipal = (AclPrincipal)object;
            if (aclPrincipal.matchIP(this.getInetAddress())) {
                if (aclPrincipal.getPassword() != null) {
                    return this.name != null && this.password != null && this.name.equals(aclPrincipal.getName()) && this.password.equals(aclPrincipal.getPassword());
                }
                return true;
            }
            return this.name != null && this.password != null && this.name.equals(aclPrincipal.getName()) && this.password.equals(aclPrincipal.getPassword());
        }
        return this.toString().equals(object.toString());
    }

    protected String getCookie() {
        return this.cookie;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.origname == null ? this.name : this.origname;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return String.valueOf(this.name) + ":" + this.password;
    }
}

