/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedInputStream;
import java.net.InetAddress;
import java.net.URL;
import org.w3c.jigsaw.http.ClientException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.RequestTimeout;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.timers.EventHandler;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeParserException;
import org.w3c.www.mime.MimeParserFactory;

public abstract class Client
implements EventHandler {
    private static final boolean debuglog = false;
    private static final byte[] hexaTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private Reply contreply = null;
    private MimeParserFactory factory = null;
    protected int identifier = -1;
    protected httpd server = null;
    protected boolean debug = false;
    protected byte[] buffer = null;
    private boolean running = false;
    private short major = (short)-1;
    private short minor = (short)-1;
    private InputStream input = null;
    private DataOutputStream output = null;
    private Object timer = null;
    private MimeParser parser = null;
    private boolean interrupted = false;
    protected int reqcount = 0;
    protected boolean cont = false;
    protected long prev_body_count = 0L;
    private boolean lenient = true;
    public URL currentURI = null;
    private boolean timedout;

    protected int chunkTransfer(InputStream inputStream, Reply reply) throws IOException {
        byte[] byArray = new byte[]{48, 13, 10};
        byte[] byArray2 = new byte[]{13, 10};
        byte[] byArray3 = new byte[32];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Object var10_9 = null;
        while (true) {
            try {
                if (n3 < 0) break;
                if (n3 == 0) {
                    try {
                        n3 = inputStream.read(this.buffer);
                        continue;
                    }
                    catch (IOException iOException) {
                        if (reply.hasState("org.w3c.jigsaw.servlet.runner") && inputStream instanceof PipedInputStream && !reply.hasState("org.w3c.jigsaw.servlet.ended")) {
                            n3 = 0;
                            continue;
                        }
                        throw iOException;
                    }
                }
                int n4 = n3;
                n = 3;
                byArray3[30] = 13;
                byArray3[31] = 10;
                while (n4 > 15) {
                    byArray3[32 - n] = hexaTable[n4 % 16];
                    n4 >>= 4;
                    ++n;
                }
                byArray3[32 - n] = hexaTable[n4];
                this.output.write(byArray3, 32 - n, n);
                this.output.write(this.buffer, 0, n3);
                this.output.write(byArray2, 0, 2);
                this.output.flush();
                n2 += n + n3;
                try {
                    n3 = inputStream.read(this.buffer);
                    continue;
                }
                catch (IOException iOException) {
                    if (reply.hasState("org.w3c.jigsaw.servlet.runner") && inputStream instanceof PipedInputStream && !reply.hasState("org.w3c.jigsaw.servlet.ended")) {
                        n3 = 0;
                        continue;
                    }
                    throw iOException;
                }
            }
            catch (IOException iOException) {
                if (!this.debug) break;
                iOException.printStackTrace();
            }
            break;
        }
        this.output.write(byArray, 0, 3);
        this.output.write(byArray2, 0, 2);
        this.output.flush();
        return n2 + n;
    }

    protected int emitReply(Reply reply) throws IOException {
        int n;
        InputStream inputStream;
        block13: {
            boolean bl = false;
            if (reply.getStatus() == 1001) {
                return -1;
            }
            inputStream = reply.openStream();
            if (inputStream == null) {
                if (this.debug) {
                    reply.dump(System.out);
                }
                reply.emit(this.output);
                return -1;
            }
            bl = reply.canChunkTransfer();
            if (this.debug) {
                reply.dump(System.out);
            }
            if (reply.getStatus() != 1000) {
                reply.emit(this.output);
            }
            if (this.buffer == null) {
                this.buffer = new byte[this.getServer().getClientBufferSize()];
            }
            n = 0;
            try {
                if (bl) {
                    n = this.chunkTransfer(inputStream, reply);
                    break block13;
                }
                int n2 = 0;
                while (n2 >= 0) {
                    this.output.write(this.buffer, 0, n2);
                    n += n2;
                    try {
                        n2 = inputStream.read(this.buffer, 0, this.buffer.length);
                    }
                    catch (IOException iOException) {
                        if (reply.hasState("org.w3c.jigsaw.servlet.runner") && inputStream instanceof PipedInputStream && !reply.hasState("org.w3c.jigsaw.servlet.ended")) {
                            n2 = 0;
                            continue;
                        }
                        throw iOException;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                inputStream.close();
                throw throwable;
            }
        }
        Object var6_7 = null;
        inputStream.close();
        return n;
    }

    public final void error(String string) {
        this.server.errlog(this, string);
    }

    public final int getIdentifier() {
        return this.identifier;
    }

    public abstract InetAddress getInetAddress();

    public InputStream getInputStream() {
        return this.input;
    }

    public final short getMajorVersion() {
        return this.major;
    }

    public final short getMinorVersion() {
        return this.minor;
    }

    protected Request getNextRequest() throws ClientException, IOException {
        Request request = null;
        this.cont = false;
        this.timedout = false;
        try {
            request = (Request)this.parser.parse(this.lenient);
        }
        catch (InterruptedIOException interruptedIOException) {
            this.timedout = true;
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (HttpParserException httpParserException) {
            if (this.debug) {
                System.out.println("+++ " + this + " got exception:");
                httpParserException.printStackTrace();
            }
            throw new ClientException(this, httpParserException);
        }
        catch (MimeParserException mimeParserException) {
            if (this.debug) {
                System.out.println("+++ " + this + " got exception:");
                mimeParserException.printStackTrace();
            }
            throw new ClientException(this, mimeParserException);
        }
        if (this.debug) {
            request.dump(System.out);
        }
        return request;
    }

    public DataOutputStream getOutputStream() {
        return this.output;
    }

    public final int getRequestCount() {
        return this.reqcount;
    }

    public final httpd getServer() {
        return this.server;
    }

    protected abstract Thread getThread();

    public synchronized void handleTimerEvent(Object object, long l) {
        this.timer = null;
        Reply reply = new Reply(this);
        reply.setStatus(408);
        this.interruptConnection(true);
    }

    protected abstract boolean idleConnection();

    protected void initialize(httpd httpd2, int n) {
        this.server = httpd2;
        this.lenient = httpd2.isLenient();
        this.identifier = n;
        this.debug = httpd2.getClientDebug();
        this.factory = httpd2.getMimeClientFactory(this);
    }

    protected synchronized void interruptConnection(boolean bl) {
        if (this.running) {
            this.interrupted = true;
            if (bl) {
                this.terminate();
            }
        }
    }

    public final boolean isInterrupted() {
        return this.interrupted;
    }

    public final synchronized boolean isRunning() {
        return this.running;
    }

    public void log(Request request, Reply reply, int n, long l) {
        this.server.log(this, request, reply, n, l);
    }

    protected Reply processRequest(Request request) throws ClientException {
        Reply reply = null;
        this.setTimeout(this.server.getRequestTimeOut(), new RequestTimeout(this));
        try {
            reply = (Reply)this.server.perform(request);
        }
        catch (ProtocolException protocolException) {
            if (this.debug) {
                System.out.println("+++ " + this + " got exception:");
                protocolException.printStackTrace();
            }
            if (reply != null && reply.hasStream()) {
                try {
                    reply.openStream().close();
                }
                catch (Exception exception) {}
            }
            if (protocolException.hasReply()) {
                return (Reply)protocolException.getReply();
            }
            throw new ClientException(this, protocolException);
        }
        catch (ResourceException resourceException) {
            throw new ClientException(this, resourceException);
        }
        if (reply == null) {
            String string = "target resource emited a null Reply.";
            throw new ClientException(this, string);
        }
        ++this.reqcount;
        return reply;
    }

    private synchronized void removeTimeout() {
        if (this.timer != null) {
            this.server.timer.recallTimer(this.timer);
        }
    }

    public int sendContinue() throws IOException {
        if (this.cont) {
            return -1;
        }
        if (this.major > 1 || this.major == 1 && this.minor >= 1) {
            if (this.contreply == null) {
                this.contreply = new Reply(this, null, this.major, this.minor, 100);
            }
            int n = this.emitReply(this.contreply);
            this.output.flush();
            this.cont = true;
            return n;
        }
        return -1;
    }

    public int sendContinue(Reply reply) throws IOException {
        if (reply == null) {
            return this.sendContinue();
        }
        if (this.major > 1 || this.major == 1 && this.minor >= 1) {
            int n = this.emitReply(reply);
            this.output.flush();
            this.cont = true;
            return n;
        }
        return -1;
    }

    private synchronized void setTimeout(int n, Object object) {
        if (this.timer != null) {
            this.server.timer.recallTimer(this.timer);
            this.timer = null;
        }
        this.timer = this.server.timer.registerTimer(n, this, object);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean startConnection(InputStream var1_1, DataOutputStream var2_2) throws ClientException {
        block71: {
            block69: {
                var3_3 = true;
                var4_4 = 0L;
                var6_5 = 0L;
                var8_6 = null;
                var9_7 = null;
                var10_8 = 0;
                var11_9 = 0;
                var12_10 = null;
                this.input = var1_1;
                this.output = var2_2;
                this.parser = new MimeParser(this.input, this.factory);
                try {
                    block64: {
                        try {
                            this.running = true;
                            while (!this.interrupted && var3_3) {
                                block65: {
                                    try {
                                        if (this.prev_body_count > 0L) {
                                            this.input.mark(2048);
                                        }
                                        if (var11_9 == 0) {
                                            var8_6 = this.getNextRequest();
                                            if (var8_6 == null) break block64;
                                            this.major = var8_6.getMajorVersion();
                                            this.minor = var8_6.getMinorVersion();
                                            break block65;
                                        }
                                        this.interrupted = this.idleConnection();
                                        if (!this.interrupted) ** GOTO lbl-1000
                                        break;
                                        while (this.timedout) lbl-1000:
                                        // 2 sources

                                        {
                                            if ((var8_6 = this.getNextRequest()) == null) continue;
                                            this.major = var8_6.getMajorVersion();
                                            this.minor = var8_6.getMinorVersion();
                                            this.usedConnection();
                                            break block65;
                                        }
                                        break;
                                    }
                                    catch (ClientException var15_12) {
                                        if (var15_12.ex != null && var15_12.ex instanceof HttpParserException) {
                                            var16_19 = (HttpParserException)var15_12.ex;
                                            if (!var16_19.hasRequest()) {
                                                throw var15_12;
                                            }
                                            var8_6 = (Request)var16_19.getRequest();
                                            if (var11_9 == 0) {
                                                this.major = var8_6.getMajorVersion();
                                                this.minor = var8_6.getMinorVersion();
                                            }
                                            this.usedConnection();
                                            var9_7 = (Reply)var8_6.makeBadRequestReply();
                                            var9_7.setContentLength(0);
                                            var9_7.addConnection("close");
                                            var3_3 = false;
                                            var10_8 = this.emitReply(var9_7);
                                            this.log((Request)var8_6, var9_7, 0, 0L);
                                            ++var11_9;
                                            ++this.reqcount;
                                            break;
                                        }
                                        if (var15_12.ex != null && var15_12.ex instanceof MimeParserException) {
                                            var9_7 = new Reply(this);
                                            var9_7.setStatus(400);
                                            var9_7.setContentLength(0);
                                            var9_7.addConnection("close");
                                            var3_3 = false;
                                            var10_8 = this.emitReply(var9_7);
                                            this.log((Request)var8_6, var9_7, 0, 0L);
                                            ++var11_9;
                                            ++this.reqcount;
                                            break;
                                        }
                                        throw var15_12;
                                    }
                                    catch (Exception var15_13) {
                                        if (this.debug) {
                                            var15_13.printStackTrace();
                                        }
                                        if (var15_13.getMessage().startsWith("Bad request") && this.prev_body_count > 0L) {
                                            this.usedConnection();
                                            if (this.debug) {
                                                System.out.println("Error after a body request! (Skipping: " + this.prev_body_count + " bytes)");
                                            }
                                            this.input.reset();
                                            var16_19 = new byte[(int)this.prev_body_count];
                                            this.prev_body_count -= (long)this.input.read((byte[])var16_19);
                                            this.prev_body_count -= this.input.skip(this.prev_body_count);
                                            break;
                                        }
                                        throw var15_13;
                                    }
                                }
                                this.currentURI = var8_6.getURL();
                                var4_4 = System.currentTimeMillis();
                                var9_7 = this.processRequest((Request)var8_6);
                                var6_5 = System.currentTimeMillis();
                                this.currentURI = null;
                                if (var3_3) {
                                    var3_3 = this.tryKeepConnection((Request)var8_6, var9_7);
                                }
                                var10_8 = this.emitReply(var9_7);
                                if (var9_7.hasContentLength() && var10_8 >= 0 && var9_7.getContentLength() != var10_8) {
                                    var3_3 = false;
                                }
                                this.prev_body_count = var8_6.getContentLength();
                                this.log((Request)var8_6, var9_7, var10_8, var6_5 - var4_4);
                                ++var11_9;
                                if (var3_3) {
                                    this.output.flush();
                                }
                                if (var9_7.getStatus() == 101) {
                                    this.input = null;
                                    this.output = null;
                                    throw new Exception("Switching");
                                }
                                if (!var8_6.hasState("org.w3c.jigsaw.servlet.stream")) continue;
                                try {
                                    var15_11 = (PipedInputStream)var8_6.getState("org.w3c.jigsaw.servlet.stream");
                                    var15_11.close();
                                }
                                catch (ClassCastException v0) {
                                }
                                catch (IOException v1) {}
                            }
                        }
                        catch (IOException var15_14) {
                            if (this.debug) {
                                System.out.println("+++ " + this + " got IOException:");
                                var15_14.printStackTrace();
                            }
                            try {
                                var16_19 = null;
                                if (var9_7 != null && (var16_19 = var9_7.openStream()) != null) {
                                    var16_19.close();
                                }
                            }
                            catch (IOException v2) {}
                            var12_10 = new ClientException(this, var15_14);
                        }
                        catch (ClientException var15_15) {
                            if (this.debug) {
                                System.out.println("+++ " + this + " got ClientException:");
                                var15_15.printStackTrace();
                            }
                            try {
                                var16_19 = null;
                                if (var9_7 != null && (var16_19 = var9_7.openStream()) != null) {
                                    var16_19.close();
                                }
                            }
                            catch (IOException v3) {}
                            var12_10 = var15_15;
                        }
                        catch (NullPointerException var15_16) {
                            if (this.debug) {
                                System.out.println("+++ " + this + " got exception:");
                                var15_16.printStackTrace();
                            }
                            var12_10 = this.currentURI != null ? new ClientException(this, var15_16, this.currentURI.toString()) : new ClientException(this, var15_16);
                        }
                        catch (Exception var15_17) {
                            if (this.debug) {
                                System.out.println("+++ " + this + " got exception:");
                                var15_17.printStackTrace();
                            }
                            var12_10 = new ClientException(this, var15_17);
                        }
                    }
                    var14_20 = null;
                    this.currentURI = null;
                }
                catch (Throwable var13_22) {
                    var14_21 = null;
                    this.currentURI = null;
                    if (var12_10 != null || var8_6 == null || var8_6.getContentLength() <= 0 || var9_7 == null || var9_7.getStatus() == 101 || var9_7.getStatus() / 100 == 2) break block69;
                    try {
                        var15_18 = var8_6.getInputStream();
                        if (var15_18 != null) {
                            while (var15_18.available() > 0) {
                                var15_18.read(this.buffer, 0, this.buffer.length);
                            }
                        }
                    }
                    catch (Exception v9) {}
                }
                if (var12_10 == null && var8_6 != null && var8_6.getContentLength() > 0 && var9_7 != null && var9_7.getStatus() != 101 && var9_7.getStatus() / 100 != 2) {
                    try {
                        var15_11 = var8_6.getInputStream();
                        if (var15_11 != null) {
                            while (var15_11.available() > 0) {
                                var15_11.read(this.buffer, 0, this.buffer.length);
                            }
                        }
                    }
                    catch (Exception v4) {}
                }
                if (var8_6 != null && var8_6.hasState("org.w3c.jigsaw.servlet.stream")) {
                    try {
                        var15_11 = (PipedInputStream)var8_6.getState("org.w3c.jigsaw.servlet.stream");
                        var15_11.close();
                    }
                    catch (ClassCastException v5) {
                    }
                    catch (IOException v6) {
                    }
                    catch (Exception v7) {}
                }
                this.terminate();
                if (var9_7 == null || var9_7.getStatus() != 101) {
                    this.stopConnection();
                    if (var9_7 != null) {
                        try {
                            var9_7.openStream().close();
                        }
                        catch (Exception v8) {}
                    }
                }
                if (var12_10 != null) {
                    throw var12_10;
                }
                break block71;
            }
            if (var8_6 != null && var8_6.hasState("org.w3c.jigsaw.servlet.stream")) {
                try {
                    var15_18 = (PipedInputStream)var8_6.getState("org.w3c.jigsaw.servlet.stream");
                    var15_18.close();
                }
                catch (ClassCastException v10) {
                }
                catch (IOException v11) {
                }
                catch (Exception v12) {}
            }
            this.terminate();
            if (var9_7 == null || var9_7.getStatus() != 101) {
                this.stopConnection();
                if (var9_7 != null) {
                    try {
                        var9_7.openStream().close();
                    }
                    catch (Exception v13) {}
                }
            }
            if (var12_10 != null) {
                throw var12_10;
            }
            throw var13_22;
        }
        return this.interrupted;
    }

    protected abstract void stopConnection();

    private synchronized void terminate() {
        if (!this.running) {
            return;
        }
        this.removeTimeout();
        try {
            if (this.output != null) {
                this.output.flush();
                this.output.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (IOException iOException) {}
        this.input = null;
        this.output = null;
        this.parser = null;
        this.major = (short)-1;
        this.minor = (short)-1;
        this.interrupted = false;
        this.running = false;
    }

    public final void trace(String string) {
        this.server.trace(this, string);
    }

    protected boolean tryKeepConnection(Request request, Reply reply) {
        if (!this.server.getClientKeepConnection()) {
            return false;
        }
        if (!request.canKeepConnection()) {
            if (reply.tryKeepConnection()) {
                reply.addConnection("close");
            }
            return false;
        }
        return reply.tryKeepConnection();
    }

    protected abstract void usedConnection();
}

