/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.www.http.ChunkedInputStream;
import org.w3c.www.http.ContentLengthInputStream;
import org.w3c.www.http.HttpCredential;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.HttpRequestMessage;
import org.w3c.www.mime.MimeParser;

public class Request
extends HttpRequestMessage
implements RequestInterface {
    public static URL THE_SERVER = null;
    public static final String ORIG_URL_STATE = "org.w3c.jigsaw.http.Request.origurl";
    protected Client client = null;
    protected MimeParser parser = null;
    protected InputStream in = null;
    protected boolean keepcon = true;
    boolean is_proxy = false;
    private ResourceReference target_resource = null;
    protected boolean internal = false;
    protected Request original = null;
    protected ResourceFilter[] filters = null;
    protected int infilters = -1;

    static {
        try {
            THE_SERVER = new URL("http://your.url.unknown");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Request(Client client, MimeParser mimeParser) {
        super(mimeParser);
        this.parser = mimeParser;
        this.client = client;
    }

    public boolean canKeepConnection() {
        if (!this.keepcon || this.major < 1) {
            return false;
        }
        if (this.minor >= 1) {
            return !this.hasConnection("close");
        }
        if (this.is_proxy) {
            return this.hasProxyConnection("keep-alive");
        }
        return this.hasConnection("keep-alive");
    }

    public Client getClient() {
        return this.client;
    }

    public HttpMessage getClone() {
        Request request = (Request)super.getClone();
        request.internal = true;
        if (request.original == null) {
            request.original = this;
        }
        return request;
    }

    public InputStream getInputStream() throws IOException {
        String string;
        int n;
        if (this.in != null) {
            return this.in;
        }
        String[] stringArray = this.getTransferEncoding();
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("chunked")) {
                    this.in = new ChunkedInputStream(this.parser.getInputStream());
                }
                ++n;
            }
        }
        n = this.getContentLength();
        if (this.in == null && n >= 0) {
            this.in = new ContentLengthInputStream(this.parser.getInputStream(), n);
        }
        if (this.major == 1 && this.minor == 0 && this.in == null && ((string = this.getMethod()).equals("POST") || string.equals("PUT"))) {
            this.keepcon = false;
            this.in = this.parser.getInputStream();
        }
        return this.in;
    }

    public Request getOriginal() {
        return this.original == null ? this : this.original;
    }

    public String getQueryString() {
        return (String)this.getState("query");
    }

    public ResourceReference getTargetResource() {
        return this.target_resource;
    }

    public String getURLPath() {
        return this.url.getFile();
    }

    public boolean hasAccept() {
        return this.hasHeader(HttpRequestMessage.H_ACCEPT);
    }

    public boolean hasAcceptCharset() {
        return this.hasHeader(HttpRequestMessage.H_ACCEPT_CHARSET);
    }

    public boolean hasAcceptEncoding() {
        return this.hasHeader(HttpRequestMessage.H_ACCEPT_ENCODING);
    }

    public boolean hasAcceptLanguage() {
        return this.hasHeader(HttpRequestMessage.H_ACCEPT_LANGUAGE);
    }

    public boolean hasAuthorization() {
        return this.hasHeader(HttpRequestMessage.H_AUTHORIZATION);
    }

    public boolean hasContentLength() {
        return this.hasHeader(HttpEntityMessage.H_CONTENT_LENGTH);
    }

    public boolean hasContentType() {
        return this.hasHeader(HttpEntityMessage.H_CONTENT_TYPE);
    }

    public boolean hasProxyAuthorization() {
        return this.hasHeader(HttpRequestMessage.H_PROXY_AUTHORIZATION);
    }

    public boolean hasQueryString() {
        return this.hasState("query");
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isProxy() {
        return this.is_proxy;
    }

    public ReplyInterface makeBadRequestReply() {
        return this.makeReply(400);
    }

    public Reply makeReply(int n) {
        Reply reply = new Reply(this.client, this, this.getMajorVersion(), this.getMinorVersion(), n);
        if (this.filters != null && this.infilters > 0) {
            reply.setFilters(this.filters, this.infilters);
        }
        return reply;
    }

    public void notifyEndParsing(MimeParser mimeParser) throws HttpParserException, IOException {
        String string;
        super.notifyEndParsing(mimeParser);
        String string2 = this.getTarget();
        String string3 = null;
        if (string2.equals("*")) {
            this.setURL(THE_SERVER);
            return;
        }
        int n = -1;
        int n2 = string2.indexOf(58);
        String string4 = string = n2 != -1 ? string2.substring(0, n2) : null;
        if (string != null && (string.equals("http") || string.equals("ftp"))) {
            try {
                n = string2.indexOf(64, 6);
                if (n != -1) {
                    String string5 = string2.substring(n2 + 3, n);
                    int n3 = -1;
                    if (string5.indexOf(47) == -1 && (n3 = string5.indexOf(58)) != -1) {
                        if (!this.hasAuthorization()) {
                            String string6 = string5.substring(0, n3);
                            String string7 = string5.substring(n3 + 1);
                            HttpCredential httpCredential = HttpFactory.makeCredential("Basic");
                            Base64Encoder base64Encoder = new Base64Encoder(String.valueOf(string6) + ":" + string7);
                            httpCredential.setAuthParameter("cookie", base64Encoder.processString());
                            this.setAuthorization(httpCredential);
                        }
                        this.setURL(new URL(String.valueOf(string) + "://" + string2.substring(n + 1)));
                    }
                    this.setURL(new URL(string2));
                }
                this.setURL(new URL(string2));
            }
            catch (Exception exception) {
                throw new HttpParserException("Bogus URL [" + string3 + "]", this);
            }
        } else {
            try {
                String string8 = this.getHost();
                if (string8 == null) {
                    if (this.major == 1 && this.minor >= 1) {
                        throw new HttpParserException("No Host Header");
                    }
                    httpd httpd2 = this.getClient().getServer();
                    this.setURL(new URL("http", httpd2.getHost(), httpd2.getPort(), string2));
                } else {
                    int n4 = string8.indexOf(58);
                    if (n4 < 0) {
                        this.setURL(new URL("http", string8, string2));
                    } else {
                        this.setURL(new URL("http", string8.substring(0, n4), Integer.parseInt(string8.substring(n4 + 1)), string2));
                    }
                }
            }
            catch (Exception exception) {
                throw new HttpParserException("Bogus URL [" + string3 + "]", this);
            }
        }
    }

    protected void setFilters(ResourceFilter[] resourceFilterArray, int n) {
        this.filters = resourceFilterArray;
        this.infilters = n;
    }

    public void setInternal(boolean bl) {
        this.internal = bl;
    }

    public void setProxy(boolean bl) {
        this.is_proxy = bl;
    }

    public void setState(String string, String string2) {
        super.setState(string, string2);
    }

    public void setStream(InputStream inputStream) {
        if (inputStream != null) {
            this.in = inputStream;
        }
    }

    protected void setTargetResource(ResourceReference resourceReference) {
        this.target_resource = resourceReference;
    }

    public void setURLPath(String string) {
        try {
            this.url = new URL(this.url, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void skipBody() {
        if (this.getExpect() != null) {
            return;
        }
        try {
            InputStream inputStream = this.getInputStream();
            int n = inputStream.available();
            while (n > 0) {
                inputStream.skip(n);
                n = inputStream.available();
            }
        }
        catch (Exception exception) {}
    }

    public static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c;
            switch (c) {
                case '%': {
                    n2 = string.charAt(++n3);
                    int n4 = (Character.isDigit((char)n2) ? n2 - 48 : 10 + Character.toLowerCase((char)n2) - 97) & 0xF;
                    n2 = string.charAt(++n3);
                    int n5 = (Character.isDigit((char)n2) ? n2 - 48 : 10 + Character.toLowerCase((char)n2) - 97) & 0xF;
                    stringBuffer.append((char)(n4 << 4 | n5));
                    break;
                }
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    stringBuffer.append((char)n2);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }
}

