/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.w3c.jigsaw.servlet.JigsawServletContext;
import org.w3c.jigsaw.servlet.ServletClassEntry;

public class AutoReloadServletLoader
extends ClassLoader {
    private static final boolean debug = false;
    private Hashtable classes = null;
    private int CLASSES_DEFAULT_SIZE = 13;
    JigsawServletContext context = null;

    protected AutoReloadServletLoader(AutoReloadServletLoader autoReloadServletLoader) {
        this.context = autoReloadServletLoader.context;
        this.classes = autoReloadServletLoader.classes;
    }

    protected AutoReloadServletLoader(JigsawServletContext jigsawServletContext) {
        this.context = jigsawServletContext;
        this.classes = new Hashtable(this.CLASSES_DEFAULT_SIZE);
    }

    protected void checkPackageAccess(String string) {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            securityManager.checkPackageAccess(string.substring(0, n));
        }
    }

    protected boolean classChanged(String string) {
        ServletClassEntry servletClassEntry = (ServletClassEntry)this.classes.get(this.noext(string));
        if (servletClassEntry != null) {
            return servletClassEntry.isModified();
        }
        return false;
    }

    protected final Class getCachedClass(String string, boolean bl) throws ClassNotFoundException {
        ServletClassEntry servletClassEntry = (ServletClassEntry)this.classes.get(this.noext(string));
        if (servletClassEntry != null) {
            if (!servletClassEntry.isModified()) {
                this.trace(String.valueOf(string) + ": not modified", false);
                return servletClassEntry.servletClass;
            }
            if (!servletClassEntry.systemClass) {
                servletClassEntry.servletClass = this.loadClassFile(servletClassEntry.classFile);
                if (bl) {
                    this.resolveClass(servletClassEntry.servletClass);
                }
                servletClassEntry.update();
                this.trace(String.valueOf(string) + ": reloaded", false);
                return servletClassEntry.servletClass;
            }
        }
        return null;
    }

    protected final Class getNewClass(File file, String string, boolean bl) throws ClassNotFoundException {
        Class clazz = null;
        clazz = this.loadClassFile(file);
        if (bl) {
            this.resolveClass(clazz);
        }
        this.classes.put(this.noext(string), new ServletClassEntry(file, clazz));
        this.trace(String.valueOf(string) + ": loading new class done.", false);
        return clazz;
    }

    public URL getResource(String string) {
        File file;
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        String string2 = this.context.getServletDirectory().getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!(file = new File(string2, string)).exists()) {
            return null;
        }
        try {
            return new URL("file", "localhost", String.valueOf(string2) + "/" + string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        URL uRL = this.getResource(string);
        if (uRL == null) {
            return null;
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            return uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        this.trace(String.valueOf(string) + ": loading class", false);
        clazz = this.getCachedClass(string, bl);
        if (clazz != null) {
            return clazz;
        }
        AutoReloadServletLoader autoReloadServletLoader = this;
        synchronized (autoReloadServletLoader) {
            clazz = this.getCachedClass(string, bl);
            if (clazz != null) {
                return clazz;
            }
            this.checkPackageAccess(string);
            File file = this.locateClass(string);
            if (file != null) return this.getNewClass(file, string, bl);
            try {
                String string2 = this.noext(string);
                clazz = this.findSystemClass(string2);
                if (clazz == null) throw new ClassNotFoundException(string);
                this.trace(String.valueOf(string) + ": system class", false);
                this.classes.put(string2, new ServletClassEntry(clazz));
                return clazz;
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(string);
            }
        }
    }

    protected Class loadClassFile(File file) throws ClassNotFoundException {
        byte[] byArray = null;
        if (file == null) {
            throw new ClassNotFoundException("invalid servlet base");
        }
        this.trace("located at " + file, false);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            byte[] byArray2 = new byte[512];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(file.getAbsolutePath());
        }
        return this.defineClass(null, byArray, 0, byArray.length);
    }

    protected File locateClass(String string) {
        File file = null;
        File file2 = this.context.getServletDirectory();
        String string2 = null;
        string2 = this.packaged(string);
        file = new File(file2, string2);
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    private String noext(String string) {
        int n = string.lastIndexOf(".class");
        if (n != -1 && (n + 6 == string.length() || Character.isWhitespace(string.charAt(n + 6)))) {
            return string.substring(0, n);
        }
        return string;
    }

    private String packaged(String string) {
        String string2 = this.removeSpace(string);
        try {
            int n;
            if (string2.endsWith(".class") && (n = string2.lastIndexOf(46)) != -1) {
                string2 = string2.substring(0, n);
            }
            return String.valueOf(string2.replace('.', '/')) + ".class";
        }
        catch (Exception exception) {
            return string;
        }
    }

    private String removeSpace(String string) {
        int n = -1;
        int n2 = string.length();
        boolean bl = false;
        while (string.charAt(++n) == ' ') {
            bl = true;
        }
        while (string.charAt(--n2) == ' ') {
            bl = true;
        }
        if (bl) {
            return string.substring(n, ++n2);
        }
        return new String(string);
    }

    private void trace(String string) {
        this.trace(string, true);
    }

    private void trace(String string, boolean bl) {
        if (bl) {
            System.out.println("[" + this.context.getServletDirectory() + "]: " + string);
        }
    }
}

