/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.log;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import org.w3c.tools.log.DNSEntry;
import org.w3c.util.ThreadCache;

public class DNSResolver {
    private BufferedReader bf;
    private Hashtable hosts;
    private Hashtable badHosts;
    private ThreadCache threadCache;
    private boolean timestamp;
    private boolean resolve;
    private int cacheSize;

    public DNSResolver(BufferedReader bufferedReader) {
        this(bufferedReader, 50, false, true);
    }

    public DNSResolver(BufferedReader bufferedReader, int n) {
        this(bufferedReader, n, false, true);
    }

    public DNSResolver(BufferedReader bufferedReader, int n, boolean bl, boolean bl2) {
        this.bf = bufferedReader;
        this.resolve = bl2;
        this.badHosts = new Hashtable(201);
        this.timestamp = bl;
        this.cacheSize = n;
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream("dns.oj");
                ObjectInputStream objectInputStream = null;
                try {
                    try {
                        objectInputStream = new ObjectInputStream(fileInputStream);
                        this.hosts = (Hashtable)objectInputStream.readObject();
                    }
                    catch (Exception exception) {
                        this.hosts = new Hashtable(1001);
                    }
                    Object var10_7 = null;
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    try {
                        objectInputStream.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                this.hosts = new Hashtable(1001);
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {}
        this.threadCache = new ThreadCache("resolver");
        this.threadCache.setThreadPriority(5);
        this.threadCache.setCachesize(n);
        this.threadCache.initialize();
    }

    public DNSResolver(BufferedReader bufferedReader, boolean bl, boolean bl2) {
        this(bufferedReader, 50, bl, bl2);
    }

    public void readLog() {
        Object var11_1 = null;
        Object var12_2 = null;
        try {
            Object object;
            String string;
            while ((string = this.bf.readLine()) != null) {
                boolean bl = false;
                if (string.length() < 40 || this.threadCache.getThread((Runnable)(object = new ResolverThread(string, this.timestamp)), true)) continue;
                System.err.println("*** unable to process :" + string);
            }
            this.threadCache.waitForCompletion();
            object = null;
            try {
                try {
                    object = new FileOutputStream("dns.oj");
                    ObjectOutputStream objectOutputStream = null;
                    try {
                        try {
                            objectOutputStream = new ObjectOutputStream((OutputStream)object);
                            objectOutputStream.writeObject(this.hosts);
                        }
                        catch (Exception exception) {
                        }
                        Object var21_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var21_8 = null;
                        try {
                            objectOutputStream.close();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        objectOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                }
                Object var18_10 = null;
            }
            catch (Throwable throwable) {
                Object var18_11 = null;
                try {
                    ((FileOutputStream)object).close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                ((FileOutputStream)object).close();
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {}
    }

    private class ResolverThread
    implements Runnable {
        String line;
        DateFormat dfp;

        ResolverThread(String string, boolean bl) {
            this.line = string;
            this.dfp = bl ? new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss z") : null;
        }

        public void run() {
            String string;
            block36: {
                boolean bl;
                String string2 = this.line.substring(0, this.line.indexOf(32));
                byte[] byArray = string2.getBytes();
                if (DNSResolver.this.resolve) {
                    bl = true;
                    int n = 0;
                    while (bl && n < byArray.length) {
                        if (byArray[n] != 46 && (byArray[n] < 48 || byArray[n] > 57)) {
                            bl = false;
                        }
                        ++n;
                    }
                } else {
                    bl = false;
                }
                if (!bl) {
                    block35: {
                        try {
                            if (this.dfp != null) {
                                String string3 = this.line.substring(this.line.indexOf(91) + 1, this.line.indexOf(93));
                                long l = 0L;
                                try {
                                    l = this.dfp.parse(string3).getTime();
                                }
                                catch (Exception exception) {}
                                PrintStream printStream = System.out;
                                synchronized (printStream) {
                                    System.out.println(String.valueOf(Long.toString(l)) + " " + this.line);
                                    break block35;
                                }
                            }
                            PrintStream printStream = System.out;
                            synchronized (printStream) {
                                System.out.println(this.line);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    return;
                }
                string = (String)DNSResolver.this.badHosts.get(string2);
                if (string == null) {
                    DNSEntry dNSEntry = (DNSEntry)DNSResolver.this.hosts.get(string2);
                    if (dNSEntry == null || !dNSEntry.isResolved()) {
                        try {
                            string = InetAddress.getByName(string2).getHostName();
                            if (string.equals(string2)) {
                                DNSResolver.this.badHosts.put(string2, string2);
                                if (dNSEntry != null) {
                                    dNSEntry.notFound();
                                } else {
                                    dNSEntry = new DNSEntry(string2, false);
                                    DNSResolver.this.hosts.put(string2, dNSEntry);
                                }
                                break block36;
                            }
                            if (dNSEntry != null) {
                                dNSEntry.setHost(string);
                                break block36;
                            }
                            dNSEntry = new DNSEntry(string);
                            DNSResolver.this.hosts.put(string2, dNSEntry);
                        }
                        catch (UnknownHostException unknownHostException) {
                            string = string2;
                            DNSResolver.this.badHosts.put(string2, string2);
                            if (dNSEntry != null) {
                                dNSEntry.notFound();
                                break block36;
                            }
                            dNSEntry = new DNSEntry(string2, false);
                            DNSResolver.this.hosts.put(string2, dNSEntry);
                        }
                    } else {
                        string = dNSEntry.host;
                    }
                }
            }
            String string4 = this.line.substring(this.line.indexOf(32));
            if (this.dfp != null) {
                String string5 = string4.substring(string4.indexOf(91) + 1, string4.indexOf(93));
                long l = 0L;
                try {
                    l = this.dfp.parse(string5).getTime();
                }
                catch (Exception exception) {}
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println(String.valueOf(Long.toString(l)) + " " + string + string4);
                }
            }
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println(String.valueOf(string) + string4);
            }
        }
    }
}

