/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.offline.browse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.tools.offline.browse.InvalidStoreException;
import org.w3c.tools.offline.browse.RepositoryFinder;
import org.w3c.tools.offline.browse.ResourceLister;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.serialization.Serializer;
import org.w3c.tools.resources.serialization.xml.XMLSerializer;

public class StoreFinder {
    public static final String ROOT_REP = "root.xml";
    public static final String INDEX_F = "index.xml";
    public String store_dir = null;
    public String server_name = null;
    protected ResourceLister rl = null;
    protected Serializer serializer = null;
    protected Hashtable index_table = new Hashtable();
    protected Hashtable finders = new Hashtable();
    private Stack cur_stack = new Stack();
    private Stack res_stack = new Stack();
    private Stack rep_stack = new Stack();
    private String working_rep = null;
    protected static Perl5Matcher pmatcher = new Perl5Matcher();
    protected static Perl5Compiler pcompiler = new Perl5Compiler();

    public StoreFinder(String string, String string2) {
        this.store_dir = string;
        this.server_name = string2;
        this.rl = new ResourceLister();
    }

    public void finderAction(String string, String string2, boolean bl) {
        if (this.working_rep.compareTo(ROOT_REP) == 0) {
            System.out.println(this.working_rep);
            this.tryAction(string, this.working_rep, string2, bl, 1);
        } else {
            RepositoryFinder repositoryFinder = (RepositoryFinder)this.rep_stack.peek();
            System.out.println(this.working_rep);
            this.tryAction(string, repositoryFinder.getRep(), string2, bl, 1);
        }
    }

    public String getWorkingRep() {
        return this.working_rep;
    }

    public void printWorkingRep() {
        System.out.println(this.working_rep);
    }

    public void readStoreIndex() throws IOException {
        this.serializer = new XMLSerializer();
        File file = new File(this.store_dir, String.valueOf(this.server_name) + "-" + INDEX_F);
        System.out.println("Reading index file...");
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            AttributeHolder[] attributeHolderArray = this.serializer.readAttributeHolders(bufferedReader);
            int n = 0;
            while (n < attributeHolderArray.length) {
                Integer n2 = this.rl.getKeyFromHolder(attributeHolderArray[n]);
                if (n2 != null) {
                    String string = this.rl.getRepositoryFromHolder(attributeHolderArray[n]);
                    this.index_table.put(n2, string);
                    if (!this.finders.containsKey(string)) {
                        RepositoryFinder repositoryFinder = new RepositoryFinder(this.store_dir, string);
                        this.finders.put(string, repositoryFinder);
                    }
                }
                ++n;
            }
        }
        catch (InvalidStoreException invalidStoreException) {
            System.out.println("Invalid store");
            throw new IOException();
        }
        catch (IOException iOException) {
            System.out.println("can't read index file");
            throw new IOException();
        }
    }

    public void readStoreRoot() throws IOException {
        this.serializer = new XMLSerializer();
        File file = new File(this.store_dir, ROOT_REP);
        this.working_rep = ROOT_REP;
        this.res_stack.push(ROOT_REP);
        RepositoryFinder repositoryFinder = (RepositoryFinder)this.finders.get(ROOT_REP);
        this.rep_stack.push(repositoryFinder);
        System.out.println("reading root file...\n");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        AttributeHolder[] attributeHolderArray = this.serializer.readAttributeHolders(bufferedReader);
        int n = 0;
        while (n < attributeHolderArray.length) {
            String string;
            System.out.println(this.rl.getIdentFromHolder(attributeHolderArray[n]));
            Integer n2 = this.rl.getKeyFromHolder(attributeHolderArray[n]);
            if (n2 != null && (string = (String)this.index_table.get(n2)).compareTo(ROOT_REP) != 0) {
                this.recursiveReadContainer(string, 1);
            }
            ++n;
        }
    }

    private void recursivePerformAction(String string, String string2, int n) {
        RepositoryFinder repositoryFinder = (RepositoryFinder)this.finders.get(string2);
        AttributeHolder[] attributeHolderArray = repositoryFinder.getAttributeHolders();
        int n2 = 0;
        while (n2 < attributeHolderArray.length) {
            String string3;
            this.rl.performAction(string, attributeHolderArray[n2], n);
            this.rl.performActionOnFrames(string, attributeHolderArray[n2], n);
            Integer n3 = this.rl.getKeyFromHolder(attributeHolderArray[n2]);
            if (n3 != null && (string3 = (String)this.index_table.get(n3)).compareTo(ROOT_REP) != 0) {
                this.recursivePerformAction(string, string3, n + 1);
            }
            ++n2;
        }
        repositoryFinder.writeHolders();
    }

    private void recursiveReadContainer(String string, int n) {
        RepositoryFinder repositoryFinder = (RepositoryFinder)this.finders.get(string);
        AttributeHolder[] attributeHolderArray = repositoryFinder.getAttributeHolders();
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = String.valueOf(string2) + "\t";
            ++n2;
        }
        int n3 = 0;
        while (n3 < attributeHolderArray.length) {
            System.out.println(String.valueOf(string2) + "|-" + this.rl.getIdentFromHolder(attributeHolderArray[n3]));
            Integer n4 = this.rl.getKeyFromHolder(attributeHolderArray[n3]);
            if (n4 != null) {
                if (this.index_table.containsKey(n4)) {
                    String string3 = (String)this.index_table.get(n4);
                    this.recursiveReadContainer(string3, n + 1);
                } else {
                    System.out.println("WARNING! " + this.rl.getIdentFromHolder(attributeHolderArray[n3]) + " is a container but its key " + n4 + " does not exist in store index");
                }
            }
            ++n3;
        }
    }

    public void setWorkingRep(String string) {
        if (string.compareTo("..") == 0) {
            this.res_stack.pop();
            this.rep_stack.pop();
            this.working_rep = (String)this.res_stack.peek();
        } else {
            try {
                RepositoryFinder repositoryFinder = (RepositoryFinder)this.rep_stack.peek();
                AttributeHolder[] attributeHolderArray = repositoryFinder.getAttributeHolders();
                int n = 0;
                while (n < attributeHolderArray.length) {
                    Integer n2 = this.rl.getKeyFromHolder(attributeHolderArray[n]);
                    if (this.rl.getIdentFromHolder(attributeHolderArray[n]).compareTo(string) == 0 && n2 != null) {
                        this.working_rep = string;
                        this.res_stack.push(this.rl.getIdentFromHolder(attributeHolderArray[n]));
                        String string2 = (String)this.index_table.get(n2);
                        this.rep_stack.push((RepositoryFinder)this.finders.get(string2));
                    }
                    ++n;
                }
                if (this.working_rep.compareTo(string) != 0) {
                    System.out.println("container not found or not a container");
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
        }
    }

    private void tryAction(String string, String string2, String string3, boolean bl, int n) {
        RepositoryFinder repositoryFinder = (RepositoryFinder)this.finders.get(string2);
        AttributeHolder[] attributeHolderArray = repositoryFinder.getAttributeHolders();
        Pattern pattern = null;
        boolean bl2 = false;
        try {
            pattern = pcompiler.compile("^" + string3 + "$", 0);
            int n2 = 0;
            while (n2 < attributeHolderArray.length) {
                String string4;
                Integer n3;
                this.cur_stack.push(this.rl.getIdentFromHolder(attributeHolderArray[n2]));
                if (pmatcher.matches(this.rl.getIdentFromHolder(attributeHolderArray[n2]), pattern)) {
                    this.rl.performAction(string, attributeHolderArray[n2], n);
                    this.rl.performActionOnFrames(string, attributeHolderArray[n2], n);
                    bl2 = true;
                    n3 = this.rl.getKeyFromHolder(attributeHolderArray[n2]);
                    if (n3 != null && bl && (string4 = (String)this.index_table.get(n3)).compareTo(ROOT_REP) != 0) {
                        this.recursivePerformAction(string, string4, n + 1);
                    }
                } else {
                    n3 = this.rl.getKeyFromHolder(attributeHolderArray[n2]);
                    if (n3 != null && bl && (string4 = (String)this.index_table.get(n3)).compareTo(ROOT_REP) != 0) {
                        this.tryAction(string, string4, string3, bl, n + 1);
                    }
                }
                this.cur_stack.pop();
                if (bl2) {
                    repositoryFinder.writeHolders();
                    bl2 = false;
                }
                ++n2;
            }
        }
        catch (MalformedPatternException malformedPatternException) {
            System.out.println("malformed expression " + string3);
        }
    }
}

