/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.indexer;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.ContainerInterface;
import org.w3c.tools.resources.ContainerResource;
import org.w3c.tools.resources.DummyResourceReference;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.resources.indexer.IndexerModule;
import org.w3c.tools.resources.indexer.ResourceIndexer;
import org.w3c.tools.resources.indexer.SampleIndexerEnumeration;
import org.w3c.tools.resources.indexer.TemplateContainer;

public class SampleResourceIndexer
extends Resource
implements ContainerInterface,
ResourceIndexer {
    private static final boolean debug = false;
    protected static final boolean extCaseSensitive = false;
    protected static final String defname = "*default*";
    private static final String[] harmfulNames = new String[]{"aux".intern(), "con".intern()};
    public static boolean isWinPlatform = File.pathSeparatorChar == ';';
    protected static int ATTR_SUPER_INDEXER = -1;
    protected static int ATTR_NOT_INDEXED = -1;
    protected ResourceReference directories = null;
    protected ResourceReference extensions = null;
    protected ResourceReference contentTypes = null;
    private static final String[] noextension;
    static /* synthetic */ Class class$org$w3c$tools$resources$indexer$SampleResourceIndexer;

    static {
        Attribute attribute = null;
        Class clazz = class$org$w3c$tools$resources$indexer$SampleResourceIndexer != null ? class$org$w3c$tools$resources$indexer$SampleResourceIndexer : (class$org$w3c$tools$resources$indexer$SampleResourceIndexer = SampleResourceIndexer.class$("org.w3c.tools.resources.indexer.SampleResourceIndexer"));
        attribute = new StringAttribute("super-indexer", null, 2);
        ATTR_SUPER_INDEXER = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("not-indexed-names", null, 2);
        ATTR_NOT_INDEXED = AttributeRegistry.registerAttribute(clazz, attribute);
        noextension = new String[]{"*noextension*"};
    }

    public SampleResourceIndexer() {
    }

    public SampleResourceIndexer(ResourceContext resourceContext) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(3);
        String string = "identifier".intern();
        String string2 = "context".intern();
        hashtable.put(string2, resourceContext);
        hashtable.put(string, "default");
        this.initialize(hashtable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Resource createDirectoryResource(File file, RequestInterface requestInterface, String string, Hashtable hashtable) {
        File file2 = new File(file, string);
        Resource resource = null;
        ResourceReference resourceReference = null;
        resourceReference = this.loadDirectory(string);
        if (resourceReference == null && (resourceReference = this.loadDirectory(defname)) == null) {
            return null;
        }
        try {
            try {
                resource = resourceReference.lock();
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Object>(3);
                }
                String string2 = "directory".intern();
                String string3 = "identifier".intern();
                if (hashtable.get(string2) == null) {
                    hashtable.put(string2, file);
                }
                if (hashtable.get(string3) == null) {
                    hashtable.put(string3, this.getIndexedDirName(string));
                } else {
                    hashtable.put(string3, this.getIndexedDirName((String)hashtable.get(string3)));
                }
                try {
                    Resource resource2 = (Resource)resource.getClone(hashtable);
                    Object var10_14 = null;
                    resourceReference.unlock();
                    return resource2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Resource resource3 = null;
                    Object var10_15 = null;
                    resourceReference.unlock();
                    return resource3;
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
                Resource resource4 = null;
                Object var10_16 = null;
                resourceReference.unlock();
                return resource4;
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            resourceReference.unlock();
            throw throwable;
        }
    }

    protected Resource createFileResource(File file, RequestInterface requestInterface, String string, Hashtable hashtable) {
        ResourceFrame[] resourceFrameArray;
        ResourceReference resourceReference = null;
        FramedResource framedResource = null;
        FramedResource framedResource2 = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.tools.resources.ProtocolFrame");
        }
        catch (Exception exception) {
            return null;
        }
        String[] stringArray = this.getFileExtensions(string);
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length - 1;
        while (n >= 0) {
            resourceReference = this.getTemplateFor(stringArray[n]);
            if (resourceReference != null) break;
            --n;
        }
        if (resourceReference == null && (resourceReference = this.loadExtension(defname)) == null) {
            return null;
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>(5);
        }
        String string2 = "directory".intern();
        String string3 = "identifier".intern();
        String string4 = "filename".intern();
        String string5 = "context".intern();
        if (hashtable.get(string2) == null) {
            hashtable.put(string2, file);
        }
        if (hashtable.get(string3) == null) {
            hashtable.put(string3, this.getIndexedFileName(string));
        } else {
            hashtable.put(string3, this.getIndexedFileName((String)hashtable.get(string3)));
        }
        if (hashtable.get(string4) == null) {
            hashtable.put(string4, string);
        }
        if (hashtable.get(string5) == null) {
            hashtable.put(string5, this.getContext());
        }
        try {
            try {
                framedResource = (FramedResource)resourceReference.lock();
                if (stringArray != null) {
                    int n2 = stringArray.length;
                    while (--n2 >= 0) {
                        this.mergeDefaultAttributes(framedResource, stringArray[n2], hashtable);
                    }
                }
                try {
                    framedResource2 = (FramedResource)framedResource.getClone(hashtable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Resource resource = null;
                    Object var17_22 = null;
                    resourceReference.unlock();
                    return resource;
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
                Resource resource = null;
                Object var17_23 = null;
                resourceReference.unlock();
                return resource;
            }
            Object var17_24 = null;
            resourceReference.unlock();
        }
        catch (Throwable throwable) {
            Object var17_25 = null;
            resourceReference.unlock();
            throw throwable;
        }
        if (stringArray != null && (resourceFrameArray = framedResource2.collectFrames(clazz)) != null) {
            int n3 = 0;
            while (n3 < resourceFrameArray.length) {
                int n4 = stringArray.length - 1;
                while (n4 >= 0) {
                    resourceReference = this.getTemplateFor(stringArray[n4]);
                    if (resourceReference != null) {
                        Object var21_30;
                        FramedResource framedResource3 = null;
                        try {
                            try {
                                framedResource3 = (FramedResource)resourceReference.lock();
                                ResourceReference resourceReference2 = null;
                                resourceReference2 = framedResource3.getFrameReference(clazz);
                                if (resourceReference2 != null) {
                                    this.mergeFrameAttributes(resourceFrameArray[n3], stringArray[n4], resourceReference2);
                                }
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                invalidResourceException.printStackTrace();
                                Resource resource = null;
                                var21_30 = null;
                                resourceReference.unlock();
                                return resource;
                            }
                            var21_30 = null;
                            resourceReference.unlock();
                        }
                        catch (Throwable throwable) {
                            var21_30 = null;
                            resourceReference.unlock();
                            throw throwable;
                        }
                    }
                    --n4;
                }
                ++n3;
            }
        }
        return framedResource2;
    }

    public Resource createResource(ContainerResource containerResource, RequestInterface requestInterface, File file, String string, Hashtable hashtable) {
        String[] stringArray;
        if (isWinPlatform) {
            int n = 0;
            while (n < harmfulNames.length) {
                if (string.equalsIgnoreCase(harmfulNames[n])) {
                    return null;
                }
                ++n;
            }
        }
        if ((stringArray = (String[])this.getValue(ATTR_NOT_INDEXED, null)) != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return null;
                }
                ++n;
            }
        }
        File file2 = new File(file, string);
        Resource resource = null;
        resource = this.createVirtualResource(file, requestInterface, string, hashtable);
        if (resource != null) {
            return resource;
        }
        if (!file2.exists()) {
            return null;
        }
        if (file2.isDirectory()) {
            resource = this.createDirectoryResource(file, requestInterface, string, hashtable);
        } else if (file2.isFile()) {
            resource = this.createFileResource(file, requestInterface, string, hashtable);
        } else {
            return null;
        }
        if (resource != null) {
            return resource;
        }
        String string2 = this.getSuperIndexer();
        if (string2 == null) {
            return null;
        }
        IndexerModule indexerModule = null;
        indexerModule = (IndexerModule)this.getContext().getModule(IndexerModule.NAME);
        ResourceReference resourceReference = indexerModule.getIndexer(string2);
        if (resourceReference == null) {
            return null;
        }
        try {
            try {
                ResourceIndexer resourceIndexer = (ResourceIndexer)((Object)resourceReference.lock());
                Resource resource2 = resourceIndexer != null ? resourceIndexer.createResource(containerResource, requestInterface, file, string, hashtable) : null;
                Object var14_17 = null;
                resourceReference.unlock();
                return resource2;
            }
            catch (InvalidResourceException invalidResourceException) {
                Resource resource3 = null;
                Object var14_18 = null;
                resourceReference.unlock();
                return resource3;
            }
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            resourceReference.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Resource createVirtualResource(File file, RequestInterface requestInterface, String string, Hashtable hashtable) {
        Resource resource;
        ResourceReference resourceReference;
        block19: {
            Resource resource2;
            block18: {
                Resource resource3;
                block17: {
                    Resource resource4;
                    block16: {
                        resourceReference = null;
                        Resource resource5 = null;
                        resourceReference = this.loadDirectory(string);
                        if (resourceReference == null) return null;
                        try {
                            try {
                                Object object;
                                Object object2;
                                resource5 = resourceReference.lock();
                                String string2 = resource5.getClass().getName().intern();
                                String string3 = "org.w3c.jigsaw.resources.DirectoryResource".intern();
                                if (string2 == string3) {
                                    object2 = new File(file, string);
                                    if (!((File)object2).exists()) {
                                        Resource resource6 = null;
                                        Object var9_18 = null;
                                        resourceReference.unlock();
                                        return resource6;
                                    }
                                    if (!((File)object2).isDirectory()) {
                                        resource4 = null;
                                        break block16;
                                    }
                                }
                                if (string2 == (object2 = "org.w3c.tools.resources.FileResource".intern())) {
                                    object = new File(file, string);
                                    if (!((File)object).exists()) {
                                        resource3 = null;
                                        break block17;
                                    }
                                    if (((File)object).isDirectory()) {
                                        resource2 = null;
                                        break block18;
                                    }
                                }
                                if (hashtable == null) {
                                    hashtable = new Hashtable(4);
                                }
                                object = "directory".intern();
                                String string4 = "identifier".intern();
                                String string5 = "context".intern();
                                if (hashtable.get(object) == null) {
                                    hashtable.put(object, file);
                                }
                                if (hashtable.get(string4) == null) {
                                    hashtable.put(string4, string);
                                }
                                if (hashtable.get(string5) == null) {
                                    hashtable.put(string5, this.getContext());
                                }
                                try {
                                    resource = (Resource)resource5.getClone(hashtable);
                                    break block19;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    Resource resource7 = null;
                                    Object var9_23 = null;
                                    resourceReference.unlock();
                                    return resource7;
                                }
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                invalidResourceException.printStackTrace();
                                Resource resource8 = null;
                                Object var9_24 = null;
                                resourceReference.unlock();
                                return resource8;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_25 = null;
                            resourceReference.unlock();
                            throw throwable;
                        }
                    }
                    Object var9_19 = null;
                    resourceReference.unlock();
                    return resource4;
                }
                Object var9_20 = null;
                resourceReference.unlock();
                return resource3;
            }
            Object var9_21 = null;
            resourceReference.unlock();
            return resource2;
        }
        Object var9_22 = null;
        resourceReference.unlock();
        return resource;
    }

    public synchronized void delete() throws MultipleLockException {
        Object var3_3;
        Resource resource;
        DummyResourceReference dummyResourceReference = (DummyResourceReference)this.getExtensions();
        try {
            try {
                resource = dummyResourceReference.lock();
                resource.delete();
            }
            catch (InvalidResourceException invalidResourceException) {
            }
            var3_3 = null;
            dummyResourceReference.invalidate();
            dummyResourceReference.unlock();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            dummyResourceReference.invalidate();
            dummyResourceReference.unlock();
            throw throwable;
        }
        dummyResourceReference = (DummyResourceReference)this.getDirectories();
        try {
            try {
                resource = dummyResourceReference.lock();
                resource.delete();
            }
            catch (InvalidResourceException invalidResourceException) {
            }
            var3_3 = null;
            dummyResourceReference.invalidate();
            dummyResourceReference.unlock();
        }
        catch (Throwable throwable) {
            var3_3 = null;
            dummyResourceReference.invalidate();
            dummyResourceReference.unlock();
            throw throwable;
        }
        super.delete();
    }

    public void delete(String string) {
        throw new RuntimeException("static container");
    }

    public Enumeration enumerateResourceIdentifiers(boolean bl) {
        return new SampleIndexerEnumeration();
    }

    protected synchronized ResourceReference getDirectories() {
        if (this.directories == null) {
            String string = String.valueOf(this.getIdentifier()) + "-d";
            this.directories = new DummyResourceReference(new TemplateContainer(new ResourceContext(this.getContext()), String.valueOf(string) + ".db"));
        }
        return this.directories;
    }

    protected synchronized ResourceReference getExtensions() {
        if (this.extensions == null) {
            String string = String.valueOf(this.getIdentifier()) + "-e";
            this.extensions = new DummyResourceReference(new TemplateContainer(new ResourceContext(this.getContext()), String.valueOf(string) + ".db"));
        }
        return this.extensions;
    }

    protected String[] getFileExtensions(String string) {
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(46);
        if (n > 0) {
            int n2 = n + 1;
            while ((n = string.indexOf(46, n2)) != -1) {
                if (n == n2 + 1) {
                    ++n2;
                    continue;
                }
                vector.addElement(string.substring(n2, n));
                n2 = n + 1;
            }
            if (n2 < string.length()) {
                vector.addElement(string.substring(n2));
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return noextension;
    }

    protected String getIndexedDirName(String string) {
        return string;
    }

    protected String getIndexedFileName(String string) {
        return string;
    }

    public String getIndexedName(File file, String string) {
        File file2;
        if (isWinPlatform) {
            int n = 0;
            while (n < harmfulNames.length) {
                if (string.equalsIgnoreCase(harmfulNames[n])) {
                    return null;
                }
                ++n;
            }
        }
        if (!(file2 = new File(file, string)).exists()) {
            return null;
        }
        if (file2.isDirectory()) {
            return this.getIndexedDirName(string);
        }
        String[] stringArray = this.getFileExtensions(string);
        ResourceReference resourceReference = null;
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length - 1;
        while (n >= 0) {
            resourceReference = this.getTemplateFor(stringArray[n]);
            if (resourceReference != null) break;
            --n;
        }
        if (resourceReference != null) {
            return this.getIndexedFileName(string);
        }
        String string2 = this.getSuperIndexer();
        if (string2 == null) {
            return null;
        }
        IndexerModule indexerModule = null;
        indexerModule = (IndexerModule)this.getContext().getModule(IndexerModule.NAME);
        ResourceReference resourceReference2 = indexerModule.getIndexer(string2);
        if (resourceReference2 == null) {
            return null;
        }
        try {
            try {
                ResourceIndexer resourceIndexer = (ResourceIndexer)((Object)resourceReference2.lock());
                String string3 = resourceIndexer != null ? resourceIndexer.getIndexedName(file, string) : null;
                Object var12_14 = null;
                resourceReference2.unlock();
                return string3;
            }
            catch (InvalidResourceException invalidResourceException) {
                String string4 = null;
                Object var12_15 = null;
                resourceReference2.unlock();
                return string4;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            resourceReference2.unlock();
            throw throwable;
        }
    }

    public String getSuperIndexer() {
        return this.getString(ATTR_SUPER_INDEXER, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResourceReference getTemplateFor(String string) {
        ResourceReference resourceReference;
        ResourceReference resourceReference2;
        block8: {
            ResourceReference resourceReference3;
            block7: {
                resourceReference2 = this.loadExtension(string);
                if (resourceReference2 == null) {
                    return null;
                }
                try {
                    try {
                        Resource resource = resourceReference2.lock();
                        if (resource != null) {
                            Resource resource2 = new Resource();
                            if (resource.getClass() == resource2.getClass()) {
                                ResourceReference resourceReference4 = null;
                                Object var5_9 = null;
                                resourceReference2.unlock();
                                return resourceReference4;
                            }
                            resourceReference3 = resourceReference2;
                            break block7;
                        }
                        resourceReference = null;
                        break block8;
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        ResourceReference resourceReference5 = null;
                        Object var5_12 = null;
                        resourceReference2.unlock();
                        return resourceReference5;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_13 = null;
                    resourceReference2.unlock();
                    throw throwable;
                }
            }
            Object var5_10 = null;
            resourceReference2.unlock();
            return resourceReference3;
        }
        Object var5_11 = null;
        resourceReference2.unlock();
        return resourceReference;
    }

    public long lastModified() {
        return this.getLong(Resource.ATTR_LAST_MODIFIED, -1L);
    }

    public synchronized ResourceReference loadDirectory(String string) {
        ResourceReference resourceReference = this.getDirectories();
        try {
            try {
                TemplateContainer templateContainer = (TemplateContainer)resourceReference.lock();
                ResourceReference resourceReference2 = templateContainer.lookup(string);
                Object var5_7 = null;
                resourceReference.unlock();
                return resourceReference2;
            }
            catch (InvalidResourceException invalidResourceException) {
                String string2 = "[resource indexer]: directory template \"" + string + "\" couldn't be restored. It has " + "been removed.";
                this.getContext().getServer().errlog(string2);
                ResourceReference resourceReference3 = null;
                Object var5_8 = null;
                resourceReference.unlock();
                return resourceReference3;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            resourceReference.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ResourceReference loadExtension(String string) {
        ResourceReference resourceReference;
        ResourceReference resourceReference2 = this.getExtensions();
        ResourceReference resourceReference3 = null;
        try {
            try {
                TemplateContainer templateContainer = (TemplateContainer)resourceReference2.lock();
                resourceReference3 = templateContainer.lookup(string);
                if (resourceReference3 == null) {
                    ResourceReference resourceReference4 = templateContainer.lookup(string.toLowerCase());
                    Object var6_9 = null;
                    resourceReference2.unlock();
                    return resourceReference4;
                }
                resourceReference = resourceReference3;
            }
            catch (InvalidResourceException invalidResourceException) {
                String string2 = "[resource indexer]: extensions \"" + string + "\" couldn't be restored (" + invalidResourceException.getMessage() + ")";
                this.getContext().getServer().errlog(string2);
                ResourceReference resourceReference5 = null;
                Object var6_11 = null;
                resourceReference2.unlock();
                return resourceReference5;
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            resourceReference2.unlock();
            throw throwable;
        }
        Object var6_10 = null;
        resourceReference2.unlock();
        return resourceReference;
    }

    public ResourceReference lookup(String string) {
        if (string.equals("directories")) {
            return this.getDirectories();
        }
        if (string.equals("extensions")) {
            return this.getExtensions();
        }
        return null;
    }

    protected Hashtable mergeDefaultAttributes(Resource resource, String string, Hashtable hashtable) {
        Attribute[] attributeArray = resource.getAttributes();
        ResourceReference resourceReference = this.loadExtension(string);
        if (resourceReference != null) {
            try {
                try {
                    Resource resource2 = resourceReference.lock();
                    if (resource2 != null) {
                        int n = 0;
                        while (n < attributeArray.length) {
                            Object object;
                            int n2;
                            if (!resource.definesAttribute(n) && (n2 = resource2.lookupAttribute(attributeArray[n].getName())) >= 0 && (object = resource2.getValue(n2, null)) != null) {
                                hashtable.put(attributeArray[n].getName(), object);
                            }
                            ++n;
                        }
                    }
                    Hashtable hashtable2 = hashtable;
                    Object var8_12 = null;
                    resourceReference.unlock();
                    return hashtable2;
                }
                catch (InvalidResourceException invalidResourceException) {
                    Hashtable hashtable3 = null;
                    Object var8_13 = null;
                    resourceReference.unlock();
                    return hashtable3;
                }
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                resourceReference.unlock();
                throw throwable;
            }
        }
        return null;
    }

    protected void mergeFrameAttributes(ResourceFrame resourceFrame, String string, ResourceReference resourceReference) {
        try {
            try {
                Resource resource = resourceReference.lock();
                Attribute[] attributeArray = resource.getAttributes();
                int n = 0;
                while (n < attributeArray.length) {
                    String string2 = attributeArray[n].getName();
                    try {
                        Double d;
                        Object object = resourceFrame.getValue(string2, null);
                        if (object == null) {
                            try {
                                resourceFrame.setValue(string2, resource.getValue(string2, null));
                            }
                            catch (Exception exception) {}
                        } else if (string2.equals("quality") && (d = (Double)resource.getValue(string2, null)) != null) {
                            d = new Double(d * (Double)object);
                            resourceFrame.setValue(string2, (Object)d);
                        }
                    }
                    catch (Exception exception) {}
                    ++n;
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
            }
            Object var9_11 = null;
            resourceReference.unlock();
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            resourceReference.unlock();
            throw throwable;
        }
    }

    public void registerResource(String string, Resource resource, Hashtable hashtable) {
        throw new RuntimeException("static container");
    }
}

