/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import html.parser.AttributeList;
import html.parser.ContentModel;
import html.parser.DTDConstants;
import java.util.BitSet;
import java.util.Hashtable;

public class Element
implements DTDConstants {
    int index;
    String name;
    boolean oStart;
    boolean oEnd;
    BitSet inclusions;
    BitSet exclusions;
    int type = 17;
    ContentModel content;
    AttributeList atts;
    static Hashtable contentTypes = new Hashtable();

    public Element(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public boolean omitStart() {
        return this.oStart;
    }

    public boolean omitEnd() {
        return this.oEnd;
    }

    public int getType() {
        return this.type;
    }

    public ContentModel getContent() {
        return this.content;
    }

    public AttributeList getAttributes() {
        return this.atts;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isEmpty() {
        return this.type == 17;
    }

    public String toString() {
        return this.name;
    }

    public AttributeList getAttribute(String name) {
        AttributeList a = this.atts;
        while (a != null) {
            if (a.name.equals(name)) {
                return a;
            }
            a = a.next;
        }
        return null;
    }

    public AttributeList getAttributeByValue(String name) {
        AttributeList a = this.atts;
        while (a != null) {
            if (a.values != null && a.values.contains(name)) {
                return a;
            }
            a = a.next;
        }
        return null;
    }

    public void print() {
        System.out.print("<!ELEMENT " + this.name + (this.oStart ? " O" : " -") + (this.oEnd ? " O " : " - "));
        switch (this.type) {
            case 18: {
                System.out.print(" " + this.content);
                break;
            }
            case 1: {
                System.out.print(" CDATA");
                break;
            }
            case 16: {
                System.out.print(" RCDATA");
                break;
            }
            case 17: {
                System.out.print(" EMPTY");
                break;
            }
            case 19: {
                System.out.print(" ANY");
            }
        }
        if (this.exclusions != null) {
            System.out.print(" -" + this.exclusions);
        }
        if (this.inclusions != null) {
            System.out.print(" +" + this.inclusions);
        }
        System.out.println(" --" + this.index + "-->");
        if (this.atts != null) {
            this.atts.print(this);
        }
    }

    static int name2type(String nm) {
        Integer val = (Integer)contentTypes.get(nm);
        return val != null ? val : 0;
    }

    static {
        contentTypes.put("CDATA", new Integer(1));
        contentTypes.put("RCDATA", new Integer(16));
        contentTypes.put("EMPTY", new Integer(17));
        contentTypes.put("ANY", new Integer(19));
    }
}

