/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import html.parser.DTD;
import html.parser.DTDConstants;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;

public class Entity
implements DTDConstants {
    String name;
    int type;
    byte[] data;
    static Hashtable entityTypes = new Hashtable();

    Entity(String name, int type, byte[] data) {
        this.name = name;
        this.type = type;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type & 0xFFFF;
    }

    public boolean isParameter() {
        return (this.type & 0x40000) != 0;
    }

    public boolean isGeneral() {
        return (this.type & 0x10000) != 0;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getString() {
        return new String(this.data);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if ((this.type & 0xA) != 0) {
            return DTD.mapping.get(this.getString());
        }
        if ((this.type & 0x11) != 0) {
            String iname = DTD.mapping.dir + "/" + this.getString();
            URL url = Entity.class.getResource(iname);
            try {
                return new BufferedInputStream(url.openStream());
            }
            catch (Exception x) {
                throw new FileNotFoundException(iname);
            }
        }
        return new ByteArrayInputStream(this.data);
    }

    public void print() {
        if (this.isParameter()) {
            return;
        }
        System.out.print("<!ENTITY ");
        System.out.print(this.name);
        switch (this.getType()) {
            case 10: {
                System.out.print(" PUBLIC");
                break;
            }
            case 1: {
                System.out.print(" CDATA");
                break;
            }
            case 11: {
                System.out.print(" SDATA");
                break;
            }
            case 12: {
                System.out.print(" PI");
                break;
            }
            case 13: {
                System.out.print(" STARTTAG");
                break;
            }
            case 14: {
                System.out.print(" ENDTAG");
                break;
            }
            case 15: {
                System.out.print(" MS");
                break;
            }
            case 16: {
                System.out.print(" MD");
            }
        }
        System.out.print(" \"" + this.getString() + "\"");
        System.out.println(">");
    }

    static int name2type(String nm) {
        Integer i = (Integer)entityTypes.get(nm);
        return i == null ? 1 : i;
    }

    static {
        entityTypes.put("PUBLIC", new Integer(10));
        entityTypes.put("CDATA", new Integer(1));
        entityTypes.put("SDATA", new Integer(11));
        entityTypes.put("PI", new Integer(12));
        entityTypes.put("STARTTAG", new Integer(13));
        entityTypes.put("ENDTAG", new Integer(14));
        entityTypes.put("MS", new Integer(15));
        entityTypes.put("MD", new Integer(16));
        entityTypes.put("SYSTEM", new Integer(17));
    }
}

