/*
 * Decompiled with CFR 0.152.
 */
package html.tags;

import html.parser.Attributes;
import html.parser.Element;
import html.tags.Block;
import html.tags.HtmlTree;
import html.tags.ParserFrame;
import html.tree.Tree;
import java.io.ByteArrayInputStream;

public class StyleTag
extends Block {
    public static final boolean debug = false;
    String media = null;
    String title = null;
    String type = null;

    public void initialize(Element elem, Attributes atts, ParserFrame parserFrame) {
        super.initialize(elem, atts, parserFrame);
        if (atts != null) {
            this.media = atts.get("media");
            this.title = atts.get("title");
            this.type = atts.get("type");
        }
    }

    public void attach(Tree child, int rank) {
        super.attach(child, rank);
        HtmlTree htmlChild = (HtmlTree)child;
        String text = this.getChildText(htmlChild);
        if (text != null && (this.type == null || this.type.equalsIgnoreCase("text/css"))) {
            if (this.media == null) {
                this.media = "all";
            }
            this.parserFrame.styleSheetParser.parseStyleElement(this.parserFrame.ac, new ByteArrayInputStream(text.getBytes()), this.title, this.media, this.parserFrame.getURI(), this.line);
        }
    }

    protected String getChildText(HtmlTree htmlChild) {
        Attributes atts = htmlChild.getAttributes();
        if (atts == null) {
            return null;
        }
        return atts.get("text");
    }
}

