/*
 * Decompiled with CFR 0.152.
 */
package html.tree;

import html.tree.Tree;
import html.util.EmptyEnumeration;
import java.util.Enumeration;
import java.util.Vector;

public class SimpleTree
implements Tree {
    private static Enumeration NO_CHILD = new EmptyEnumeration();
    Vector children = null;
    Tree parent;

    public Tree getParent() {
        return this.parent;
    }

    public void setParent(Tree child) {
        this.parent = child;
    }

    public int getRank() {
        return this.parent.indexOf(this);
    }

    public int indexOf(Tree child) {
        return this.children.indexOf(child);
    }

    public Tree getChild(int r) {
        return (Tree)this.children.elementAt(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Tree child, int r) {
        Vector vector = this.children;
        synchronized (vector) {
            Tree old = (Tree)this.children.elementAt(r);
            this.children.removeElementAt(r);
            this.children.insertElementAt(child, r);
        }
    }

    public void attach(Tree child, int rank) {
        this.checkChildren();
        this.children.insertElementAt(child, rank);
        child.setParent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Tree child, Tree after) {
        this.checkChildren();
        Vector vector = this.children;
        synchronized (vector) {
            int r = this.children.indexOf(after);
            this.children.insertElementAt(child, r);
        }
        child.setParent(this);
    }

    public void detach(Tree child) {
        this.children.removeElement(child);
        child.setParent(null);
    }

    public void detachChildren() {
        this.children = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Tree child, int rank) {
        Vector vector = this.children;
        synchronized (vector) {
            this.children.removeElement(child);
            this.children.insertElementAt(child, rank);
        }
    }

    public int arity() {
        return this.children != null ? this.children.size() : 0;
    }

    public Enumeration children() {
        return this.children != null ? this.children.elements() : NO_CHILD;
    }

    private final void checkChildren() {
        if (this.children == null) {
            this.children = new Vector(1, 1);
        }
    }
}

