/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.w3c.css.css.StyleReport;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetGenerator;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssPrinterStyle;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.Errors;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.util.Util;
import org.w3c.css.util.Warning;
import org.w3c.css.util.Warnings;

public final class StyleReportSOAP12
extends StyleReport
implements CssPrinterStyle {
    StyleSheet style;
    Vector items;
    Warnings warnings;
    Errors errors;
    ApplContext ac;
    private CssSelectors selector;
    private CssProperty property;
    private PrintWriter out;
    private int warningLevel;
    private Utf8Properties general;
    private static Utf8Properties availableFormat;
    private static Utf8Properties availablePropertiesURL;
    private static Hashtable formats;
    int counter = 0;
    private static final String DEFAULT_CHARSET = "utf-8";

    public StyleReportSOAP12(ApplContext ac, String title, StyleSheet style, String document, int warningLevel) {
        if (document == null) {
            document = "soap12.en";
        }
        if (Util.onDebug) {
            System.err.println("document format is " + document);
        }
        this.ac = ac;
        this.style = style;
        this.general = new Utf8Properties(this.setDocumentBase(StyleReportSOAP12.getDocumentName(ac, document)));
        this.general.put("file-title", title);
        this.warnings = style.getWarnings();
        this.errors = style.getErrors();
        this.items = style.newGetRules();
        this.warningLevel = warningLevel;
        this.general.put("cssversion", ac.getCssVersion());
        this.general.put("errors-count", Integer.toString(this.errors.getErrorCount()));
        this.general.put("warnings-count", Integer.toString(this.warnings.getWarningCount()));
        this.general.put("rules-count", Integer.toString(this.items.size()));
        this.general.put("isvalid", this.errors.getErrorCount() == 0 ? "true" : "false");
        if (ac.getContentEncoding() != null) {
            this.general.put("encoding", " encoding=\"" + ac.getContentEncoding() + "\" ");
        } else {
            this.general.put("encoding", " ");
        }
        if (this.errors.getErrorCount() == 0) {
            this.desactivateError();
        }
        if (this.errors.getErrorCount() != 0 || !title.startsWith("http://")) {
            this.general.put("no-errors", "");
        }
        if (style.charset == null) {
            this.general.put("charset-rule", "");
        }
        if (this.warnings.getWarningCount() == 0 || warningLevel == -1) {
            this.general.put("go-warnings", "");
            this.general.put("warnings", "");
        }
        if (this.items.size() == 0) {
            this.general.put("go-rules", "");
            this.general.put("rules", "");
            this.general.put("no-errors", "");
        } else {
            this.general.put("no-rules", "");
        }
        if (this.errors.getErrorCount() != 0 || this.warnings.getWarningCount() != 0) {
            this.general.put("no-error-or-warning", "");
        }
        if (Util.onDebug) {
            this.general.list(System.err);
        }
        DateFormat df = null;
        if (ac.getLang() != null) {
            try {
                df = DateFormat.getDateTimeInstance(0, 0, new Locale(ac.getLang().substring(0, 2), "US"));
            }
            catch (Exception e) {
                df = DateFormat.getDateTimeInstance(0, 0, Locale.US);
            }
        }
        if (df != null) {
            this.general.put("today", df.format(new Date()));
        } else {
            this.general.put("today", new Date().toString());
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.general.put("currentdate", formatter.format(new Date()));
    }

    public void desactivateError() {
        this.general.put("go-errors", "");
        this.general.put("errors", "");
    }

    public void print(PrintWriter out) {
        this.out = out;
        String output = this.processSimple("document");
        if (output != null) {
            out.println(output);
        } else {
            out.println(this.ac.getMsg().getGeneratorString("request"));
        }
        out.flush();
    }

    public void produceStyleSheet() {
    }

    public void print(CssProperty property) {
        Utf8Properties prop = new Utf8Properties(this.general);
        prop.put("property-name", property.getPropertyName().toString());
        prop.put("property-value", property.toString());
        if (!property.getImportant()) {
            prop.put("important-style", "");
        }
        this.out.print(this.processStyle(prop.getProperty("declaration"), prop));
    }

    public void produceParseException(CssParseException error) {
        if (error.getContexts() != null && error.getContexts().size() != 0) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = error.getContexts().elements();
            while (e.hasMoreElements()) {
                Object t = e.nextElement();
                if (t == null) continue;
                buf.append(t);
                if (!e.hasMoreElements()) continue;
                buf.append(", ");
            }
            if (buf.length() != 0) {
                this.out.print("parse-error</m:errortype>\n              <m:context>");
                this.out.print(buf);
                this.out.print("</m:context>\n");
            }
        } else {
            this.out.print("parse-error</m:errortype>\n");
        }
        String name = error.getProperty();
        if (name != null && StyleReportSOAP12.getURLProperty(name) != null) {
            this.out.print("              <m:property>");
            this.out.print(name);
            this.out.print("</m:property>\n");
        }
        if (error.getException() != null && error.getMessage() != null) {
            if (error.isParseException()) {
                this.out.print("              <m:message>");
                this.out.print(this.queryReplace(error.getMessage()));
                this.out.print("</m:message>\n");
            } else {
                Exception ex = error.getException();
                if (ex instanceof NumberFormatException) {
                    this.out.print("              <m:errorsubtype>invalid-number</m:error-subtype>\n");
                } else {
                    this.out.print("              <m:message>");
                    this.out.print(this.queryReplace(ex.getMessage()));
                    this.out.print("</m:message>\n");
                }
            }
            if (error.getSkippedString() != null) {
                this.out.print("              <m:skippedstring>");
                this.out.print(this.queryReplace(error.getSkippedString()));
                this.out.print("</m:skippedstring>\n");
            } else if (error.getExp() != null) {
                this.out.print("              <m:expression>\n                <m:start>");
                this.out.print(this.queryReplace(error.getExp().toStringFromStart()));
                this.out.print("</m:start>\n                <m:end>");
                this.out.print(this.queryReplace(error.getExp().toString()));
                this.out.print("</m:end>\n              </m:expression>\n");
            }
        } else {
            this.out.print("              <m:errorsubtype>unrecognized</m:errorsubtype>\n");
            this.out.print("              <m:skippedstring>");
            this.out.print(this.queryReplace(error.getSkippedString()));
            this.out.print("</m:skippedstring>\n");
        }
    }

    public void produceError() {
        String oldSourceFile = null;
        boolean open = false;
        try {
            if (this.errors.getErrorCount() != 0) {
                CssError[] error = this.errors.getErrors();
                for (int i = 0; i < error.length; ++i) {
                    Exception ex = error[i].getException();
                    String file = error[i].getSourceFile();
                    if (!file.equals(oldSourceFile)) {
                        oldSourceFile = file;
                        if (open) {
                            this.out.print("          </m:errorlist>\n");
                        }
                        this.out.print("          <m:errorlist>\n");
                        this.out.print("            <m:uri>" + file + "</m:uri>\n");
                        open = true;
                    }
                    this.out.print("            <m:error>\n              <m:line>");
                    this.out.print(error[i].getLine());
                    this.out.print("</m:line>\n              <m:errortype>");
                    if (ex instanceof FileNotFoundException) {
                        this.out.print("not-found");
                        this.out.print("</m:errortype>\n              <m:message>");
                        this.out.print(ex.getMessage());
                        this.out.print("</m:message>\n");
                    } else if (ex instanceof CssParseException) {
                        this.produceParseException((CssParseException)ex);
                    } else if (ex instanceof InvalidParamException) {
                        this.out.print("invalid-parameter");
                        this.out.print("</m:errortype>\n              <m:message>");
                        this.out.print(this.queryReplace(ex.getMessage()));
                        this.out.print("              </m:message>\n");
                    } else if (ex instanceof IOException) {
                        this.out.print("IOException</m:errortype>\n");
                        this.out.print("              <m:message>");
                        this.out.print(this.queryReplace(ex.getMessage()));
                        this.out.print("              </m:message>\n");
                    } else if (error[i] instanceof CssErrorToken) {
                        this.out.print("csserror</m:errortype>");
                        CssErrorToken terror = (CssErrorToken)error[i];
                        this.out.print("\n                <m:description>");
                        this.out.print(terror.getErrorDescription());
                        this.out.print("</m:description>\n");
                        this.out.print("                <m:skippedstring>");
                        this.out.print(terror.getSkippedString());
                        this.out.print("                </m:skippedstring>\n");
                    } else {
                        this.out.print("uncaught");
                        this.out.print("</m:errortype>\n              <m:message>");
                        this.out.print(this.queryReplace(ex.getMessage()));
                        this.out.print("</m:message>\n");
                        if (ex instanceof NullPointerException) {
                            this.out.print("nullpointer");
                            this.out.print("</m:errortype>\n              <m:message>");
                            ex.printStackTrace(this.out);
                            this.out.print("</m:message>\n");
                        }
                    }
                    this.out.print("            </m:error>\n");
                }
                this.out.print("          </m:errorlist>");
            }
        }
        catch (Exception e) {
            this.out.print("<m:processingerror>");
            this.out.println(this.ac.getMsg().getGeneratorString("request"));
            e.printStackTrace(this.out);
            this.out.print("</m:processingerror>\n");
        }
    }

    public void produceWarning() {
        boolean open = false;
        String oldSourceFile = "";
        int oldLine = -1;
        String oldMessage = "";
        try {
            if (this.warnings.getWarningCount() != 0) {
                this.warnings.sort();
                Warning[] warning = this.warnings.getWarnings();
                for (int i = 0; i < warning.length; ++i) {
                    Warning warn = warning[i];
                    if (warn.getLevel() > this.warningLevel) continue;
                    if (!warn.getSourceFile().equals(oldSourceFile)) {
                        if (open) {
                            this.out.print("          </m:warninglist>\n");
                        }
                        oldSourceFile = warn.getSourceFile();
                        this.out.print("          <m:warninglist>\n");
                        this.out.print("            <m:uri>" + oldSourceFile + "</m:uri>\n");
                        open = true;
                    }
                    oldLine = warn.getLine();
                    oldMessage = warn.getWarningMessage();
                    this.out.print("            <m:warning>\n              <m:line>");
                    this.out.print(oldLine);
                    this.out.print("</m:line>\n");
                    this.out.print("              <m:level>");
                    this.out.print(warn.getLevel());
                    this.out.print("</m:level>\n");
                    this.out.print("              <m:message>");
                    this.out.print(oldMessage);
                    this.out.print("</m:message>\n");
                    if (warn.getContext() != null) {
                        this.out.print("              <m:context>");
                        this.out.print(warn.getContext());
                        this.out.print("</m:context>\n");
                    }
                    this.out.print("            </m:warning>\n");
                }
                if (open) {
                    this.out.print("          </m:warninglist>");
                }
            }
        }
        catch (Exception e) {
            this.out.print("<m:processingerror>");
            this.out.println(this.ac.getMsg().getGeneratorString("request"));
            e.printStackTrace(this.out);
            this.out.print("</m:processingerror>\n");
        }
    }

    private String queryReplace(String s) {
        if (s != null) {
            int len = s.length();
            StringBuffer ret = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == '<') {
                    ret.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    ret.append("&gt;");
                    continue;
                }
                if (c == '&') {
                    ret.append("&amp;");
                    continue;
                }
                if (c == '\'') {
                    ret.append("&apos;");
                    continue;
                }
                if (c == '\"') {
                    ret.append("&quot;");
                    continue;
                }
                ret.append(c);
            }
            return ret.toString();
        }
        return "[empty string]";
    }

    private final String processSimple(String s) {
        return this.processStyle(this.general.getProperty(s), this.general);
    }

    private String processStyle(String str, Utf8Properties prop) {
        try {
            int i = 0;
            while ((i = str.indexOf("<!-- #", i)) >= 0) {
                String value;
                int lastIndexOfEntity = str.indexOf("-->", i);
                String entity = str.substring(i + 6, lastIndexOfEntity - 1).toLowerCase();
                if (entity.equals("rule")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceStyleSheet();
                    continue;
                }
                if (entity.equals("selectors")) {
                    if (this.selector.getNext() != null) {
                        value = prop.getProperty(entity);
                        if (value != null) {
                            str = str.substring(0, i) + value + str.substring(lastIndexOfEntity + 3);
                            continue;
                        }
                        i += 6;
                        continue;
                    }
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    continue;
                }
                if (entity.equals("selector")) {
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    continue;
                }
                if (entity.equals("charset")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.out.print(this.ac.getContentEncoding());
                    continue;
                }
                if (entity.equals("declaration")) {
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    continue;
                }
                if (entity.equals("warning")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceWarning();
                    continue;
                }
                if (entity.equals("error")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceError();
                    continue;
                }
                if (entity.equals("hook-html-validator")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    if (this.style.getType().equals("text/html")) {
                        this.out.println(this.ac.getMsg().getGeneratorString("doc-html", this.general.get("file-title").toString()));
                        continue;
                    }
                    this.out.println(this.ac.getMsg().getGeneratorString("doc"));
                    continue;
                }
                if (entity.equals("lang")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    String lang = this.ac.getContentLanguage();
                    if (lang == null || lang.equals("")) {
                        lang = "en";
                    }
                    this.out.print(lang);
                    continue;
                }
                value = prop.getProperty(entity);
                if (value != null) {
                    str = str.substring(0, i) + value + str.substring(lastIndexOfEntity + 3);
                    continue;
                }
                i += 6;
            }
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }

    public static final void printAvailableFormat(PrintWriter out) {
        Enumeration<?> e = availableFormat.propertyNames();
        out.println(" -- listing available output format --");
        while (e.hasMoreElements()) {
            String key = ((String)e.nextElement()).toLowerCase();
            out.println("Format : " + key);
            out.println("   File : " + StyleReportSOAP12.getDocumentName(null, key));
        }
        out.flush();
    }

    private Utf8Properties setDocumentBase(String document) {
        Utf8Properties properties = (Utf8Properties)formats.get(document);
        if (properties == null) {
            properties = new Utf8Properties();
            try {
                URL url = StyleSheetGenerator.class.getResource(document);
                InputStream f = url.openStream();
                properties.load(f);
                f.close();
                properties.put("author", "www-validator-css");
                properties.put("author-email", "Email.html");
            }
            catch (Exception e) {
                System.err.println("org.w3c.css.css.StyleSheetGenerator: couldn't load properties " + document);
                System.err.println("  " + e.toString());
                StyleReportSOAP12.printAvailableFormat(new PrintWriter(System.err));
            }
            formats.put(document, properties);
        }
        return new Utf8Properties(properties);
    }

    private static final String getDocumentName(ApplContext ac, String documentName) {
        documentName = documentName.toLowerCase();
        String document = null;
        if (ac != null && ac.getLang() != null) {
            StringTokenizer tokens = new StringTokenizer(ac.getLang(), ",");
            while (tokens.hasMoreTokens()) {
                String l = tokens.nextToken().trim().toLowerCase();
                document = availableFormat.getProperty(documentName + "." + l);
                if (document != null) break;
                int minusIndex = l.indexOf(45);
                if (minusIndex != -1) {
                    l = l.substring(0, minusIndex);
                    document = availableFormat.getProperty(documentName + "." + l);
                }
                if (document == null) continue;
                break;
            }
        }
        if (document == null) {
            document = availableFormat.getProperty(documentName);
        }
        if (document == null) {
            System.err.println("Unable to find " + documentName + " output format");
            return documentName;
        }
        return document;
    }

    private static final String getURLProperty(String name) {
        return availablePropertiesURL.getProperty(name);
    }

    static {
        InputStream f;
        URL url;
        formats = new Hashtable();
        availableFormat = new Utf8Properties();
        try {
            url = StyleSheetGenerator.class.getResource("format.properties");
            f = url.openStream();
            availableFormat.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.StyleSheetGenerator: couldn't load format properties ");
            System.err.println("  " + e.toString());
        }
        availablePropertiesURL = new Utf8Properties();
        try {
            url = StyleSheetGenerator.class.getResource("urls.properties");
            f = url.openStream();
            availablePropertiesURL.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.StyleSheetGenerator: couldn't load URLs properties ");
            System.err.println("  " + e.toString());
        }
    }
}

