/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.css.css.CssRuleList;
import org.w3c.css.css.CssValidator;
import org.w3c.css.css.StyleReport;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetCom;
import org.w3c.css.css.StyleSheetGenerator;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.Errors;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.Date;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.util.Util;
import org.w3c.css.util.Warning;
import org.w3c.css.util.Warnings;

public final class StyleSheetGenerator2
extends StyleReport {
    Hashtable items;
    Warnings warnings;
    Errors errors;
    private CssSelectors selector;
    private CssProperty property;
    private PrintWriter out;
    private int warningLevel;
    private Utf8Properties general;
    private static Utf8Properties availableFormat;
    private static Hashtable formats;

    public StyleSheetGenerator2(String title, StyleSheet style, String document, int warningLevel) {
        if (StyleSheetCom.showCSS || CssValidator.showCSS) {
            if (style.charset != null) {
                System.out.println("@charset " + style.charset + ";\n");
            }
            Vector atRules = style.newGetRules();
            for (int i = 0; i < atRules.size(); ++i) {
                System.out.println(((CssRuleList)atRules.elementAt(i)).toString());
            }
        }
        this.general = new Utf8Properties(this.setDocumentBase(StyleSheetGenerator2.getDocumentName(document)));
        this.general.put("file-title", title);
        this.general.put("today", new Date().toString());
        this.warnings = style.getWarnings();
        this.errors = style.getErrors();
        this.items = style.getRules();
        this.warningLevel = warningLevel;
        this.general.put("errors-count", Integer.toString(this.errors.getErrorCount()));
        this.general.put("warnings-count", Integer.toString(this.warnings.getWarningCount()));
        this.general.put("rules-count", Integer.toString(this.items.size()));
        if (this.errors.getErrorCount() == 0) {
            this.desactivateError();
        }
        if (this.warnings.getWarningCount() == 0 || warningLevel == -1) {
            this.general.put("go-warnings", "");
            this.general.put("warnings", "");
        }
        if (this.items.size() == 0 || !StyleSheetCom.showCSS) {
            this.general.put("go-rules", "");
            this.general.put("rules", "");
        } else {
            this.general.put("no-rules", "");
        }
        if (this.errors.getErrorCount() != 0 || this.warnings.getWarningCount() != 0) {
            this.general.put("no-error-or-warning", "");
        }
        if (Util.onDebug) {
            this.general.list(System.err);
        }
    }

    public void desactivateError() {
        this.general.put("go-errors", "");
        this.general.put("errors", "");
    }

    public void print(PrintWriter out) {
        this.out = out;
        String output = this.processSimple("document");
        if (output != null) {
            out.println(output);
        } else {
            out.println("An error occurred during the output of your style sheet.");
            out.println("Please correct your request ");
            out.println(" or send a mail to  www-validator-css@w3.org");
        }
        out.flush();
    }

    void produceParseException(CssParseException error, StringBuffer ret) {
        if (error.getContexts() != null && error.getContexts().size() != 0) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = error.getContexts().elements();
            while (e.hasMoreElements()) {
                Object t = e.nextElement();
                if (t == null) continue;
                buf.append(t);
                if (!e.hasMoreElements()) continue;
                buf.append(", ");
            }
            if (buf.length() != 0) {
                ret.append("Context : ").append(buf).append(' ');
            }
        }
        if (error.getProperty() != null) {
            ret.append("in property : ").append(error.getProperty());
            ret.append('\n');
        }
        if (error.getException() != null && error.getMessage() != null) {
            ret.append('\t');
            if (error.isParseException()) {
                ret.append(error.getMessage());
            } else {
                Exception ex = error.getException();
                if (ex instanceof NumberFormatException) {
                    ret.append("Invalid number");
                } else {
                    ret.append(ex.getMessage());
                }
            }
            if (error.getSkippedString() != null) {
                ret.append(" : ");
                ret.append(error.getSkippedString());
            } else if (error.getExp() != null) {
                ret.append(" : ");
                error.getExp().starts();
                ret.append(this.queryReplace(error.getExp().toString()));
            }
            ret.append('\n');
        } else {
            ret.append("\t");
            ret.append("Unrecognized ");
            ret.append(" - ");
            ret.append(this.queryReplace(error.getSkippedString()));
            ret.append("\n");
        }
    }

    public void produceError() {
        StringBuffer ret = new StringBuffer(1024);
        String oldSourceFile = null;
        try {
            if (this.errors.getErrorCount() != 0) {
                CssError[] error = this.errors.getErrors();
                for (int i = 0; i < error.length; ++i) {
                    Exception ex = error[i].getException();
                    if (!error[i].getSourceFile().equals(oldSourceFile)) {
                        oldSourceFile = error[i].getSourceFile();
                        ret.append("\nURI : ").append(oldSourceFile);
                        ret.append('\n');
                    }
                    ret.append(" Line : ").append(error[i].getLine());
                    ret.append(" ");
                    if (ex instanceof FileNotFoundException) {
                        ret.append("File not found ");
                        ret.append(ex.getMessage());
                        ret.append('\n');
                        continue;
                    }
                    if (ex instanceof CssParseException) {
                        this.produceParseException((CssParseException)ex, ret);
                        continue;
                    }
                    if (ex instanceof InvalidParamException) {
                        ret.append("\n\t");
                        ret.append(this.queryReplace(ex.getMessage())).append('\n');
                        continue;
                    }
                    if (ex instanceof IOException) {
                        String stringError = ex.toString();
                        int index = stringError.indexOf(58);
                        ret.append(stringError.substring(0, index));
                        ret.append(" : ");
                        ret.append(ex.getMessage()).append('\n');
                        continue;
                    }
                    if (error[i] instanceof CssErrorToken) {
                        CssErrorToken terror = (CssErrorToken)error[i];
                        ret.append("   ");
                        ret.append(terror.getErrorDescription()).append(" : ");
                        ret.append(terror.getSkippedString()).append('\n');
                        continue;
                    }
                    ret.append(ex).append(" \n");
                    if (!(ex instanceof NullPointerException)) continue;
                    ex.printStackTrace();
                }
            }
            this.out.println(ret.toString());
        }
        catch (Exception e) {
            this.out.println("An error appears during error's ouput, sorry.");
            e.printStackTrace();
        }
    }

    public void produceWarning() {
        StringBuffer ret = new StringBuffer(1024);
        String oldSourceFile = "";
        int oldLine = -1;
        String oldMessage = "";
        try {
            if (this.warnings.getWarningCount() != 0) {
                this.warnings.sort();
                Warning[] warning = this.warnings.getWarnings();
                for (int i = 0; i < warning.length; ++i) {
                    Warning warn = warning[i];
                    if (warn.getLevel() > this.warningLevel) continue;
                    if (!warn.getSourceFile().equals(oldSourceFile)) {
                        oldSourceFile = warn.getSourceFile();
                        ret.append("\n URI : ");
                        ret.append(oldSourceFile).append('\n');
                    }
                    oldLine = warn.getLine();
                    oldMessage = warn.getWarningMessage();
                    ret.append("Line : ").append(oldLine);
                    if (warn.getLevel() != 0) {
                        ret.append(" Level : ");
                        ret.append(warn.getLevel());
                    }
                    ret.append(" ").append(oldMessage);
                    if (warn.getContext() != null) {
                        ret.append(" : ").append(warn.getContext());
                    }
                    ret.append(" \n");
                }
            }
            this.out.println(ret.toString());
        }
        catch (Exception e) {
            this.out.println("An error appears during warning's ouput, sorry.");
            e.printStackTrace();
        }
    }

    private String queryReplace(String s) {
        if (s == null) {
            return "[empty string]";
        }
        return s;
    }

    private final String processSimple(String s) {
        return this.processStyle(this.general.getProperty(s), this.general);
    }

    private String processStyle(String str, Utf8Properties prop) {
        if (str == null) {
            return "";
        }
        try {
            int i = 0;
            while ((i = str.indexOf("<!-- #", i)) >= 0) {
                int lastIndexOfEntity = str.indexOf("-->", i);
                String entity = str.substring(i + 6, lastIndexOfEntity - 1).toLowerCase();
                if (entity.equals("warning")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceWarning();
                    continue;
                }
                if (entity.equals("error")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceError();
                    continue;
                }
                String value = prop.getProperty(entity);
                if (value != null) {
                    str = str.substring(0, i) + value + str.substring(lastIndexOfEntity + 3);
                    continue;
                }
                i += 6;
            }
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }

    public static final void printAvailableFormat(PrintWriter out) {
        Enumeration<?> e = availableFormat.propertyNames();
        out.println(" -- listing available output format --");
        while (e.hasMoreElements()) {
            String key = ((String)e.nextElement()).toLowerCase();
            out.println("Format : " + key);
            out.println("   File : " + StyleSheetGenerator2.getDocumentName(key));
        }
        out.flush();
    }

    private Utf8Properties setDocumentBase(String document) {
        Utf8Properties properties = (Utf8Properties)formats.get(document);
        if (properties == null) {
            properties = new Utf8Properties();
            try {
                URL url = StyleSheetGenerator.class.getResource(document);
                InputStream f = url.openStream();
                properties.load(f);
                f.close();
                properties.put("author", "Philippe Le Hegaret");
                properties.put("author-email", "www-validator-css@w3.org");
            }
            catch (Exception e) {
                System.err.println("org.w3c.css.css.StyleSheetGenerator: couldn't load properties " + document);
                System.err.println("  " + e.toString());
                StyleSheetGenerator2.printAvailableFormat(new PrintWriter(System.err));
            }
            formats.put(document, properties);
        }
        return new Utf8Properties(properties);
    }

    private static final String getDocumentName(String documentName) {
        String document = availableFormat.getProperty(documentName.toLowerCase());
        if (document == null) {
            System.err.println("Unable to find " + documentName.toLowerCase() + " output format");
            return documentName;
        }
        return document;
    }

    static {
        formats = new Hashtable();
        availableFormat = new Utf8Properties();
        try {
            URL url = StyleSheetGenerator.class.getResource("format.properties");
            InputStream f = url.openStream();
            availableFormat.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.StyleSheetGenerator: couldn't load format properties ");
            System.err.println("  " + e.toString());
        }
    }
}

