/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.properties.css1.CssBackground;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssBackgroundColor
extends CssProperty {
    CssValue color;
    static CssIdent transparent = new CssIdent("transparent");

    public CssBackgroundColor() {
        this.color = transparent;
    }

    public CssBackgroundColor(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        if (val instanceof CssColor) {
            this.color = val;
            expression.next();
        } else if (val instanceof CssIdent) {
            if (val.equals(inherit)) {
                this.color = inherit;
                expression.next();
            } else {
                this.color = new CssColor(ac, (String)val.get());
                expression.next();
            }
        } else {
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
    }

    public CssBackgroundColor(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.color;
    }

    public final CssValue getColor() {
        return this.color;
    }

    public boolean isSoftlyInherited() {
        return this.color.equals(inherit);
    }

    public String toString() {
        return this.color.toString();
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        CssBackground cssBackground = ((Css1Style)style).cssBackground;
        if (cssBackground.color != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssBackground.color = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getBackgroundColor();
        }
        return ((Css1Style)style).cssBackground.color;
    }

    public boolean equals(CssProperty property) {
        return property instanceof CssBackgroundColor && this.color.equals(((CssBackgroundColor)property).color);
    }

    public String getPropertyName() {
        return "background-color";
    }

    public boolean isDefault() {
        return this.color == transparent;
    }
}

