/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssValue;

public class TextShadowFace
implements CssOperator {
    CssColor color;
    CssLength[] lengths;
    CssValue val;
    char op;

    TextShadowFace(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.val = expression.getValue();
        this.op = expression.getOperator();
        if (this.val instanceof CssColor) {
            this.color = (CssColor)this.val;
            expression.next();
            if (this.op == ' ') {
                this.getLengths(ac, expression);
            }
        } else if (this.val instanceof CssIdent) {
            this.color = new CssColor(ac, (String)this.val.get());
            expression.next();
            if (this.op == ' ') {
                this.getLengths(ac, expression);
            }
        } else if (this.val instanceof CssLength || this.val instanceof CssNumber) {
            this.getLengths(ac, expression);
            this.val = expression.getValue();
            if (this.val instanceof CssColor) {
                this.color = (CssColor)this.val;
                this.op = expression.getOperator();
                expression.next();
            } else if (this.val instanceof CssIdent) {
                this.color = new CssColor(ac, (String)this.val.get());
                this.op = expression.getOperator();
                expression.next();
            }
        } else {
            throw new InvalidParamException("value", expression.getValue(), "text-shadow", ac);
        }
    }

    TextShadowFace(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    void getLengths(ApplContext ac, CssExpression expression) throws InvalidParamException {
        CssLength le = this.getLength(expression.getValue());
        this.op = expression.getOperator();
        if (le != null) {
            this.lengths = new CssLength[3];
            this.lengths[0] = le;
            expression.next();
            le = this.getLength(expression.getValue());
            if (this.op == ' ' && le != null) {
                this.lengths[1] = le;
                this.op = expression.getOperator();
                expression.next();
                le = this.getLength(expression.getValue());
                if (this.op == ' ' && le != null) {
                    this.lengths[2] = le;
                    this.op = expression.getOperator();
                    expression.next();
                }
            } else {
                throw new InvalidParamException("two-lengths", expression.getValue(), "text-shadow", ac);
            }
        }
    }

    CssLength getLength(CssValue val) throws InvalidParamException {
        if (val instanceof CssLength) {
            return (CssLength)val;
        }
        if (val instanceof CssNumber) {
            return ((CssNumber)val).getLength();
        }
        return null;
    }

    public String toString() {
        String ret = "";
        if (this.color != null) {
            ret = ret + " " + this.color;
        }
        if (this.lengths != null) {
            ret = ret + " " + this.lengths[0] + " " + this.lengths[1];
            if (this.lengths[2] != null) {
                ret = ret + " " + this.lengths[2];
            }
        }
        return ret.substring(1);
    }
}

