/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.properties.css3.Css3Style;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssValue;

public class CssOpacity
extends CssProperty
implements CssOperator {
    String opaclevel;
    ApplContext ac;

    public CssOpacity() {
        CssNumber cssnum = new CssNumber(1.0f);
        this.opaclevel = cssnum.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CssOpacity(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.ac = ac;
        this.setByUser();
        CssValue val = expression.getValue();
        if (val instanceof CssNumber) {
            CssNumber cssnum = new CssNumber(this.clampedValue(ac, ((CssNumber)val).getValue()));
            this.opaclevel = cssnum.toString();
            expression.next();
            return;
        } else {
            if (!(val instanceof CssIdent)) throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            if (!val.equals(inherit)) throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            this.opaclevel = "inherit";
            expression.next();
        }
    }

    public CssOpacity(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    private float clampedValue(ApplContext ac, float opac) {
        if (opac < 0.0f || opac > 1.0f) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(opac));
            return !(opac < 0.0f) ? 1 : 0;
        }
        return opac;
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        if (((Css3Style)style).cssOpacity != null) {
            style.addRedefinitionWarning(ac, this);
        }
        ((Css3Style)style).cssOpacity = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css3Style)style).getOpacity();
        }
        return ((Css3Style)style).cssOpacity;
    }

    public boolean equals(CssProperty property) {
        return property instanceof CssOpacity && this.opaclevel.equals(((CssOpacity)property).opaclevel);
    }

    public String getPropertyName() {
        return "opacity";
    }

    public Object get() {
        return this.opaclevel;
    }

    public boolean isSoftlyInherited() {
        return this.opaclevel.equals("inherit");
    }

    public String toString() {
        return this.opaclevel;
    }

    public boolean isDefault() {
        CssNumber cssnum = new CssNumber(this.ac, 1.0f);
        return this.opaclevel == cssnum.toString();
    }
}

