/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.util.Hashtable;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.RGB;

public class CssColorCSS2
extends CssColor {
    Object color;
    RGB rgb;
    static Hashtable definedColors;
    static CssIdent inherit;

    public CssColorCSS2() {
    }

    public CssColorCSS2(ApplContext ac, String s) throws InvalidParamException {
        this.setIdentColor(s, ac);
    }

    public void set(String s, ApplContext ac) throws InvalidParamException {
        if (s.startsWith("#")) {
            this.setShortRGBColor(s.toLowerCase(), ac);
        } else {
            this.setIdentColor(s, ac);
        }
    }

    public Object get() {
        if (this.color != null) {
            if (this.color == inherit) {
                return null;
            }
            return this.color;
        }
        return this.rgb.r;
    }

    public boolean isDefault() {
        return this.color == inherit;
    }

    public String toString() {
        if (this.color != null) {
            if (this.color == inherit) {
                return inherit.toString();
            }
            return this.color.toString();
        }
        return this.rgb.toString();
    }

    public void setRGBColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        CssNumber number;
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        this.color = null;
        this.rgb = new RGB();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            this.rgb.r = CssColorCSS2.clippedIntValue(number.getInt(), ac);
            this.rgb.setPercent(false);
        } else if (val instanceof CssPercentage) {
            this.rgb.r = CssColorCSS2.clippedPercentValue(((Float)val.get()).floatValue(), ac);
            this.rgb.setPercent(true);
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            if (this.rgb.isPercent()) {
                throw new InvalidParamException("percent", val, ac);
            }
            this.rgb.g = CssColorCSS2.clippedIntValue(number.getInt(), ac);
        } else if (val instanceof CssPercentage) {
            if (!this.rgb.isPercent()) {
                throw new InvalidParamException("integer", val, ac);
            }
            this.rgb.g = CssColorCSS2.clippedPercentValue(((Float)val.get()).floatValue(), ac);
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            if (this.rgb.isPercent()) {
                throw new InvalidParamException("percent", val, ac);
            }
            this.rgb.b = CssColorCSS2.clippedIntValue(number.getInt(), ac);
        } else if (val instanceof CssPercentage) {
            if (!this.rgb.isPercent()) {
                throw new InvalidParamException("integer", val, ac);
            }
            this.rgb.b = CssColorCSS2.clippedPercentValue(((Float)val.get()).floatValue(), ac);
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        exp.next();
        if (exp.getValue() != null) {
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    private void setShortRGBColor(String s, ApplContext ac) throws InvalidParamException {
        int b;
        int g;
        int r;
        this.rgb = new RGB();
        this.color = null;
        if ((s = s.substring(1)).length() != 3 && s.length() != 6) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (s.length() == 3) {
            String sh = s.substring(0, 1);
            r = Integer.parseInt(sh + sh, 16);
            sh = s.substring(1, 2);
            g = Integer.parseInt(sh + sh, 16);
            sh = s.substring(2, 3);
            b = Integer.parseInt(sh + sh, 16);
        } else {
            r = Integer.parseInt(s.substring(0, 2), 16);
            g = Integer.parseInt(s.substring(2, 4), 16);
            b = Integer.parseInt(s.substring(4, 6), 16);
        }
        this.rgb.r = new Integer(r);
        this.rgb.g = new Integer(g);
        this.rgb.b = new Integer(b);
        this.rgb.output = "#" + s;
    }

    private void setIdentColor(String s, ApplContext ac) throws InvalidParamException {
        String lower_s = s.toLowerCase();
        if (definedColors.get(lower_s) != null) {
            Object obj = definedColors.get(lower_s);
            if (obj instanceof RGB) {
                this.color = lower_s;
                this.rgb = (RGB)obj;
            } else if (obj instanceof String) {
                this.color = (String)obj;
                if (!obj.equals(s)) {
                    ac.getFrame().addWarning("color.mixed-capitalization", s);
                }
            }
            return;
        }
        throw new InvalidParamException("value", s, "color", ac);
    }

    private static Integer clippedIntValue(int rgb, ApplContext ac) {
        if (rgb < 0 || rgb > 255) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(rgb));
            return new Integer(rgb < 0 ? 0 : 255);
        }
        return new Integer(rgb);
    }

    private static Float clippedPercentValue(float p, ApplContext ac) {
        if ((double)p < 0.0 || (double)p > 100.0) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
            return new Float((double)p < 0.0 ? 0.0 : 100.0);
        }
        return new Float(p);
    }

    public boolean equals(Object cssColor) {
        return cssColor instanceof CssColorCSS2 && (this.color != null && this.color.equals(((CssColorCSS2)cssColor).color) || this.color == null && this.rgb != null && ((CssColorCSS2)cssColor).rgb != null && this.rgb.r.equals(((CssColorCSS2)cssColor).rgb.r) && this.rgb.g.equals(((CssColorCSS2)cssColor).rgb.g) && this.rgb.b.equals(((CssColorCSS2)cssColor).rgb.b));
    }

    public Object getRed() {
        return this.rgb.r;
    }

    public Object getGreen() {
        return this.rgb.g;
    }

    public Object getBlue() {
        return this.rgb.b;
    }

    static {
        inherit = new CssIdent("inherit");
        definedColors = new Hashtable();
        definedColors.put("black", new RGB(new Integer(0), new Integer(0), new Integer(0)));
        definedColors.put("silver", new RGB(new Integer(192), new Integer(192), new Integer(192)));
        definedColors.put("gray", new RGB(new Integer(128), new Integer(128), new Integer(128)));
        definedColors.put("white", new RGB(new Integer(255), new Integer(255), new Integer(255)));
        definedColors.put("maroon", new RGB(new Integer(128), new Integer(0), new Integer(0)));
        definedColors.put("red", new RGB(new Integer(255), new Integer(0), new Integer(0)));
        definedColors.put("purple", new RGB(new Integer(128), new Integer(0), new Integer(128)));
        definedColors.put("fuchsia", new RGB(new Integer(255), new Integer(0), new Integer(255)));
        definedColors.put("green", new RGB(new Integer(0), new Integer(128), new Integer(0)));
        definedColors.put("lime", new RGB(new Integer(0), new Integer(255), new Integer(0)));
        definedColors.put("olive", new RGB(new Integer(128), new Integer(128), new Integer(0)));
        definedColors.put("yellow", new RGB(new Integer(255), new Integer(255), new Integer(0)));
        definedColors.put("navy", new RGB(new Integer(0), new Integer(0), new Integer(128)));
        definedColors.put("blue", new RGB(new Integer(0), new Integer(0), new Integer(255)));
        definedColors.put("teal", new RGB(new Integer(0), new Integer(128), new Integer(128)));
        definedColors.put("aqua", new RGB(new Integer(0), new Integer(255), new Integer(255)));
        definedColors.put("activeborder", "ActiveBorder");
        definedColors.put("activecaption", "ActiveCaption");
        definedColors.put("appworkspace", "AppWorkspace");
        definedColors.put("background", "Background");
        definedColors.put("buttonface", "ButtonFace");
        definedColors.put("buttonhighlight", "ButtonHighlight");
        definedColors.put("buttonshadow", "ButtonShadow");
        definedColors.put("buttontext", "ButtonText");
        definedColors.put("captiontext", "CaptionText");
        definedColors.put("graytext", "GrayText");
        definedColors.put("highlight", "Highlight");
        definedColors.put("highlighttext", "HighlightText");
        definedColors.put("inactiveborder", "InactiveBorder");
        definedColors.put("inactivecaption", "InactiveCaption");
        definedColors.put("inactivecaptiontext", "InactiveCaptionText");
        definedColors.put("infobackground", "InfoBackground");
        definedColors.put("infotext", "InfoText");
        definedColors.put("menu", "Menu");
        definedColors.put("menutext", "MenuText");
        definedColors.put("scrollbar", "Scrollbar");
        definedColors.put("threeddarkshadow", "ThreeDDarkShadow");
        definedColors.put("threedface", "ThreeDFace");
        definedColors.put("threedhighlight", "ThreeDHighlight");
        definedColors.put("threedlightshadow", "ThreeDLightShadow");
        definedColors.put("threedshadow", "ThreeDShadow");
        definedColors.put("window", "Window");
        definedColors.put("windowframe", "WindowFrame");
        definedColors.put("windowtext", "WindowText");
    }
}

