/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssValue;

public class CssFrequency
extends CssValue {
    private Float value;
    private int unit;
    private static String[] units = new String[]{"Hz", "kHz"};
    private static int[] hash_units;
    private static Float defaultValue;

    public CssFrequency() {
        this.value = defaultValue;
    }

    public CssFrequency(Float value) {
        this.value = value;
    }

    public void set(String s, ApplContext ac) throws InvalidParamException {
        int i;
        float v;
        String unit;
        int length;
        if ((s = s.toLowerCase()).charAt((length = s.length()) - 3) == 'k') {
            unit = s.substring(length - 3, length);
            v = new Float(s.substring(0, length - 3)).floatValue();
        } else {
            unit = s.substring(length - 2, length);
            v = new Float(s.substring(0, length - 2)).floatValue();
        }
        int hash = unit.hashCode();
        for (i = 0; i < units.length; ++i) {
            if (hash != hash_units[i]) continue;
            this.unit = i;
            break;
        }
        if (i == units.length) {
            throw new InvalidParamException("unit", unit, ac);
        }
        this.value = new Float(v);
    }

    public Object get() {
        if (this.unit == 1) {
            return new Float(this.value.floatValue() * 1000.0f);
        }
        return this.value;
    }

    public String getUnit() {
        return units[this.unit];
    }

    public String toString() {
        if (this.value.floatValue() != 0.0f) {
            return Util.displayFloat(this.value) + this.getUnit();
        }
        return Util.displayFloat(this.value);
    }

    public boolean equals(Object value) {
        return value instanceof CssFrequency && this.value.equals(((CssFrequency)value).value) && this.unit == ((CssFrequency)value).unit;
    }

    static {
        defaultValue = new Float(0.0f);
        hash_units = new int[units.length];
        for (int i = 0; i < units.length; ++i) {
            CssFrequency.hash_units[i] = units[i].toLowerCase().hashCode();
        }
    }
}

