/*
 * Decompiled with CFR 0.152.
 */
package html.tags;

import html.parser.Attributes;
import html.parser.Element;
import html.tags.HtmlTag;
import html.tags.ParserFrame;
import html.tree.ActiveTree;
import java.io.ByteArrayInputStream;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.selectors.TypeSelector;
import org.w3c.css.util.InvalidParamException;

public abstract class HtmlTree
extends ActiveTree
implements HtmlTag {
    Element elem;
    Attributes atts;
    int line;
    ParserFrame parserFrame = null;
    CssSelectors context = null;
    protected static int autoIdCount = 0;

    public void initialize(Element elem, Attributes atts, ParserFrame parserFrame) {
        this.elem = elem;
        this.atts = atts;
        this.parserFrame = parserFrame;
        this.line = parserFrame.line;
        this.checkStyleAttribute();
    }

    public abstract boolean isBlock();

    public boolean isPreformatted() {
        return false;
    }

    public Element getElement() {
        return this.elem;
    }

    public Attributes getAttributes() {
        return this.atts;
    }

    public StyleSheet getStyleSheet() {
        return this.parserFrame.styleSheetParser.getStyleSheet();
    }

    public CssSelectors getContext() throws InvalidParamException {
        if (this.context != null) {
            return this.context;
        }
        HtmlTree atl = (HtmlTree)this.getParent();
        this.context = atl == null ? new CssSelectors(this.parserFrame.ac) : new CssSelectors(atl.getContext());
        this.context.addType(new TypeSelector(this.getElement().getName().toUpperCase()));
        if (this.atts != null) {
            for (int i = 0; i < this.atts.length(); ++i) {
                try {
                    this.context.addAttribute(this.atts.getName(i), this.atts.get(i));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.context;
    }

    public void checkStyleAttribute() {
        if (this.atts == null) {
            return;
        }
        String style = this.atts.get("style");
        String id = this.atts.get("id");
        if (style != null) {
            if (id == null) {
                id = "#auto" + autoIdCount;
                id = id + "" + autoIdCount++;
                if (Boolean.getBoolean("html.tree.debug")) {
                    System.out.println("HtmlTree::checkStyleAttribute(): adding id: " + id + " to node: " + this.elem.getName());
                }
                this.atts.put("id", id);
            }
            this.parserFrame.styleSheetParser.parseStyleAttribute(this.parserFrame.ac, new ByteArrayInputStream(style.getBytes()), id, this.parserFrame.url, this.line);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.elem + "," + this.atts + "," + this.arity() + "]";
    }
}

