/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.css.css.CssCascadingOrder;
import org.w3c.css.css.CssRuleList;
import org.w3c.css.css.CssStyleRule;
import org.w3c.css.css.StyleSheetGenerator;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.parser.Errors;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.SortedHashtable;
import org.w3c.css.util.Warnings;

public class StyleSheet {
    private CssCascadingOrder cascading;
    private SortedHashtable rules;
    private Errors errors;
    private Warnings warnings;
    private String type;
    private Vector atRuleList;
    private boolean doNotAddRule;
    private boolean doNotAddAtRule;
    private static final boolean debug = false;
    String selectortext;
    boolean important;
    Vector properties;
    String indent = new String();
    public String charset;

    public StyleSheet() {
        this.rules = new SortedHashtable();
        this.errors = new Errors();
        this.warnings = new Warnings();
        this.cascading = new CssCascadingOrder();
        this.atRuleList = new Vector();
    }

    public CssStyle getStyle(CssSelectors context) {
        if (this.getContext(context) != null) {
            CssSelectors realContext = this.getContext(context);
            CssStyle style = realContext.getStyle();
            style.setStyleSheet(this);
            style.setSelector(realContext);
            return style;
        }
        this.getRules().put(context, context);
        context.getStyle().setStyleSheet(this);
        context.getStyle().setSelector(context);
        return context.getStyle();
    }

    public void addProperty(CssSelectors selector, CssProperty property) {
        this.getContext(selector).addProperty(property, this.warnings);
    }

    public void remove(CssSelectors selector) {
        this.rules.remove(selector);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        if (this.type == null) {
            return "text/css";
        }
        return this.type;
    }

    public void addErrors(Errors errors) {
        if (errors.getErrorCount() != 0) {
            this.getErrors().addErrors(errors);
        }
    }

    public void addWarnings(Warnings warnings) {
        if (warnings.getWarningCount() != 0) {
            this.getWarnings().addWarnings(warnings);
        }
    }

    public final Errors getErrors() {
        return this.errors;
    }

    public final Warnings getWarnings() {
        return this.warnings;
    }

    public final Hashtable getRules() {
        return this.rules;
    }

    public final CssProperty CascadingOrder(CssProperty property, StyleSheet style, CssSelectors selector) {
        return this.cascading.order(property, style, selector);
    }

    public void findConflicts(ApplContext ac) {
        Enumeration e = this.getRules().elements();
        while (e.hasMoreElements()) {
            CssSelectors sel = (CssSelectors)e.nextElement();
            sel.findConflicts(ac, this.warnings, this.getRules().elements());
        }
    }

    protected CssSelectors getContext(CssSelectors selector) {
        if (this.getRules().containsKey(selector)) {
            return (CssSelectors)this.getRules().get(selector);
        }
        if (selector.getNext() != null) {
            CssSelectors next = this.getContext(selector.getNext());
            selector.setNext(next);
        }
        this.getRules().put(selector, selector);
        return selector;
    }

    public void dump() {
        StyleSheetGenerator style = new StyleSheetGenerator("", this, "text", -1);
        style.print(new PrintWriter(System.out));
    }

    public void addCharSet(String charset) {
        this.charset = charset;
    }

    public void newAtRule(AtRule atRule) {
        CssRuleList rulelist = new CssRuleList();
        rulelist.addAtRule(atRule);
        this.atRuleList.addElement(rulelist);
        this.indent = "   ";
    }

    public void endOfAtRule() {
        if (!this.doNotAddAtRule) {
            CssRuleList rulelist = new CssRuleList();
            this.atRuleList.addElement(rulelist);
        }
        this.important = false;
        this.selectortext = "";
        this.indent = "";
        this.doNotAddAtRule = false;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public void setSelectorList(Vector selectors) {
        String slave = selectors.toString();
        this.selectortext = slave.substring(slave.indexOf("[") + 1, slave.lastIndexOf("]"));
    }

    public void setProperty(Vector properties) {
        this.properties = properties;
    }

    public void endOfRule() {
        if (!this.doNotAddRule) {
            CssRuleList rulelist;
            CssStyleRule stylerule = new CssStyleRule(this.indent, this.selectortext, this.properties, this.important);
            if (!this.atRuleList.isEmpty()) {
                rulelist = (CssRuleList)this.atRuleList.lastElement();
                boolean useless = this.atRuleList.removeElement(rulelist);
            } else {
                rulelist = new CssRuleList();
            }
            rulelist.addStyleRule(stylerule);
            this.atRuleList.addElement(rulelist);
        }
        this.selectortext = "";
        this.doNotAddRule = false;
    }

    public void removeThisRule() {
        this.doNotAddRule = true;
    }

    public void removeThisAtRule() {
        this.doNotAddAtRule = true;
    }

    public Vector newGetRules() {
        return this.atRuleList;
    }
}

