/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.zip;

import java.io.File;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.zip.ZipDirectoryResource;
import org.w3c.jigsaw.zip.ZipFileResource;
import org.w3c.tools.resources.ContainerInterface;
import org.w3c.tools.resources.ContainerResource;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.sorter.Sorter;

public class ZipFrame
extends HTTPFrame {
    protected ZipFileResource zipfresource = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean computeContainerListing(boolean bl) {
        ContainerResource containerResource = (ContainerResource)this.resource;
        if (!bl && this.listing != null && containerResource.getLastModified() <= this.listing_stamp && this.getLastModified() <= this.listing_stamp) {
            return false;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.frames.HTTPFrame");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        Enumeration enumeration = containerResource.enumerateResourceIdentifiers();
        Vector vector = Sorter.sortStringEnumeration(enumeration);
        HtmlGenerator htmlGenerator = new HtmlGenerator("Index of " + containerResource.getIdentifier());
        this.addStyleSheet(htmlGenerator);
        htmlGenerator.append("<h1>" + containerResource.getIdentifier() + "</h1>");
        if (containerResource.getParent() != null) {
            htmlGenerator.append("<p><a href=\"..\">Parent</a><br>");
        }
        int n = 0;
        while (true) {
            block26: {
                if (n >= vector.size()) {
                    htmlGenerator.close();
                    this.listing_stamp = this.getLastModified();
                    this.listing = htmlGenerator;
                    return true;
                }
                String string = (String)vector.elementAt(n);
                ResourceReference resourceReference = null;
                long l = -1L;
                resourceReference = containerResource.lookup(string);
                FramedResource framedResource = null;
                if (resourceReference != null) {
                    Object var14_12;
                    block28: {
                        block27: {
                            try {
                                try {
                                    FramedResource framedResource2;
                                    framedResource = (FramedResource)resourceReference.lock();
                                    if (framedResource instanceof ZipFileResource) {
                                        framedResource2 = (ZipFileResource)framedResource;
                                        if (!((ZipFileResource)framedResource2).hasEntry()) {
                                            try {
                                                framedResource2.delete();
                                            }
                                            catch (MultipleLockException multipleLockException) {
                                            }
                                            var14_12 = null;
                                            resourceReference.unlock();
                                            break block26;
                                        }
                                        l = ((ZipFileResource)framedResource2).getEntrySize();
                                    }
                                    if (framedResource instanceof ZipDirectoryResource && !((ZipDirectoryResource)(framedResource2 = (ZipDirectoryResource)framedResource)).hasEntry()) {
                                        try {
                                            ((DirectoryResource)framedResource2).delete();
                                        }
                                        catch (MultipleLockException multipleLockException) {
                                        }
                                        break block27;
                                    }
                                    framedResource2 = null;
                                    if (clazz != null) {
                                        framedResource2 = (HTTPFrame)framedResource.getFrame(clazz);
                                    }
                                    if (framedResource2 != null) {
                                        String string2 = ((HTTPFrame)framedResource2).getIcon();
                                        if (string2 != null) {
                                            htmlGenerator.append("<img src=\"" + this.getIconDirectory() + "/" + string2 + "\" alt=\"" + string2 + "\">");
                                        }
                                        if (framedResource instanceof ContainerInterface) {
                                            htmlGenerator.append("<a href=\"", URLEncoder.encode(string), "/\">" + string + "</a>");
                                        } else {
                                            htmlGenerator.append("<a href=\"", URLEncoder.encode(string), "\">" + string + "</a>");
                                        }
                                        String string3 = ((HTTPFrame)framedResource2).getTitle();
                                        if (string3 != null) {
                                            htmlGenerator.append(" " + string3);
                                        }
                                        if (l != -1L) {
                                            String string4 = null;
                                            string4 = l > 1023L ? " [" + l / 1024L + " Kb]" : " [" + l + " bytes]";
                                            htmlGenerator.append(string4);
                                        }
                                        htmlGenerator.append("<br>\n");
                                        break block28;
                                    } else {
                                        htmlGenerator.append(String.valueOf(string) + " (<i>Not available via HTTP.</i>)");
                                        htmlGenerator.append("<br>\n");
                                    }
                                    break block28;
                                }
                                catch (InvalidResourceException invalidResourceException) {
                                    htmlGenerator.append(String.valueOf(string) + " cannot be loaded (server misconfigured)");
                                    htmlGenerator.append("<br>\n");
                                    var14_12 = null;
                                    resourceReference.unlock();
                                    break block26;
                                }
                            }
                            catch (Throwable throwable) {
                                var14_12 = null;
                                resourceReference.unlock();
                                throw throwable;
                            }
                        }
                        var14_12 = null;
                        resourceReference.unlock();
                        break block26;
                    }
                    var14_12 = null;
                    resourceReference.unlock();
                }
            }
            ++n;
        }
    }

    protected Reply createFileReply(Request request) throws ProtocolException, ResourceException {
        Reply reply = null;
        if (this.zipfresource == null) {
            throw new ResourceException("this frame is not attached to a ZipFileResource. (" + this.resource.getIdentifier() + ")");
        }
        reply = this.createDefaultReply(request, 200);
        InputStream inputStream = this.zipfresource.getInputStream();
        if (inputStream != null) {
            reply.setStream(inputStream);
        }
        return reply;
    }

    protected Reply getFileResource(Request request) throws ProtocolException, ResourceException {
        if (this.fresource == null) {
            throw new ResourceException("this frame is not attached to a FileResource. (" + this.resource.getIdentifier() + ")");
        }
        Reply reply = null;
        File file = this.fresource.getFile();
        this.fresource.checkContent();
        this.updateCachedHeaders();
        int n = this.checkIfMatch(request);
        if (n == 1 || n == 3) {
            reply = request.makeReply(412);
            reply.setContent("Pre-conditions failed.");
            reply.setContentMD5(null);
            return reply;
        }
        if (this.checkIfUnmodifiedSince(request) == 1) {
            reply = request.makeReply(412);
            reply.setContent("Pre-conditions failed.");
            reply.setContentMD5(null);
            return reply;
        }
        if (this.checkValidators(request) == 1) {
            return this.createDefaultReply(request, 304);
        }
        if (this.zipfresource.hasEntry()) {
            reply = this.createFileReply(request);
            if (request.hasState("org.w3c.jigsaw.frames.HTTPFrame.cl")) {
                reply.setContentLocation(this.getURL(request).toExternalForm());
            }
            return reply;
        }
        return this.deleteMe(request);
    }

    public Reply put(Request request) throws ProtocolException, ResourceException {
        Reply reply = request.makeReply(501);
        reply.setContent("Method PUT not implemented for zipped document");
        throw new HTTPException(reply);
    }

    public void registerResource(FramedResource framedResource) {
        super.registerResource(framedResource);
        if (framedResource instanceof ZipFileResource) {
            this.zipfresource = (ZipFileResource)framedResource;
        }
    }
}

