/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import org.w3c.util.UnixException;

public class Unix {
    private static final String NATIVE_LIBRARY = "Unix";
    private static boolean haslibrary = false;
    private static Unix that = null;

    public void chroot(String string) throws UnixException {
        if (string == null) {
            throw new NullPointerException("chroot: root == null");
        }
        if (!this.libunix_chRoot(string)) {
            throw new UnixException("chroot failed");
        }
    }

    public int getGID(String string) {
        if (string == null) {
            return -1;
        }
        return this.libunix_getGID(string);
    }

    public int getUID(String string) {
        if (string == null) {
            return -1;
        }
        return this.libunix_getUID(string);
    }

    public static synchronized Unix getUnix() {
        if (that == null) {
            try {
                System.loadLibrary(NATIVE_LIBRARY);
                haslibrary = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                haslibrary = false;
            }
            catch (RuntimeException runtimeException) {
                haslibrary = false;
            }
            that = new Unix();
        }
        return that;
    }

    public boolean isResolved() {
        return haslibrary;
    }

    private native boolean libunix_chRoot(String var1);

    private native int libunix_getGID(String var1);

    private native int libunix_getUID(String var1);

    private native boolean libunix_setGID(int var1);

    private native boolean libunix_setUID(int var1);

    public void setGID(int n) throws UnixException {
        if (!this.libunix_setGID(n)) {
            throw new UnixException("setgid failed");
        }
    }

    public void setUID(int n) throws UnixException {
        if (!this.libunix_setUID(n)) {
            throw new UnixException("setuid failed");
        }
    }
}

